/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.action.proto;

import java.math.BigDecimal;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.Pageable;
import ru.bgcrm.plugin.bgbilling.proto.dao.BillDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.bill.Bill;
import ru.bgcrm.plugin.bgbilling.proto.model.bill.Invoice;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/bgbilling/proto/bill", pathId=true)
public class BillAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/bgbilling/bill";

    public ActionForward attributeList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int moduleId = form.getParamInt("moduleId");
        form.setResponseData("list", new BillDAO(form.getUser(), billingId, moduleId).getAttributeList(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/bill/attribute_list.jsp");
    }

    public ActionForward docTypeList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int moduleId = form.getParamInt("moduleId");
        BillDAO billDao = new BillDAO(form.getUser(), billingId, moduleId);
        form.setResponseData("billTypeList", billDao.getContractDocTypeList(contractId, "bill"));
        form.setResponseData("invoiceTypeList", billDao.getContractDocTypeList(contractId, "invoice"));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/bill/doc_type_list.jsp");
    }

    public ActionForward docTypeAdd(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int moduleId = form.getParamInt("moduleId");
        new BillDAO(form.getUser(), billingId, moduleId).contractDocTypeAdd(contractId, form.getParam("typeIds"));
        return this.json(conSet, form);
    }

    public ActionForward docTypeDelete(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int moduleId = form.getParamInt("moduleId");
        new BillDAO(form.getUser(), billingId, moduleId).contractDocTypeDelete(contractId, form.getParam("typeIds"));
        return this.json(conSet, form);
    }

    public ActionForward documentList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int moduleId = form.getParamInt("moduleId");
        String mode = form.getParam("mode", "bill");
        form.setParam("mode", mode);
        BillDAO billDao = new BillDAO(form.getUser(), billingId, moduleId);
        if ("bill".equals(mode)) {
            billDao.searchBillList(contractId, new Pageable<Bill>(form));
        } else {
            billDao.searchInvoiceList(contractId, new Pageable<Invoice>(form));
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/bill/document_list.jsp");
    }

    public ActionForward getDocument(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int moduleId = form.getParamInt("moduleId");
        String type = form.getParam("type");
        String ids = form.getParam("ids");
        try {
            HttpServletResponse response = form.getHttpResponse();
            ServletOutputStream out = response.getOutputStream();
            Utils.setFileNameHeaders(response, type + ".pdf");
            out.write(new BillDAO(form.getUser(), billingId, moduleId).getDocumentsPdf(ids, type));
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return null;
    }

    public ActionForward setPayed(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int moduleId = form.getParamInt("moduleId");
        String ids = form.getParam("ids");
        Date date = form.getParamDate("date");
        BigDecimal summa = Utils.parseBigDecimal(form.getParam("summa"));
        String comment = form.getParam("comment");
        BillDAO billDao = new BillDAO(form.getUser(), billingId, moduleId);
        if (date != null) {
            billDao.setPayed(ids, true, date, summa, comment);
        } else {
            billDao.setPayed(ids, false, null, null, null);
        }
        return this.json(conSet, form);
    }
}

