/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.asterisk.ami;

import org.asteriskjava.manager.event.AbstractChannelStateEvent;
import org.bgerp.dao.message.call.CallRegistration;
import ru.bgcrm.dao.message.MessageTypeCall;
import ru.bgcrm.util.Utils;

public class Call {
    private final MessageTypeCall messageType;
    private volatile CallRegistration reg;
    private volatile String numberOur;
    private volatile String numberTheir;
    private volatile boolean stored;

    Call(MessageTypeCall messageType) {
        this.messageType = messageType;
    }

    CallRegistration getReg() {
        return this.reg;
    }

    String getNumberOur() {
        return this.numberOur;
    }

    String getNumberTheir() {
        return this.numberTheir;
    }

    public boolean isStored() {
        return this.stored;
    }

    public void stored() {
        this.stored = true;
    }

    Call event(AbstractChannelStateEvent event) {
        String connectedLineNum = event.getConnectedLineNum();
        String callerIdNum = event.getCallerIdNum();
        String exten = event.getExten();
        if (this.reg == null) {
            this.resolve(callerIdNum, connectedLineNum, exten);
        }
        if (this.reg == null) {
            this.resolve(connectedLineNum, callerIdNum, exten);
        }
        return this;
    }

    private void resolve(String our, String their, String exten) {
        this.reg = this.messageType.getRegistrationByNumber(our);
        if (this.reg != null) {
            this.numberOur = our;
            this.numberTheir = their;
            if (Utils.notBlankString(exten) && Utils.isBlankString(this.numberTheir)) {
                this.numberTheir = exten;
            }
        }
    }

    public String toString() {
        return "Call reg: " + String.valueOf(this.reg) + ", number our: " + this.numberOur + ", their: " + this.numberTheir;
    }
}

