/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.UserCache;
import org.bgerp.util.Log;
import ru.bgcrm.event.GetPoolTasksEvent;
import ru.bgcrm.event.client.LockEvent;
import ru.bgcrm.model.Lock;
import ru.bgcrm.util.sql.ConnectionSet;

public class Locker {
    private static final Log log = Log.getLog();
    private static Map<String, Lock> locksById = new ConcurrentHashMap<String, Lock>();
    private static Map<Integer, Set<Lock>> locksByUser = new ConcurrentHashMap<Integer, Set<Lock>>();

    public Locker() {
        EventProcessor.subscribe(new EventListener<GetPoolTasksEvent>(this){

            @Override
            public void notify(GetPoolTasksEvent e, ConnectionSet conSet) {
                Set<Lock> locks = locksByUser.get(e.getUser().getId());
                if (locks != null) {
                    for (Lock lock : locks) {
                        e.getForm().getResponse().addEvent(new LockEvent(lock));
                        lock.continueTime();
                    }
                }
            }
        }, GetPoolTasksEvent.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addLock(Lock lock) throws BGMessageException {
        Lock existLock = locksById.get(lock.getId());
        if (existLock != null) {
            if (existLock.getUserId() != lock.getUserId()) {
                if (existLock.getToTime() >= System.currentTimeMillis()) throw new BGMessageException("\u0420\u0435\u0441\u0443\u0440\u0441 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c: {}", UserCache.getUser(existLock.getUserId()).getTitle());
                Locker.freeLock(existLock);
            } else {
                log.debug("Move lock time: {}", lock.getId());
                lock.continueTime();
                return;
            }
        }
        log.debug("Add lock: {}", lock.getId());
        Set<Lock> locks = locksByUser.get(lock.getUserId());
        if (locks == null) {
            locks = new HashSet<Lock>();
            locksByUser.put(lock.getUserId(), locks);
        }
        locksById.put(lock.getId(), lock);
        locks.add(lock);
    }

    public static boolean checkLock(String id) {
        boolean result = false;
        Lock lock = locksById.get(id);
        if (lock != null && (result = lock.getToTime() < System.currentTimeMillis())) {
            Locker.freeLock(lock);
        }
        return result;
    }

    public static void freeLock(Lock lock) {
        log.debug("Free lock: {}", lock.getId());
        locksById.remove(lock.getId());
        Set<Lock> locks = locksByUser.get(lock.getUserId());
        if (locks != null) {
            locks.remove(lock);
        }
    }
}

