/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.telegram;

import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGMessageException;

public class Config
extends org.bgerp.app.cfg.Config {
    private final String token;
    private final String userName;
    private final int userParamId;
    private final int processParamId;
    private final boolean botStart;
    private final String msgWrongPassword;
    private final String msgAskLogin;
    private final String msgAskPassword;
    private final String msgLinkChange;
    private final String msgDefaultAnswer;
    private final String msgUrlHelp;
    private final String proxyHost;
    private final String proxyPort;
    private final String proxyType;

    protected Config(ConfigMap config, boolean validate) throws BGMessageException {
        super(null, validate);
        config = config.sub("telegram:");
        this.botStart = config.getSokBoolean(false, validate, "botStart", "bot_start");
        this.token = config.get("token", "");
        this.userName = config.getSok("botName", validate, "botName", "bot_name");
        this.userParamId = config.getInt("userParamId", -1);
        this.processParamId = config.getInt("processParamId", -1);
        this.proxyHost = config.get("proxyHost");
        this.proxyPort = config.get("proxyPort");
        this.proxyType = config.get("proxyType");
        this.msgWrongPassword = config.get("msgWrongPassword", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b");
        this.msgAskLogin = config.get("msgAskLogin", "\u0414\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f\u043c bgerp \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0432\u043e\u0439 \u043b\u043e\u0433\u0438\u043d");
        this.msgAskPassword = config.get("msgAskPassword", "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c");
        this.msgLinkChange = config.get("msgLinkChange", "\u0422\u0435\u043f\u0435\u0440\u044c \u0432\u044b \u0431\u0443\u0434\u0435\u0442\u0435 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u044c \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f");
        this.msgDefaultAnswer = config.get("msgDefaultAnswer", "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 /login \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0438\u043b\u0438 /getid, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u0432\u043e\u0439 telegramId");
        this.msgUrlHelp = config.get("msgUrlHelp", "https://bgerp.org/doc/3.0/manual/plugin/telegram/index.html");
    }

    public String getToken() {
        return this.token;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getUserParamId() {
        return this.userParamId;
    }

    public int getProcessParamId() {
        return this.processParamId;
    }

    public boolean isBotStart() {
        return this.botStart;
    }

    public String getMsgWrongPassword() {
        return this.msgWrongPassword;
    }

    public String getMsgAskLogin() {
        return this.msgAskLogin;
    }

    public String getMsgAskPassword() {
        return this.msgAskPassword;
    }

    public String getMsgLinkChange() {
        return this.msgLinkChange;
    }

    public String getMsgDefaultAnswer() {
        return this.msgDefaultAnswer;
    }

    public String getMsgUrlHelp() {
        return this.msgUrlHelp;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyType() {
        return this.proxyType;
    }
}

