/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.telegram;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.bgerp.app.cfg.Setup;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.plugin.telegram.CommandHandler;
import org.bgerp.plugin.telegram.Config;
import org.bgerp.util.Log;
import org.telegram.telegrambots.client.okhttp.OkHttpTelegramClient;
import org.telegram.telegrambots.longpolling.BotSession;
import org.telegram.telegrambots.longpolling.TelegramBotsLongPollingApplication;
import org.telegram.telegrambots.longpolling.interfaces.LongPollingUpdateConsumer;
import org.telegram.telegrambots.longpolling.util.LongPollingSingleThreadUpdateConsumer;
import org.telegram.telegrambots.longpolling.util.TelegramOkHttpClientFactory;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.TelegramClient;
import ru.bgcrm.model.user.User;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SQLUtils;

public class Bot
implements LongPollingSingleThreadUpdateConsumer {
    private static final Log log = Log.getLog();
    private static final Set<String> SPECIAL_CHARACTERS = Set.of("_", "~", "`", ">", "#", "+", "-", "=", "|", "{", "}", ".", "!");
    private static Bot instance;
    private final Map<String, UserData> userMap = new HashMap<String, UserData>();
    private final Map<String, CommandHandler> commands = new HashMap<String, CommandHandler>();
    private static BotSession botSession;
    private static TelegramBotsLongPollingApplication botsApplication;
    private final TelegramClient telegramClient;

    @VisibleForTesting
    Bot(TelegramClient telegramClient) {
        this.telegramClient = telegramClient;
    }

    private void registerCommands() {
        Config config = Setup.getSetup().getConfig(Config.class);
        this.commands.put("/start", chatId -> this.sendMessage(String.valueOf(chatId), config.getMsgDefaultAnswer()));
        this.commands.put("/getid", chatId -> {
            this.userMap.put(String.valueOf(chatId), null);
            this.sendMessage(String.valueOf(chatId), "Your telegramId=" + chatId);
        });
        this.commands.put("/help", chatId -> {
            this.userMap.put(String.valueOf(chatId), null);
            this.sendMessage(String.valueOf(chatId), config.getMsgUrlHelp());
        });
        this.commands.put("/login", chatId -> {
            this.userMap.put(String.valueOf(chatId), new UserData());
            this.sendMessage(String.valueOf(chatId), config.getMsgAskLogin());
        });
    }

    public static Bot getInstance() {
        if (instance == null) {
            Bot.reinit();
        }
        if (instance == null) {
            log.info("In config server not enable bot (telegram:botStart)", new Object[0]);
        }
        return instance;
    }

    private static void reinit() {
        log.info("Re init.... telegramBot", new Object[0]);
        Config config = Setup.getSetup().getConfig(Config.class);
        if (!config.isBotStart()) {
            log.info("Skipping telegramBot start.", new Object[0]);
            return;
        }
        try {
            instance = Bot.init();
        }
        catch (Throwable t) {
            log.error("telegramBot start ERROR", t);
        }
    }

    private static Bot init() throws Exception {
        try {
            if (botSession != null) {
                botSession.stop();
                botSession = null;
            }
            if (botsApplication != null) {
                botsApplication.close();
                botsApplication = null;
            }
        }
        catch (Exception e) {
            log.error("Catch exception", e);
        }
        Config config = Setup.getSetup().getConfig(Config.class);
        String token = config.getToken();
        OkHttpClient okHttpClient = Bot.buildOkHttpClient(config);
        OkHttpTelegramClient telegramClient = okHttpClient != null ? new OkHttpTelegramClient(okHttpClient, token) : new OkHttpTelegramClient(token);
        Bot bot = new Bot((TelegramClient)telegramClient);
        botsApplication = okHttpClient != null ? new TelegramBotsLongPollingApplication(ObjectMapper::new, () -> okHttpClient) : new TelegramBotsLongPollingApplication();
        for (int i = 0; i < 3; ++i) {
            try {
                log.info("try start botSession... on " + config.getProxyType() + ":" + config.getProxyHost() + ":" + config.getProxyPort(), new Object[0]);
                botSession = botsApplication.registerBot(token, (LongPollingUpdateConsumer)bot);
                log.info("botSession=" + String.valueOf(botSession), new Object[0]);
                break;
            }
            catch (TelegramApiException e) {
                log.error("Error start telegram bot", e);
                continue;
            }
        }
        return bot;
    }

    private static OkHttpClient buildOkHttpClient(Config config) {
        String proxyType;
        if (config.getProxyHost() == null) {
            return null;
        }
        final String proxyHost = config.getProxyHost();
        final int proxyPort = Utils.parseInt(config.getProxyPort(), -1);
        String string = proxyType = config.getProxyType() != null ? config.getProxyType().toUpperCase() : "";
        if ("SOCKS5".equals(proxyType)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    if (this.getRequestingHost().equalsIgnoreCase(proxyHost) && proxyPort == this.getRequestingPort()) {
                        return null;
                    }
                    return null;
                }
            });
            return new TelegramOkHttpClientFactory.SocksProxyOkHttpClientCreator(() -> new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyHost, proxyPort))).get();
        }
        if ("HTTP".equals(proxyType)) {
            return new TelegramOkHttpClientFactory.HttpProxyOkHttpClientCreator(() -> new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)), () -> null).get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(Update e) {
        if (e.getMessage().isUserMessage() && e.hasMessage() && e.getMessage().hasText()) {
            Config config = Setup.getSetup().getConfig(Config.class);
            Message msg = e.getMessage();
            String text = msg.getText().toLowerCase();
            String chatId = Long.toString(msg.getChatId());
            log.debug("Message: {}", text);
            CommandHandler handler = this.commands.get(text);
            if (handler != null) {
                handler.handle(Long.parseLong(chatId));
            } else {
                this.sendMessage(chatId, config.getMsgDefaultAnswer());
            }
            UserData userData = this.userMap.get(chatId);
            if (userData != null) {
                if (userData.login == null) {
                    userData.login = text;
                    this.sendMessage(chatId, config.getMsgAskPassword());
                } else {
                    User user = UserCache.getUser(userData.login);
                    if (user == null || !user.getPassword().equals(text)) {
                        this.sendMessage(chatId, config.getMsgWrongPassword());
                        this.userMap.put(chatId, new UserData());
                        this.sendMessage(chatId, config.getMsgAskLogin());
                        return;
                    }
                    Connection con = Setup.getSetup().getDBConnectionFromPool();
                    try {
                        ParamValueDAO paramDAO = new ParamValueDAO(con);
                        paramDAO.updateParamText(user.getId(), config.getUserParamId(), chatId);
                        con.commit();
                        this.userMap.put(chatId, null);
                        this.sendMessage(chatId, config.getMsgLinkChange());
                    }
                    catch (Exception ex) {
                        log.error("Error storing subscription in Telegram ", ex);
                    }
                    finally {
                        SQLUtils.closeConnection(con);
                    }
                }
            }
        }
    }

    void sendMessage(String chatId, String text) {
        SendMessage message = SendMessage.builder().chatId(chatId).text(text).build();
        try {
            this.telegramClient.execute((BotApiMethod)message);
        }
        catch (TelegramApiException e) {
            log.error("Message was not sent ", e);
        }
    }

    void sendMessage(String chatId, String text, String parseMode) {
        SendMessage message = SendMessage.builder().chatId(chatId).text(this.escapeSpecialCharacters(text)).parseMode(parseMode).build();
        try {
            this.telegramClient.execute((BotApiMethod)message);
        }
        catch (TelegramApiException e) {
            log.error("Message was not sent ", e);
        }
    }

    @VisibleForTesting
    String escapeSpecialCharacters(String message) {
        return Arrays.stream(message.split("")).map(c -> {
            if (SPECIAL_CHARACTERS.contains(c)) {
                return "\\" + c;
            }
            return c;
        }).collect(Collectors.joining());
    }

    private static class UserData {
        private String login;

        private UserData() {
        }
    }
}

