/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.svc.dba.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.bgerp.plugin.svc.dba.model.db.Table;
import org.bgerp.plugin.svc.dba.model.db.UnusedColumn;
import ru.bgcrm.dao.CommonDAO;

public class DatabaseDAO
extends CommonDAO {
    public DatabaseDAO(Connection con) {
        super(con);
    }

    public List<Table> tables() throws SQLException {
        ResultSet rs;
        ArrayList<Table> result = new ArrayList<Table>();
        TreeMap<String, Table> tables = new TreeMap<String, Table>();
        String query = "SELECT * FROM information_schema.tables WHERE table_schema=DATABASE() ORDER BY table_name";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            rs = ps.executeQuery();
            while (rs.next()) {
                Table table = this.getFromRs(rs);
                tables.put(table.getName(), table);
                result.add(table);
            }
        }
        query = "SELECT table_name, column_name FROM information_schema.columns WHERE table_schema=DATABASE() ORDER BY table_name, ordinal_position";
        ps = this.con.prepareStatement(query);
        try {
            rs = ps.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString("column_name");
                if (!columnName.startsWith("_")) continue;
                ((Table)tables.get(rs.getString("table_name"))).getUnusedColumns().add(new UnusedColumn(columnName));
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return result;
    }

    private Table getFromRs(ResultSet rs) throws SQLException {
        Table item = new Table();
        item.setName(rs.getString("table_name"));
        item.setRows(rs.getLong("table_rows"));
        item.setDataLength(rs.getLong("data_length"));
        item.setIndexLength(rs.getLong("index_length"));
        item.setCreateTime(rs.getTimestamp("create_time"));
        item.setUpdateTime(rs.getTimestamp("update_time"));
        return item;
    }
}

