/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.report.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.model.base.iface.Titled;
import org.bgerp.util.Log;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public abstract class Column
implements Titled {
    private int index;
    private final String id;
    private final String title;
    private final String ltitle;

    public Column(String id, String title, String ltitle) {
        this.id = id;
        this.title = title;
        this.ltitle = ltitle;
        if (Utils.notBlankString(title) && Utils.notBlankString(ltitle)) {
            throw new IllegalArgumentException("Only one of 'title' and 'ltitle' fields can be defined.");
        }
    }

    public String getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String toString(Object object) {
        return String.valueOf(object);
    }

    public boolean isVisible() {
        return Utils.notBlankString(this.title) || Utils.notBlankString(this.ltitle);
    }

    @Override
    public String getTitle(Localizer l) {
        if (l != null && Utils.notBlankString(this.ltitle)) {
            return l.l(this.ltitle, new Object[0]);
        }
        return this.title;
    }

    public Object accept(Object value) {
        if (value == null) {
            return value;
        }
        throw new IllegalArgumentException(Log.format("Incorrect object class: '{}' for column: '{}'", value.getClass().getName(), this.getId()));
    }

    public static class ColumnDateTime
    extends Column {
        private final String format;

        public ColumnDateTime(String id, String title, String ltitle, String format) {
            super(id, title, ltitle);
            this.format = format;
        }

        @Override
        public Object accept(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Date) {
                return (Date)value;
            }
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
            return super.accept(value);
        }

        @Override
        public String toString(Object object) {
            return TimeUtils.format((Date)object, this.format);
        }
    }

    public static class ColumnDecimal
    extends Column {
        public ColumnDecimal(String id, String title, String ltitle) {
            super(id, title, ltitle);
        }

        @Override
        public Object accept(Object value) {
            if (value instanceof BigDecimal) {
                return value;
            }
            return super.accept(value);
        }
    }

    public static class ColumnInteger
    extends Column {
        public ColumnInteger(String id, String title, String ltitle) {
            super(id, title, ltitle);
        }

        @Override
        public Object accept(Object value) {
            if (value == null) {
                return 0;
            }
            if (value instanceof Integer) {
                return value;
            }
            return super.accept(value);
        }
    }

    public static class ColumnString
    extends Column {
        private boolean commaSeparatedValues;

        public ColumnString(String id, String title, String ltitle) {
            super(id, title, ltitle);
        }

        public ColumnString withCommaSeparatedValues() {
            this.commaSeparatedValues = true;
            return this;
        }

        public boolean isCommaSeparatedValues() {
            return this.commaSeparatedValues;
        }

        @Override
        public String accept(Object value) {
            return String.valueOf(value);
        }
    }
}

