/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.grpl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javassist.NotFoundException;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.plugin.pln.grpl.model.BoardConfig;

public class Config
extends org.bgerp.app.cfg.Config {
    private final Map<Integer, BoardConfig> boards;

    protected Config(ConfigMap config) {
        super(null);
        config = config.sub("grpl:");
        this.boards = this.loadBoards(config);
    }

    private Map<Integer, BoardConfig> loadBoards(ConfigMap config) {
        LinkedHashMap<Integer, BoardConfig> result = new LinkedHashMap<Integer, BoardConfig>();
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("board.").entrySet()) {
            BoardConfig board = new BoardConfig(me.getKey(), me.getValue());
            result.put(board.getId(), board);
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<Integer, BoardConfig> getBoards() {
        return this.boards;
    }

    public Iterable<BoardConfig> getBoards(int paramId) {
        return this.boards.values().stream().filter(board -> board.getParamId() == paramId).toList();
    }

    public BoardConfig getBoardOrThrow(int id) throws NotFoundException {
        BoardConfig result = this.boards.get(id);
        if (result == null) {
            throw new NotFoundException("Not found board with ID: " + id);
        }
        return result;
    }
}

