/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.clb.calendar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.model.base.Id;
import org.bgerp.plugin.clb.calendar.model.Calendar;
import org.bgerp.plugin.clb.calendar.model.event.EventType;

public class Config
extends org.bgerp.app.cfg.Config {
    private final List<EventType> eventTypeList;
    private final Map<Integer, EventType> eventTypeMap;
    private final List<Calendar> calendarList;
    private final Map<Integer, Calendar> calendarMap;

    protected Config(ConfigMap config, boolean validate) {
        super(null);
        config = config.sub("calendar:");
        this.eventTypeList = this.loadEventTypeList(config);
        this.eventTypeMap = this.eventTypeList.stream().collect(Collectors.toMap(Id::getId, t -> t));
        this.calendarList = this.loadCalendarList(config);
        this.calendarMap = this.calendarList.stream().collect(Collectors.toMap(Id::getId, c -> c));
    }

    private List<EventType> loadEventTypeList(ConfigMap config) {
        ArrayList<EventType> result = new ArrayList<EventType>();
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("event.type.").entrySet()) {
            result.add(new EventType((int)me.getKey(), me.getValue()));
        }
        Collections.sort(result, (t1, t2) -> t1.getTitle().compareTo(t2.getTitle()));
        return Collections.unmodifiableList(result);
    }

    private List<Calendar> loadCalendarList(ConfigMap config) {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("calendar.").entrySet()) {
            result.add(new Calendar((int)me.getKey(), me.getValue()));
        }
        Collections.sort(result, (c1, c2) -> c1.getTitle().compareTo(c2.getTitle()));
        return Collections.unmodifiableList(result);
    }

    public List<Calendar> getCalendarList() {
        return this.calendarList;
    }

    public Map<Integer, Calendar> getCalendarMap() {
        return this.calendarMap;
    }

    public List<EventType> getEventTypeList() {
        return this.eventTypeList;
    }

    public Map<Integer, EventType> getEventTypeMap() {
        return this.eventTypeMap;
    }
}

