/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bgb.getolt.model;

import java.util.Collections;
import java.util.List;
import org.bgerp.plugin.bgb.getolt.model.InetService;

public class MacUpdateResult {
    private final Status status;
    private final int serviceId;
    private final String oldMac;
    private final String newMac;
    private final String message;
    private final List<InetService> services;

    private MacUpdateResult(Status status, int serviceId, String oldMac, String newMac, String message, List<InetService> services) {
        this.status = status;
        this.serviceId = serviceId;
        this.oldMac = oldMac;
        this.newMac = newMac;
        this.message = message;
        this.services = services != null ? services : Collections.emptyList();
    }

    public static MacUpdateResult success(int serviceId, String oldMac, String newMac) {
        return new MacUpdateResult(Status.OK, serviceId, oldMac, newMac, "MAC-\u0430\u0434\u0440\u0435\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0451\u043d", null);
    }

    public static MacUpdateResult success(int serviceId, String oldMac, String newMac, String message) {
        return new MacUpdateResult(Status.OK, serviceId, oldMac, newMac, message, null);
    }

    public static MacUpdateResult multipleServices(List<InetService> services) {
        return new MacUpdateResult(Status.MULTIPLE_SERVICES, 0, null, null, "\u041d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0443\u0441\u043b\u0443\u0433, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0443\u0436\u043d\u0443\u044e", services);
    }

    public static MacUpdateResult noServices() {
        return new MacUpdateResult(Status.NO_SERVICES, 0, null, null, "\u0423\u0441\u043b\u0443\u0433\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", null);
    }

    public static MacUpdateResult error(String message) {
        return new MacUpdateResult(Status.ERROR, 0, null, null, message, null);
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isSuccess() {
        return this.status == Status.OK;
    }

    public boolean isMultipleServices() {
        return this.status == Status.MULTIPLE_SERVICES;
    }

    public boolean isError() {
        return this.status == Status.ERROR || this.status == Status.NO_SERVICES;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public String getOldMac() {
        return this.oldMac;
    }

    public String getNewMac() {
        return this.newMac;
    }

    public String getMessage() {
        return this.message;
    }

    public List<InetService> getServices() {
        return this.services;
    }

    public String toString() {
        return "MacUpdateResult{status=" + String.valueOf((Object)this.status) + ", serviceId=" + this.serviceId + ", oldMac='" + this.oldMac + "', newMac='" + this.newMac + "', message='" + this.message + "'}";
    }

    public static enum Status {
        OK,
        MULTIPLE_SERVICES,
        ERROR,
        NO_SERVICES;

    }
}

