/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bgb.getolt.dao;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.bgerp.plugin.bgb.getolt.model.BillingConfig;
import org.bgerp.plugin.bgb.getolt.model.InetService;
import org.bgerp.plugin.bgb.getolt.model.MacUpdateResult;
import org.bgerp.plugin.bgb.getolt.model.SessionDropResult;
import org.bgerp.util.Log;

public class InetMacApiClient {
    private static final Log log = Log.getLog();
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final CloseableHttpClient HTTP_CLIENT;
    private final BillingConfig config;
    private final RequestConfig requestConfig;

    public InetMacApiClient(BillingConfig config) {
        this.config = config;
        this.requestConfig = RequestConfig.custom().setConnectTimeout(config.getTimeout()).setSocketTimeout(config.getTimeout()).setConnectionRequestTimeout(config.getTimeout()).build();
    }

    public List<InetService> getServicesByContractId(int contractId) {
        if (!this.config.isConfigured()) {
            log.warn("InetMac API is not configured", new Object[0]);
            return new ArrayList<InetService>();
        }
        try {
            ObjectNode request = MAPPER.createObjectNode();
            request.put("method", "getServicesByContractId");
            ObjectNode params = request.putObject("params");
            params.put("contractId", contractId);
            String responseBody = this.executeRequest(request);
            if (responseBody == null) {
                return new ArrayList<InetService>();
            }
            log.debug("InetMac getServices response: {}", responseBody);
            JsonNode root = MAPPER.readTree(responseBody);
            String status = root.path("status").asText("");
            if ("error".equals(status)) {
                String errorMsg = root.path("message").asText("Unknown error");
                log.error("InetMac API error: {}", errorMsg);
                return new ArrayList<InetService>();
            }
            JsonNode dataNode = root.path("data").path("return");
            ArrayList<InetService> services = new ArrayList();
            if (dataNode.isArray()) {
                services = (List)MAPPER.readValue(dataNode.traverse(), (TypeReference)new TypeReference<List<InetService>>(this){});
            }
            log.debug("InetMac: Found {} services for contractId={}", services.size(), contractId);
            return services;
        }
        catch (Exception e) {
            log.error("InetMac getServicesByContractId error", e);
            return new ArrayList<InetService>();
        }
    }

    public MacUpdateResult updateMacByContractId(int contractId, String newMac) {
        if (!this.config.isConfigured()) {
            return MacUpdateResult.error("InetMac API \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            List<InetService> services = this.getServicesByContractId(contractId);
            if (services.isEmpty()) {
                return MacUpdateResult.noServices();
            }
            if (services.size() > 1) {
                return MacUpdateResult.multipleServices(services);
            }
            InetService service = services.get(0);
            return this.updateMacAddress(service.getServiceId(), newMac, service.getMac());
        }
        catch (Exception e) {
            log.error("InetMac updateMacByContractId error", e);
            return MacUpdateResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f MAC: " + e.getMessage());
        }
    }

    public MacUpdateResult updateMacAddress(int serviceId, String newMac) {
        return this.updateMacAddress(serviceId, newMac, null);
    }

    public MacUpdateResult updateMacAddress(int serviceId, String newMac, String oldMac) {
        if (!this.config.isConfigured()) {
            return MacUpdateResult.error("InetMac API \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            ObjectNode request = MAPPER.createObjectNode();
            request.put("method", "updateMacAddress");
            ObjectNode params = request.putObject("params");
            params.put("serviceId", serviceId);
            params.put("newMac", newMac);
            String responseBody = this.executeRequest(request);
            if (responseBody == null) {
                return MacUpdateResult.error("\u041d\u0435\u0442 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            }
            log.info("InetMac updateMacAddress response: {}", responseBody);
            JsonNode root = MAPPER.readTree(responseBody);
            String status = root.path("status").asText("");
            if ("error".equals(status)) {
                String errorMsg = root.path("message").asText("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
                log.error("InetMac updateMacAddress error: {}", errorMsg);
                return MacUpdateResult.error(errorMsg);
            }
            JsonNode returnNode = root.path("data").path("return");
            String innerStatus = returnNode.path("status").asText("");
            if ("error".equals(innerStatus)) {
                String errorMsg = returnNode.path("message").asText("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c MAC");
                log.error("InetMac updateMacAddress operation error: {}", errorMsg);
                return MacUpdateResult.error(errorMsg);
            }
            if ("ok".equals(status)) {
                log.info("InetMac: MAC updated for serviceId={}, old={}, new={}", serviceId, oldMac, newMac);
                return MacUpdateResult.success(serviceId, oldMac, newMac);
            }
            String message = root.path("message").asText("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c MAC");
            return MacUpdateResult.error(message);
        }
        catch (Exception e) {
            log.error("InetMac updateMacAddress error", e);
            return MacUpdateResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f MAC: " + e.getMessage());
        }
    }

    public SessionDropResult dropSession(int serviceId) {
        if (!this.config.isConfigured()) {
            return SessionDropResult.error("InetMac API \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            ObjectNode request = MAPPER.createObjectNode();
            request.put("method", "dropSession");
            ObjectNode params = request.putObject("params");
            params.put("serviceId", serviceId);
            String responseBody = this.executeRequest(request);
            if (responseBody == null) {
                return SessionDropResult.error("\u041d\u0435\u0442 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            }
            log.info("InetMac dropSession response: {}", responseBody);
            JsonNode root = MAPPER.readTree(responseBody);
            String status = root.path("status").asText("");
            if ("error".equals(status)) {
                String errorMsg = root.path("message").asText("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
                log.error("InetMac dropSession error: {}", errorMsg);
                return SessionDropResult.error(errorMsg);
            }
            JsonNode dataNode = root.path("data");
            int dropped = dataNode.path("droppedSessions").asInt(dataNode.path("return").asInt(0));
            log.info("InetMac: Session dropped for serviceId={}, count={}", serviceId, dropped);
            return SessionDropResult.success(dropped);
        }
        catch (Exception e) {
            log.error("InetMac dropSession error", e);
            return SessionDropResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0431\u0440\u043e\u0441\u0430 \u0441\u0435\u0441\u0441\u0438\u0438: " + e.getMessage());
        }
    }

    private String executeRequest(ObjectNode requestBody) {
        try {
            String url = this.config.getUrl();
            ObjectNode userNode = requestBody.putObject("user");
            userNode.put("user", this.config.getUser());
            userNode.put("pswd", this.config.getPassword());
            log.debug("InetMac API request: POST {} method={}", url, requestBody.get("method"));
            HttpPost request = new HttpPost(url);
            request.setConfig(this.requestConfig);
            request.setHeader("Content-Type", "application/json");
            request.setHeader("Accept", "application/json");
            request.setEntity((HttpEntity)new StringEntity(requestBody.toString(), StandardCharsets.UTF_8));
            CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            log.debug("InetMac API response: status={}, bodyLen={}", statusCode, responseBody.length());
            if (statusCode >= 400) {
                log.error("InetMac API error: status={}, body={}", statusCode, responseBody);
                return null;
            }
            return responseBody;
        }
        catch (SocketTimeoutException e) {
            log.error("InetMac API timeout: {}", e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.error("InetMac API error", e);
            return null;
        }
    }

    static {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(20);
        connManager.setDefaultMaxPerRoute(10);
        HTTP_CLIENT = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }
}

