/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.event.listener;

import java.sql.SQLException;
import java.util.Map;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.dao.expression.Expression;
import org.bgerp.model.process.config.ProcessDescriptionConfig;
import org.bgerp.model.process.config.ProcessTitleConfig;
import org.bgerp.util.Log;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.event.ParamChangedEvent;
import ru.bgcrm.event.client.ProcessOpenEvent;
import ru.bgcrm.event.process.ProcessChangedEvent;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class ProcessTextListener {
    private static final Log log = Log.getLog();

    public ProcessTextListener() {
        EventProcessor.subscribe((e, conSet) -> this.processChanged((ProcessChangedEvent)e, conSet), ProcessChangedEvent.class);
        EventProcessor.subscribe((e, conSet) -> this.paramChanged((ParamChangedEvent)e, conSet), ParamChangedEvent.class);
    }

    private void processChanged(ProcessChangedEvent e, ConnectionSet conSet) throws SQLException {
        ProcessDescriptionConfig descriptionConfig;
        Process process = e.getProcess();
        ConfigMap configMap = process.getType().getProperties().getConfigMap();
        ProcessTitleConfig titleConfig = configMap.getConfig(ProcessTitleConfig.class);
        if (titleConfig != null && titleConfig.isProcessUsed()) {
            this.updateProcessTitle(e.getForm(), conSet, process, titleConfig.getExpression());
        }
        if ((descriptionConfig = configMap.getConfig(ProcessDescriptionConfig.class)) != null && descriptionConfig.isProcessUsed()) {
            this.updateProcessDescription(e.getForm(), conSet, process, descriptionConfig.getExpression());
        }
    }

    private void paramChanged(ParamChangedEvent e, ConnectionSet conSet) throws Exception {
        ProcessDescriptionConfig descriptionConfig;
        if (!"process".equals(e.getParameter().getObjectType())) {
            return;
        }
        Process process = new ProcessDAO(conSet.getSlaveConnection()).getProcessOrThrow(e.getObjectId());
        ConfigMap configMap = process.getType().getProperties().getConfigMap();
        Integer paramId = e.getParameter().getId();
        ProcessTitleConfig titleConfig = configMap.getConfig(ProcessTitleConfig.class);
        if (titleConfig != null && titleConfig.isParamUsed(paramId)) {
            this.updateProcessTitle(e.getForm(), conSet, process, titleConfig.getExpression());
        }
        if ((descriptionConfig = configMap.getConfig(ProcessDescriptionConfig.class)) != null && descriptionConfig.isParamUsed(paramId)) {
            this.updateProcessDescription(e.getForm(), conSet, process, descriptionConfig.getExpression());
        }
    }

    private void updateProcessTitle(DynActionForm form, ConnectionSet conSet, Process process, String expression) throws SQLException {
        Map<String, Object> context = Expression.context(conSet, form, null, process);
        String title = Utils.maskNull(new Expression(context).executeGetString(expression));
        if (!title.equals(process.getTitle())) {
            new ProcessDAO(conSet.getConnection()).updateProcessTitle(process.getId(), title);
            form.getResponse().addEvent(new ProcessOpenEvent(process.getId()));
            log.info("Update title '{}' for process {}", title, process.getId());
        }
    }

    private void updateProcessDescription(DynActionForm form, ConnectionSet conSet, Process process, String expression) throws SQLException {
        Map<String, Object> context = Expression.context(conSet, form, null, process);
        String description = Utils.maskNull(new Expression(context).executeGetString(expression));
        if (!description.equals(process.getDescription())) {
            process.setDescription(description);
            new ProcessDAO(conSet.getConnection()).updateProcess(process);
            form.getResponse().addEvent(new ProcessOpenEvent(process.getId()));
            log.info("Update description '{}' for process {}", description, process.getId());
        }
    }
}

