/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.model.Pageable;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.EntityLogDAO;
import ru.bgcrm.model.EntityLogItem;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.Status;
import ru.bgcrm.util.Utils;

public class ProcessLogDAO
extends EntityLogDAO {
    public ProcessLogDAO(Connection con) {
        super(con, " process_log ");
    }

    public void searchProcessLog(Localizer l, ProcessType processType, int processId, Pageable<EntityLogItem> result) throws SQLException {
        Page page = result.getPage();
        PreparedQuery pq = new PreparedQuery(this.con);
        pq.addQuery("SELECT SQL_CALC_FOUND_ROWS  dt, user_id, 0, data, 0 FROM  process_log ");
        pq.addQuery(" WHERE id=?");
        pq.addInt(processId);
        pq.addQuery(" UNION SELECT dt, user_id, -1, status_id, comment FROM  process_status ");
        pq.addQuery(" WHERE process_id=?");
        pq.addInt(processId);
        pq.addQuery(" UNION SELECT dt, user_id, param_id, text, 0 FROM  param_log ");
        pq.addQuery(" WHERE object_id=? AND param_id IN ( " + Utils.toString(processType.getProperties().getParameterIds(), " 0 ", " , ") + " )");
        pq.addInt(processId);
        pq.addQuery(" ORDER BY dt DESC ");
        pq.addQuery(page.getLimitSql());
        List<EntityLogItem> list = result.getList();
        try (PreparedQuery preparedQuery = pq;){
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                Object text = " ??? ";
                int paramId = rs.getInt(3);
                if (paramId > 0) {
                    Parameter param = ParameterCache.getParameter(paramId);
                    if (param != null) {
                        text = l.l("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", new Object[0]) + " '" + param.getTitle() + "': " + rs.getString(4);
                    }
                } else if (paramId == -1) {
                    Status status = ProcessTypeCache.getStatusMap().get(Utils.parseInt(rs.getString(4)));
                    text = l.l("Status", new Object[0]) + ": " + (String)(status != null ? status.getTitle() : " ??? " + rs.getString(4) + " ") + " [" + Utils.maskNull(rs.getString(5)) + "]";
                } else {
                    text = rs.getString(4);
                }
                list.add(new EntityLogItem(rs.getTimestamp(1), processId, rs.getInt(2), (String)text));
            }
            page.setRecordCount(pq.getPrepared());
        }
    }
}

