/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.custom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.catalina.Context;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.custom.java.CompilationResult;
import org.bgerp.custom.java.CompilerWrapper;
import org.bgerp.util.Log;

public class Custom {
    private static final Log log = Log.getLog();
    public static final Custom INSTANCE = new Custom();
    public static final File JAR = new File("lib/app/custom.jar");
    public static final String PACKAGE = "org.bgerp.plugin.custom";
    private static final String DIR_NAME = "custom";
    public static final File DIR = new File("custom");
    private static final File DIR_SRC = new File(DIR, "src");
    private static final File DIR_WEBAPPS = new File(DIR, "webapps");
    private volatile URLClassLoader classLoader;

    public void webapps(String catalinaHome, StandardContext context) {
        if (!DIR_WEBAPPS.isDirectory()) {
            return;
        }
        log.info("Connecting custom webapps: {}", DIR_WEBAPPS);
        StandardRoot webResourceRoot = new StandardRoot((Context)context);
        webResourceRoot.addPreResources((WebResourceSet)new DirResourceSet((WebResourceRoot)webResourceRoot, "/", catalinaHome + "/custom/webapps", "/"));
        context.setResources((WebResourceRoot)webResourceRoot);
    }

    public CompilationResult compileJava() throws IOException, BGMessageException {
        if (!DIR_SRC.isDirectory()) {
            throw new BGMessageException("src directory is missing", new Object[0]);
        }
        ArrayList<String> srcFiles = new ArrayList<String>(100);
        this.traverse(srcFiles, DIR_SRC);
        CompilerWrapper compiler = new CompilerWrapper(DIR_SRC);
        log.info("Compiling {} java files to {}", srcFiles.size(), compiler.getOutputDir());
        CompilationResult result = compiler.compile(srcFiles).getFirst();
        result.addLog(Log.format("Compiling {} java files to {}", srcFiles.size(), compiler.getOutputDir()));
        if (result.isResult()) {
            this.copyResources(DIR_SRC.toPath(), compiler.getOutputDir().toPath());
            this.buildCustomJar(compiler, result);
        }
        return result;
    }

    public URLClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void copyResources(Path srcDir, Path outputDir) throws IOException {
        Files.walk(srcDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> !path.toString().endsWith(".java")).forEach(path -> {
            try {
                log.debug("Copying resource {}", path);
                FileUtils.copyFile((File)path.toFile(), (File)outputDir.resolve(srcDir.relativize((Path)path)).toFile());
            }
            catch (IOException e) {
                log.error(e);
            }
        });
    }

    private void buildCustomJar(CompilerWrapper compiler, CompilationResult result) throws IOException {
        JAR.getParentFile().mkdirs();
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(JAR));){
            for (File file : compiler.getOutputDir().listFiles()) {
                this.zipFile(file, file.getName(), zipOut);
            }
        }
        this.classLoader = new URLClassLoader(new URL[]{JAR.toURI().toURL()}, ClassLoader.getSystemClassLoader());
        Bean.loadBeanClasses();
        result.addLog(Log.format("Built: {} {} bytes", JAR, JAR.length()));
    }

    private void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            for (File childFile : children = fileToZip.listFiles()) {
                this.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
            }
            return;
        }
        zipOut.putNextEntry(new ZipEntry(fileName));
        IOUtils.copy((InputStream)new FileInputStream(fileToZip), (OutputStream)zipOut);
    }

    private void traverse(List<String> files, File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory() && !file.getName().startsWith(".")) {
                this.traverse(files, file);
                continue;
            }
            if (!file.getName().endsWith(".java")) continue;
            files.add(file.getAbsolutePath());
        }
    }
}

