/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action;

import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javassist.NotFoundException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.ProcessAction;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.dao.message.MessageSearchDAO;
import org.bgerp.event.ProcessFilesEvent;
import org.bgerp.model.Pageable;
import org.bgerp.model.msg.Message;
import org.bgerp.model.msg.config.MessageTypeConfig;
import org.bgerp.model.msg.config.TagConfig;
import org.bgerp.model.msg.config.TemplateConfig;
import org.bgerp.model.process.ProcessCreateType;
import org.bgerp.model.process.link.ProcessLinkProcess;
import org.bgerp.util.Dynamic;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.message.MessageTypeSearch;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.dao.user.UserDAO;
import ru.bgcrm.event.MessageRemovedEvent;
import ru.bgcrm.event.link.LinkAddedEvent;
import ru.bgcrm.event.process.ProcessMessageAddedEvent;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.user.PermissionActionMethodException;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

@ActionServlet.Action(path="/user/message", pathId=true)
public class MessageAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/message";
    private static final int MAX_MESSAGE_DELETE_QNT = 1000;
    public static final String UNPROCESSED_MESSAGES_PERSONAL_KEY = "unprocessedMessages";
    @Dynamic
    public static final String ACTION_MODIFY_NOT_OWNED = ActionServlet.pathId(MessageAction.class, "modifyNotOwned");

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        return this.message(form, conSet);
    }

    public ActionForward message(DynActionForm form, ConnectionSet conSet) throws Exception {
        int typeId = form.getParamInt("typeId");
        String messageId = form.getParam("messageId");
        Message message = null;
        if (form.getId() > 0) {
            MessageDAO messageDao = new MessageDAO(conSet.getConnection());
            message = messageDao.getMessageById(form.getId());
            if (message == null) {
                throw new NotFoundException("Not found message with ID: " + form.getId());
            }
        } else if (typeId > 0 && Utils.notBlankString(messageId)) {
            MessageType type = this.getType(typeId);
            message = type.newMessageGet(conSet, messageId);
            if (message == null) {
                throw new NotFoundException("Not found message with System ID: " + messageId);
            }
            this.linksSearch(form, conSet);
            form.setRequestAttribute("typeTreeRoot", ProcessCreateType.treeRoot(form, "message", null));
        }
        form.setResponseData("message", message);
        return this.html(conSet, form, "/WEB-INF/jspf/user/message/message.jsp");
    }

    public ActionForward messageUpdateProcess(DynActionForm form, Connection con) throws Exception {
        MessageType type;
        MessageTypeConfig config = this.setup.getConfig(MessageTypeConfig.class);
        MessageDAO messageDao = new MessageDAO(con);
        Message message = null;
        if (form.getId() > 0) {
            message = new MessageDAO(con).getMessageById(form.getId());
        } else {
            int typeId = form.getParamInt("messageTypeId");
            String messageId = form.getParam("messageId");
            type = (MessageType)config.getTypeMap().get(typeId);
            message = type.newMessageLoad(con, messageId);
        }
        if (message == null) {
            throw new BGMessageException("Message not found", new Object[0]);
        }
        form.setResponseData("id", message.getId());
        int processId = form.getParamInt("processId", -1);
        if (processId >= 0) {
            message.setProcessId(processId);
            if (processId > 0) {
                int contactSaveMode = form.getParamInt("contactSaveMode");
                type = (MessageType)config.getTypeMap().get(message.getTypeId());
                Process process = new ProcessDAO(con).getProcess(processId);
                if (process == null) {
                    throw new BGException("Process not found.", new Object[0]);
                }
                if (form.getParamBoolean("notification", false).booleanValue()) {
                    messageDao.updateMessage(type.messageLinkedToProcess(message));
                } else if (contactSaveMode > 0) {
                    type.getContactSaver().saveContact(form, con, message, process, contactSaveMode);
                }
                EventProcessor.processEvent(new ProcessMessageAddedEvent(form, message, process), new SingleConnectionSet(con));
            }
        }
        messageDao.updateMessageProcess(message);
        if (message.getId() > 0) {
            form.setResponseData("messageId", message.getId());
        }
        return this.json(con, form);
    }

    public ActionForward messageUpdateTags(DynActionForm form, Connection con) throws Exception {
        new MessageDAO(con).updateMessageTags(form.getId(), form.getParamValues("tagId"), true);
        return this.json(con, form);
    }

    public ActionForward messageToggleTags(DynActionForm form, Connection con) throws SQLException {
        new MessageDAO(con).toggleMessageTags(form.getId(), form.getParamValues("tagId"), form.getParamBoolean("add"));
        return this.json(con, form);
    }

    public ActionForward messageUpdateRead(DynActionForm form, Connection con) throws Exception {
        MessageDAO dao = new MessageDAO(con);
        Message m = dao.getMessageById(form.getId());
        if (m == null) {
            throw new NotFoundException("Not found message with ID: " + form.getId());
        }
        if (form.getParamBoolean("value")) {
            m.setToTime(new Date());
            if (m.getUserId() <= 0) {
                m.setUserId(form.getUserId());
            }
        } else {
            m.setToTime(null);
        }
        dao.updateMessage(m);
        return this.json(con, form);
    }

    public ActionForward messageUpdateProcessToCopy(DynActionForm form, Connection con) throws Exception {
        MessageDAO messageDao = new MessageDAO(con);
        ProcessDAO processDao = new ProcessDAO(con);
        ProcessLinkDAO linkDao = new ProcessLinkDAO(con);
        Message message = messageDao.getMessageById(form.getId());
        if (message == null) {
            throw new BGMessageException("Message not found", new Object[0]);
        }
        Process process = processDao.getProcessOrThrow(message.getProcessId());
        String linkType = form.getParam("linkType");
        Process newProcess = new Process();
        newProcess.setTypeId(process.getTypeId());
        newProcess.setStatusId(process.getStatusId());
        newProcess.setStatusUserId(form.getUserId());
        newProcess.setDescription(message.getSubject());
        newProcess.setCreateUserId(form.getUserId());
        newProcess.setCreateUserId(form.getUserId());
        processDao.updateProcess(newProcess);
        processDao.updateProcessGroups(process.getGroups(), newProcess.getId());
        processDao.updateProcessExecutors(process.getExecutors(), newProcess.getId());
        if (StringUtils.isBlank((CharSequence)linkType)) {
            linkDao.copyLinks(process.getId(), newProcess.getId(), null);
        } else {
            linkDao.addLink(new ProcessLinkProcess(process.getId(), linkType, newProcess.getId()));
            if ("processDepend".equals(linkType)) {
                for (Process linkedProcess : linkDao.getLinkedProcessList(process.getId(), "processMade", false, null)) {
                    linkDao.addLink(new ProcessLinkProcess.Made(linkedProcess.getId(), newProcess.getId()));
                }
            }
        }
        message.setProcessId(newProcess.getId());
        message.setText(this.l.l("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d\u043e \u0438\u0437 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430 #{}", process.getId()) + "\n\n" + message.getText());
        messageDao.updateMessage(message);
        form.setResponseData("process", newProcess);
        return this.json(con, form);
    }

    public ActionForward messageDelete(DynActionForm form, ConnectionSet conSet) throws Exception {
        int cnt = 0;
        MessageTypeConfig config = this.setup.getConfig(MessageTypeConfig.class);
        HashMap<MessageType, List> typeSystemIds = new HashMap<MessageType, List>(10);
        for (String string : form.getParamValuesListStr("typeId-systemId")) {
            if (++cnt > 1000) break;
            int typeId = Utils.parseInt(StringUtils.substringBefore((String)string, (String)"-"));
            MessageType type = (MessageType)config.getTypeMap().get(typeId);
            if (type == null) {
                throw new BGException("Not found message type with ID: {}", typeId);
            }
            typeSystemIds.computeIfAbsent(type, unused -> new ArrayList(10)).add(StringUtils.substringAfter((String)string, (String)"-"));
        }
        for (Map.Entry entry : typeSystemIds.entrySet()) {
            ((MessageType)entry.getKey()).messageDelete(conSet, ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
        }
        return this.json(conSet, form);
    }

    public ActionForward messageList(DynActionForm form, ConnectionSet conSet) throws Exception {
        this.restoreRequestParams(conSet.getConnection(), form, true, true, "order", "typeId");
        boolean processed = form.getParamBoolean("processed", false);
        boolean reverseOrder = form.getParamBoolean("order", true);
        Set<Integer> allowedTypeIds = Utils.toIntegerSet(form.getPermission().get("allowedTypeIds", ""));
        MessageTypeConfig config = this.setup.getConfig(MessageTypeConfig.class);
        form.setRequestAttribute("config", config);
        SortedMap typeMap = Maps.filterKeys(config.getTypeMap(), k -> allowedTypeIds.isEmpty() || allowedTypeIds.contains(k));
        int typeId = form.getParamInt("typeId", -1);
        if (processed) {
            new MessageSearchDAO(conSet.getConnection()).withTypeId(typeId).withDirection(1).withProcessed(true).withRead(form.getParamBoolean("read", null)).withAttach(form.getParamBoolean("attach", null)).withDateFrom(form.getParamDate("dateFrom", null), form.getParamDate("dateTo", null)).withFrom(LikePattern.SUB.get(form.getParam("from"))).order(reverseOrder ? MessageSearchDAO.Order.FROM_TIME_DESC : MessageSearchDAO.Order.FROM_TIME).search(new Pageable<Message>(form));
        } else {
            ExecutorService executors = Executors.newFixedThreadPool(typeId <= 0 ? typeMap.size() : 1);
            List result = Collections.synchronizedList(new ArrayList(1000));
            for (MessageType type : typeMap.values()) {
                if (typeId > 0 && typeId != type.getId()) continue;
                executors.execute(() -> {
                    try {
                        result.addAll(type.newMessageList(conSet));
                    }
                    catch (Exception e) {
                        this.log.error(e);
                    }
                });
            }
            executors.shutdown();
            if (!executors.awaitTermination(2L, TimeUnit.MINUTES)) {
                this.log.error("Timeout waiting threads", new Object[0]);
            }
            Collections.sort(result, (o1, o2) -> {
                Date time1 = o1.getFromTime();
                Date time2 = o2.getFromTime();
                return reverseOrder ? time2.compareTo(time1) : time1.compareTo(time2);
            });
            form.setResponseData("list", result);
            Preferences prefs = new Preferences();
            prefs.put(UNPROCESSED_MESSAGES_PERSONAL_KEY, String.valueOf(config.getUnprocessedMessagesCount()));
            new UserDAO(conSet.getConnection()).updatePersonalization(form.getUser(), prefs);
        }
        form.setRequestAttribute("typeMap", typeMap);
        return this.html(conSet, form, "/WEB-INF/jspf/user/message/list.jsp");
    }

    public ActionForward newMessageLoad(DynActionForm form, ConnectionSet conSet) throws Exception {
        MessageTypeConfig config = this.setup.getConfig(MessageTypeConfig.class);
        int typeId = form.getParamInt("typeId");
        String messageId = form.getParam("messageId");
        MessageType type = (MessageType)config.getTypeMap().get(typeId);
        if (type == null) {
            throw new BGException("Message type not found:" + typeId, new Object[0]);
        }
        type.newMessageLoad(conSet.getConnection(), messageId);
        return this.json(conSet, form);
    }

    private void linksSearch(DynActionForm form, ConnectionSet conSet) throws Exception {
        MessageType type = this.getType(form.getParamInt("typeId"));
        Message message = type.newMessageGet(conSet, form.getParam("messageId"));
        Map<Integer, MessageTypeSearch> searchMap = type.getSearchMap();
        int searchId = form.getParamInt("searchId");
        if (searchId > 0) {
            if (CollectionUtils.isNotEmpty(searchMap.values())) {
                MessageTypeSearch search = type.getSearchMap().get(searchId);
                LinkedHashSet<CommonObjectLink> searchedList = new LinkedHashSet<CommonObjectLink>();
                search.search(form, conSet, message, searchedList);
                form.setResponseData("searchedList", searchedList);
            }
        } else {
            List searches = searchMap.values().stream().filter(s -> Utils.isBlankString(s.getJsp())).collect(Collectors.toList());
            if (!searches.isEmpty()) {
                Set searchedList = Collections.synchronizedSet(new LinkedHashSet());
                ExecutorService executors = Executors.newFixedThreadPool(searches.size());
                for (MessageTypeSearch search : searches) {
                    executors.execute(() -> {
                        try {
                            search.search(form, conSet, message, searchedList);
                        }
                        catch (Exception e) {
                            this.log.error(e);
                        }
                    });
                }
                executors.shutdown();
                if (!executors.awaitTermination(2L, TimeUnit.MINUTES)) {
                    this.log.error("Timeout waiting threads", new Object[0]);
                }
                form.setResponseData("searchedList", searchedList);
            }
        }
    }

    public ActionForward processCreate(DynActionForm form, ConnectionSet conSet) throws Exception {
        Connection con = conSet.getConnection();
        Process process = ProcessAction.processCreateAndGet(form, con);
        ProcessLinkDAO linkDao = new ProcessLinkDAO(con, form);
        for (String link : form.getParamValuesListStr("link")) {
            String[] tokens = link.split("\\*");
            if (tokens.length != 3) {
                this.log.warn("Incorrect link: '{}'", link);
                continue;
            }
            CommonObjectLink olink = new CommonObjectLink("process", process.getId(), tokens[0], Utils.parseInt(tokens[1]), tokens[2]);
            linkDao.addLink(olink);
            EventProcessor.processEvent(new LinkAddedEvent(form, olink), conSet);
        }
        form.setParam("processId", String.valueOf(process.getId()));
        this.messageUpdateProcess(form, con);
        return this.json(con, form);
    }

    private MessageType getType(int typeId) {
        MessageTypeConfig config = this.setup.getConfig(MessageTypeConfig.class);
        MessageType type = (MessageType)config.getTypeMap().get(typeId);
        if (type == null) {
            throw new BGException("Message type not found: " + typeId, new Object[0]);
        }
        return type;
    }

    public ActionForward processMessageList(DynActionForm form, ConnectionSet conSet) throws Exception {
        int tagId = form.getParamInt("tagId");
        int processId = form.getParamInt("processId");
        TreeSet<Integer> processIds = new TreeSet<Integer>(Collections.singleton(processId));
        Set<String> linkProcess = Utils.toSet(form.getParam("linkProcess"));
        if (!linkProcess.isEmpty()) {
            List linkProcessIds = new ProcessLinkDAO(conSet.getSlaveConnection()).getObjectLinksWithType(processId, "process%").stream().filter(l -> linkProcess.contains(l.getLinkObjectType())).map(CommonObjectLink::getLinkObjectId).collect(Collectors.toList());
            processIds.addAll(linkProcessIds);
        }
        this.log.debug("processIds: {}", processIds);
        Set<Integer> allowedTypeIds = Utils.toIntegerSet(form.getPermission().get("allowedTypeIds", ""));
        new MessageSearchDAO(conSet.getConnection()).withProcessIds(processIds).withTypeIds(allowedTypeIds).withAttach(tagId == -1 ? Boolean.valueOf(true) : null).withRead(tagId == -5 ? Boolean.valueOf(false) : null).withDateFrom(form.getParamDate("dateFrom"), form.getParamDate("dateTo")).order(MessageSearchDAO.Order.PINNED_FIRST).order(MessageSearchDAO.Order.FROM_TIME_DESC).withTagId(tagId).search(new Pageable<Message>(form));
        Map<Integer, Set<Integer>> messageTagMap = new MessageDAO(conSet.getConnection()).getProcessMessageTagMap(processIds);
        form.setResponseData("messageTagMap", messageTagMap);
        Set tagIds = messageTagMap.values().stream().flatMap(mt -> mt.stream()).collect(Collectors.toSet());
        form.setResponseData("tagIds", tagIds);
        return this.html(conSet, form, "/WEB-INF/jspf/user/message/process/list/list.jsp");
    }

    public ActionForward processMessageCreateEdit(DynActionForm form, ConnectionSet conSet) throws Exception {
        return this.processMessageEdit(form, conSet);
    }

    public ActionForward processMessageCreateUpdate(DynActionForm form, Connection con) throws Exception {
        return this.processMessageUpdate(form, con);
    }

    public ActionForward processMessageEdit(DynActionForm form, ConnectionSet conSet) throws Exception {
        MessageDAO dao = new MessageDAO(conSet.getSlaveConnection());
        Message message = null;
        int replyToId = form.getParamInt("replyToId");
        if (replyToId > 0) {
            message = dao.getMessageById(replyToId);
            if (message == null) {
                throw new BGException("Message not found: " + replyToId, new Object[0]);
            }
            message = this.getType(message.getTypeId()).getAnswerMessage(message);
        } else if (form.getId() > 0) {
            message = dao.getMessageById(form.getId());
        }
        TagConfig tagConfig = this.setup.getConfig(TagConfig.class);
        if (tagConfig != null) {
            form.setResponseData("messageTagIds", dao.getMessageTags(form.getId()));
        }
        form.setRequestAttribute("templateConfig", this.setup.getConfig(TemplateConfig.class));
        if (message != null) {
            form.setResponseData("message", message);
        }
        ProcessFilesEvent event = new ProcessFilesEvent(form, form.getParamInt("processId"));
        EventProcessor.processEvent(event, conSet);
        form.setRequestAttribute("files", event.getFiles());
        form.setRequestAttribute("announcedFiles", event.getAnnouncedFiles());
        return this.html(conSet, form, "/WEB-INF/jspf/user/message/process/edit/editor.jsp");
    }

    public ActionForward processMessageUpdate(DynActionForm form, Connection con) throws Exception {
        MessageType type = this.getType(form.getParamInt("typeId"));
        Message message = new Message();
        if (form.getId() > 0) {
            message = new MessageDAO(con).getMessageById(form.getId());
        }
        this.modifyNotOwnedCheck(form, message);
        Set<Integer> allowedTypeIds = Utils.toIntegerSet(form.getPermission().get("allowedTypeIds", ""));
        if (message.getId() <= 0 && !allowedTypeIds.isEmpty() && !allowedTypeIds.contains(type.getId())) {
            throw new BGException("Message with the given type is not allowed to be created", new Object[0]);
        }
        message.setId(form.getId());
        message.setUserId(form.getUserId());
        message.setTypeId(type.getId());
        message.setDirection(2);
        message.setFromTime(new Date());
        message.setProcessId(form.getParamInt("processId"));
        message.setSubject(form.getParam("subject"));
        message.setText(form.getParam("text"));
        String systemId = form.getParam("systemId");
        if (Utils.notBlankString(systemId)) {
            message.setSystemId(systemId);
        }
        type.updateMessage(con, form, message);
        if (form.getParamBoolean("updateTags")) {
            new MessageDAO(con).updateMessageTags(message.getId(), form.getParamValues("tagId"), false);
        }
        form.setResponseData("message", message);
        return this.json(con, form);
    }

    public ActionForward processMessageDelete(DynActionForm form, ConnectionSet conSet) throws Exception {
        MessageDAO dao = new MessageDAO(conSet.getConnection());
        Message message = dao.getMessageById(form.getId());
        this.modifyNotOwnedCheck(form, message);
        dao.deleteMessage(form.getId());
        EventProcessor.processEvent(new MessageRemovedEvent(form, form.getId()), conSet);
        return this.json(conSet, form);
    }

    private void modifyNotOwnedCheck(DynActionForm form, Message message) throws BGMessageException {
        if (message.getId() > 0 && message.getUserId() != form.getUserId() && !form.getUser().checkPerm(ACTION_MODIFY_NOT_OWNED)) {
            throw new BGMessageException("Editing of not own messages is not allowed", new Object[0]);
        }
    }

    public ActionForward modifyNotOwned(DynActionForm form, ConnectionSet conSet) {
        throw new PermissionActionMethodException();
    }

    public ActionForward template(DynActionForm form, ConnectionSet conSet) {
        form.setResponseData("template", this.setup.getConfig(TemplateConfig.class).getTemplates().get(form.getId()));
        return this.json(conSet, form);
    }
}

