/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.asterisk.ami;

import java.io.IOException;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.internal.ManagerConnectionImpl;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.util.Log;

public class ManagerConnection
extends ManagerConnectionImpl {
    private static final Log log = Log.getLog();
    private final AsteriskVersion version;

    public ManagerConnection(ConfigMap config) {
        String host = config.get("host");
        int port = config.getInt("port", 5038);
        String login = config.get("login");
        String pswd = config.get("pswd");
        String version = config.get("version");
        this.version = version == null ? null : AsteriskVersion.getDetermineVersionFromString((String)version);
        log.info("Connecting AMI host: {}; port: {}; login: {}; pswd: {}; version: {}", host, port, login, pswd, version);
        this.setHostname(host);
        this.setPort(port);
        this.setUsername(login);
        this.setPassword(pswd);
    }

    protected AsteriskVersion determineVersion() throws IOException, TimeoutException {
        if (this.version != null) {
            return this.version;
        }
        return super.determineVersion();
    }
}

