/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process.queue.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bgerp.util.Log;
import ru.bgcrm.model.process.queue.config.SavedFilter;
import ru.bgcrm.util.Utils;

public class SavedCommonFiltersConfig {
    private Map<Integer, List<SavedFilter>> queueSavedCommonFilterSetsMap = new HashMap<Integer, List<SavedFilter>>();
    private Map<Integer, SavedFilter> savedCommonFilterSetMap = new HashMap<Integer, SavedFilter>();
    public static final String QUEUE_SAVED_COMMON_FILTER_SET_PREFIX = "queueSavedCommonFilterSet.";
    private int lastId;
    private Log log = Log.getLog();

    public SavedCommonFiltersConfig(ArrayList<SavedFilter> commonFilters) {
        for (SavedFilter commonFilter : commonFilters) {
            int id = commonFilter.getId();
            SavedFilter filter = commonFilter;
            if (id <= 0 || filter.getQueueId() <= 0 || Utils.isBlankString(filter.getUrl()) || Utils.isBlankString(filter.getTitle())) continue;
            this.getSetList(filter.getQueueId()).add(filter);
            this.savedCommonFilterSetMap.put(id, filter);
            this.lastId = id;
        }
    }

    private List<SavedFilter> getSetList(int queueId) {
        List<SavedFilter> setList = this.queueSavedCommonFilterSetsMap.get(queueId);
        if (setList == null) {
            setList = new ArrayList<SavedFilter>();
            this.queueSavedCommonFilterSetsMap.put(queueId, setList);
        }
        return setList;
    }

    public int addSavedCommonFilter(int queueId, String title, String url) {
        this.getSetList(queueId).add(new SavedFilter(queueId, -1, title, url));
        return this.lastId;
    }

    public void deleteSavedCommonFilter(int queueId, String title, String url) {
        SavedFilter filter = null;
        for (SavedFilter filterSet : this.getSetList(queueId)) {
            this.log.debug(String.valueOf(filterSet), new Object[0]);
            if (!filterSet.getTitle().equals(title) || !filterSet.getUrl().equals(url)) continue;
            filter = filterSet;
            break;
        }
        if (filter != null) {
            this.getSetList(queueId).remove(filter);
        }
    }

    public List<SavedFilter> getQueueSavedCommonFilterSetsMap(Integer queueId) {
        return this.queueSavedCommonFilterSetsMap.get(queueId);
    }

    public Map<Integer, List<SavedFilter>> getQueueSavedCommonFilterSetsMap() {
        return this.queueSavedCommonFilterSetsMap;
    }
}

