/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.email.message;

import com.google.common.annotations.VisibleForTesting;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.bgerp.action.open.ProcessAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.cache.UserCache;
import org.bgerp.dao.FileDataDAO;
import org.bgerp.dao.expression.Expression;
import org.bgerp.model.file.FileData;
import org.bgerp.model.msg.Message;
import org.bgerp.model.msg.config.MessageTypeConfig;
import org.bgerp.model.msg.config.TagConfig;
import org.bgerp.util.Log;
import org.bgerp.util.mail.MailMsg;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.util.Utils;

public class MessageContent {
    private static final Log log = Log.getLog();
    private final Setup setup;
    private final String encoding;
    private final String signExpression;
    private final boolean signStandard;

    MessageContent(Setup setup, String encoding, ConfigMap config) throws BGMessageException {
        this.setup = setup;
        this.encoding = encoding;
        this.signExpression = config.getSok("sign.expression", "signExpression");
        this.signStandard = config.getSokBoolean(true, "sign.standard", "signStandard");
    }

    void create(MimeMessage message, String lang, Message msg) throws Exception {
        Localizer l = Localization.getLocalizer(lang, "email");
        StringBuilder text = new StringBuilder(msg.getText().length() + 400).append(msg.getText()).append("\n\n-- ");
        if (Utils.notBlankString(this.signExpression)) {
            Map<String, Object> context = Map.of("user", UserCache.getUser(msg.getUserId()), "message", msg);
            text.append(new Expression(context).executeGetString(this.signExpression));
        }
        if (this.signStandard) {
            text.append(l.l("email.sign.standard", new Object[0])).append("\n");
        }
        MimeBodyPart historyPart = this.history(text, l, msg);
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setText(text.toString(), this.encoding);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)textPart);
        if (historyPart != null) {
            multipart.addBodyPart((BodyPart)historyPart);
        }
        if (!msg.getAttachList().isEmpty()) {
            try (Connection con = this.setup.getDBSlaveConnectionFromPool();){
                FileDataDAO fileDao = new FileDataDAO(con);
                for (FileData attach : msg.getAttachList()) {
                    File file = fileDao.getFile(attach);
                    MimeBodyPart attachPart = new MimeBodyPart();
                    attachPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
                    MailMsg.setAttachFileName(attachPart, attach.getTitle());
                    multipart.addBodyPart((BodyPart)attachPart);
                    log.debug("Attach: {}", attach.getTitle());
                }
            }
        }
        message.setContent((Multipart)multipart);
    }

    @VisibleForTesting
    protected MimeBodyPart history(StringBuilder text, Localizer l, Message msg) throws Exception {
        int processId = msg.getProcessId();
        if (processId <= 0) {
            return null;
        }
        String to = msg.getTo();
        Pair<Integer, List<Message>> pair = this.getHistory(l, text, processId, msg);
        int historyModeTag = pair.getFirst();
        List<Message> messageList = pair.getSecond();
        if (historyModeTag == 0) {
            return null;
        }
        text.append(l.l("\u0418\u0441\u0442\u043e\u0440\u0438\u044e \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u043a\u0438 \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0432 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 History.txt", new Object[0])).append("\n");
        StringBuilder history = new StringBuilder(1000).append(l.l("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439 \u043f\u043e \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0443 #{}", processId)).append(":\n------------------------------------------");
        MessageTypeConfig typeConfig = this.setup.getConfig(MessageTypeConfig.class);
        for (Message historyItem : messageList) {
            if (historyModeTag == -2 && !historyItem.getFrom().equals(to) && !historyItem.getTo().equals(to)) continue;
            MessageType type = (MessageType)typeConfig.getTypeMap().get(historyItem.getTypeId());
            history.append("\n\n").append(type.getMessageDescription(l.getLang(), historyItem)).append("\n------------------------------------------\n").append(historyItem.getText());
        }
        MimeBodyPart historyPart = new MimeBodyPart();
        historyPart.setText(history.toString(), this.encoding);
        historyPart.setFileName("History.txt");
        return historyPart;
    }

    @VisibleForTesting
    protected Pair<Integer, List<Message>> getHistory(Localizer l, StringBuilder text, int processId, Message msg) throws Exception {
        int historyModeTag = 0;
        List<Message> messageList = null;
        TagConfig tagsConfig = this.setup.getConfig(TagConfig.class);
        try (Connection con = this.setup.getDBSlaveConnectionFromPool();){
            MessageDAO dao = new MessageDAO(con);
            historyModeTag = tagsConfig.getSelectedHistoryTag(dao.getMessageTags(msg.getId()));
            if (historyModeTag != 0) {
                messageList = dao.getProcessMessageList(processId, msg.getId());
                if (historyModeTag == -3) {
                    this.openProcess(l, text, processId);
                }
            }
        }
        return new Pair<Integer, List<Message>>(historyModeTag, messageList);
    }

    private void openProcess(Localizer l, StringBuilder text, int processId) throws SQLException {
        ProcessAction.Config config = this.setup.getConfig(ProcessAction.Config.class);
        if (config == null) {
            return;
        }
        Process process = this.getProcess(processId);
        String url = config.url(process);
        if (Utils.notBlankString(url)) {
            text.append(l.l("\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430: {}", url)).append("\n");
        }
    }

    @VisibleForTesting
    protected Process getProcess(int processId) throws SQLException {
        try (Connection con = this.setup.getDBConnectionFromPool();){
            Process process = new ProcessDAO(con).getProcess(processId);
            return process;
        }
    }
}

