/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.base.tree;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.bgerp.model.base.tree.TreeItem;
import ru.bgcrm.util.Utils;

public class IdStringTitleTreeItem
extends TreeItem<String, IdStringTitleTreeItem> {
    public static Comparator<IdStringTitleTreeItem> COMPARATOR = (a, b) -> {
        Iterator<Integer> idsA = a.getIds().iterator();
        Iterator<Integer> idsB = b.getIds().iterator();
        if (idsA.hasNext() || idsB.hasNext()) {
            Integer nextB;
            if (!idsA.hasNext()) {
                return -1;
            }
            if (!idsB.hasNext()) {
                return 1;
            }
            Integer nextA = idsA.next();
            if (nextA != (nextB = idsB.next())) {
                return nextA - nextB;
            }
        }
        return 0;
    };
    private List<Integer> ids;

    public IdStringTitleTreeItem() {
        this.setId("");
        this.parentId = "";
        this.children = new ArrayList();
    }

    public IdStringTitleTreeItem(String id, String title, String parentId) {
        this.setId(id);
        this.setTitle(title);
        this.parentId = parentId;
        this.children = new ArrayList();
    }

    @Override
    public void setId(String id) {
        this.id = id;
        this.ids = new ArrayList<Integer>();
        for (String idPart : id.split("\\.")) {
            this.ids.add(Utils.parseInt(idPart));
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public List<Integer> getIds() {
        return this.ids;
    }

    @Override
    protected boolean isRootNode() {
        return Utils.isBlankString((String)this.id) && Utils.isBlankString((String)this.parentId);
    }
}

