/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.exec.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exec.scheduler.TaskConfig;
import org.bgerp.app.exec.scheduler.TasksConfig;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

public class Scheduler
extends Thread {
    private static final Log log = Log.getLog();
    private static final Scheduler INSTANCE = new Scheduler();
    private static final long SLEEP_TIME_MS = Duration.ofSeconds(60L).toMillis();
    private ThreadPoolExecutor pool;

    public static final Scheduler getInstance() {
        return INSTANCE;
    }

    private Scheduler() {
        this.setName("scheduler");
        this.start();
    }

    @Override
    public void run() {
        if (!Setup.getSetup().getBoolean("scheduler.start", true)) {
            log.info("Skipping scheduler start.", new Object[0]);
            return;
        }
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("scheduler-%d").build();
        this.pool = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        log.info("Starting scheduler..", new Object[0]);
        while (true) {
            try {
                while (true) {
                    if (this.pool.getActiveCount() < this.pool.getMaximumPoolSize()) {
                        List<TaskConfig> configs = Setup.getSetup().getConfig(TasksConfig.class).taskConfigsToRun(ZonedDateTime.now());
                        for (TaskConfig config : configs) {
                            String state = config.getNotRunnableState();
                            if (state != null) {
                                log.info("Skipping not runnable task: {}", state);
                                continue;
                            }
                            this.runTask(config);
                        }
                    } else {
                        log.warn("Execution pool max size was reached.", new Object[0]);
                    }
                    Scheduler.sleep(SLEEP_TIME_MS);
                }
            }
            catch (Exception e) {
                log.error(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask(TaskConfig taskConfig, boolean wait) throws Exception {
        log.info("runTask {}; wait: {}", taskConfig, wait);
        String state = taskConfig.getNotRunnableState();
        if (Utils.notBlankString(state)) {
            throw new IllegalArgumentException("The task isn't runnable: " + state);
        }
        if (wait) {
            try {
                taskConfig.taskRun();
            }
            finally {
                taskConfig.taskDone();
            }
        } else {
            this.runTask(taskConfig);
        }
    }

    private void runTask(final TaskConfig config) {
        log.info("Running scheduled task: {}", config);
        Runnable wrapper = new Runnable(){

            @Override
            public void run() {
                try {
                    config.taskRun();
                }
                catch (Exception e) {
                    log.error(e);
                }
                finally {
                    config.taskDone();
                }
            }
        };
        this.pool.execute(wrapper);
    }

    public int getRunningTaskCount() {
        return this.pool == null ? 0 : this.pool.getActiveCount();
    }
}

