/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.base.Id;
import org.bgerp.model.base.IdTitle;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractObject;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractObjectModuleInfo;
import ru.bgcrm.util.Utils;

public class ContractObjectDAO
extends BillingDAO {
    public ContractObjectDAO(User user, String billingId) {
        super(user, billingId);
    }

    public ContractObjectDAO(User user, DBInfo dbInfo) {
        super(user, dbInfo);
    }

    public List<ContractObject> getContractObjects(int contractId) {
        List<ContractObject> objects = new ArrayList<ContractObject>();
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.object", "ContractObjectService", "contractObjectList");
            req.setParam("contractId", contractId);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            objects = (List)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, ContractObject.class));
            Map<Integer, String> types = this.getContractObjectsTypes();
            objects.forEach(o -> o.setType((String)types.get(o.getTypeId())));
        } else {
            Request request = new Request();
            request.setModule("contract.object");
            request.setAction("ObjectTable");
            request.setContractId(contractId);
            Document doc = this.transferData.postData(request, this.user);
            for (Element e : XMLUtils.selectElements(doc, "/data/table/data/row")) {
                ContractObject object = new ContractObject();
                object.setId(Utils.parseInt(e.getAttribute("id")));
                object.setTitle(Utils.maskNull(e.getAttribute("title")));
                object.setTypeId(Utils.parseInt(e.getAttribute("type_id")));
                object.setType(Utils.maskNull(e.getAttribute("type")));
                object.setPeriod(Utils.maskNull(e.getAttribute("period")));
                objects.add(object);
            }
        }
        return objects;
    }

    public ContractObject getContractObject(int contractId, int objectId) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.object", "ContractObjectService", "contractObjectGetById");
            req.setParam("contractId", contractId);
            req.setParam("objectId", objectId);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            ContractObject contractObject = (ContractObject)this.jsonMapper.convertValue((Object)ret, ContractObject.class);
            Map<Integer, String> types = this.getContractObjectsTypes();
            contractObject.setType(types.get(contractObject.getTypeId()));
            return contractObject;
        }
        Request request = new Request();
        request.setModule("contract.object");
        request.setAction("ObjectGet");
        request.setAttribute("id", objectId);
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("object");
        ContractObject object = new ContractObject();
        if (nodeList.getLength() > 0) {
            Element rowElement = (Element)nodeList.item(0);
            object.setId(objectId);
            object.setTitle(rowElement.getAttribute("title"));
            object.setTypeId(Utils.parseInt(rowElement.getAttribute("type_id")));
            try {
                String dateTo;
                SimpleDateFormat dateFormatter = new SimpleDateFormat("dd.MM.yyyy");
                String dateFrom = rowElement.getAttribute("date1");
                if (Utils.notBlankString(dateFrom)) {
                    object.setDateFrom(dateFormatter.parse(dateFrom));
                }
                if (Utils.notBlankString(dateTo = rowElement.getAttribute("date2"))) {
                    object.setDateTo(dateFormatter.parse(dateTo));
                }
            }
            catch (ParseException e) {
                throw new BGException(e);
            }
        }
        return object;
    }

    public ContractObjectModuleInfo contractObjectModuleList(int objectId) {
        Object data;
        Element rowElement;
        int index;
        Request request = new Request();
        request.setModule("contract.object");
        request.setAction("ObjectModuleTable");
        request.setAttribute("object_id", objectId);
        Document document = this.transferData.postData(request, this.user);
        ContractObjectModuleInfo moduleInfo = new ContractObjectModuleInfo();
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("row");
        for (index = 0; index < nodeList.getLength(); ++index) {
            rowElement = (Element)nodeList.item(index);
            data = new ContractObjectModuleInfo.ContractObjectModuleData(moduleInfo);
            ((ContractObjectModuleInfo.ContractObjectModuleData)data).setComment(rowElement.getAttribute("comment"));
            ((ContractObjectModuleInfo.ContractObjectModuleData)data).setData(rowElement.getAttribute("data"));
            ((ContractObjectModuleInfo.ContractObjectModuleData)data).setModule(rowElement.getAttribute("module"));
            ((ContractObjectModuleInfo.ContractObjectModuleData)data).setPeriod(rowElement.getAttribute("period"));
            moduleInfo.getModuleDataList().add((ContractObjectModuleInfo.ContractObjectModuleData)data);
        }
        nodeList = dataElement.getElementsByTagName("module");
        for (index = 0; index < nodeList.getLength(); ++index) {
            rowElement = (Element)nodeList.item(index);
            data = new ContractObjectModuleInfo.ContractObjectModule(moduleInfo);
            ((ContractObjectModuleInfo.ContractObjectModule)data).setId(objectId);
            ((ContractObjectModuleInfo.ContractObjectModule)data).setName(rowElement.getAttribute("name"));
            ((ContractObjectModuleInfo.ContractObjectModule)data).setPackClient(rowElement.getAttribute("pack_client"));
            ((ContractObjectModuleInfo.ContractObjectModule)data).setTitle(rowElement.getAttribute("title"));
            moduleInfo.getModuleList().add((ContractObjectModuleInfo.ContractObjectModule)data);
        }
        return moduleInfo;
    }

    public void deleteContractObject(int contractId, int objectId) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.object", "ContractObjectService", "contractObjectDelete");
            req.setParam("objectId", objectId);
            this.transferData.postDataReturn(req, this.user);
        } else {
            Request request = new Request();
            request.setModule("contract.object");
            request.setAction("ObjectDelete");
            request.setAttribute("id", objectId);
            request.setContractId(contractId);
            this.transferData.postData(request, this.user);
        }
    }

    public int updateContractObject(int contractId, int objectId, int typeId, String title, Date dateFrom, Date dateTo) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            ContractObject contractObject = new ContractObject();
            contractObject.setContractId(contractId);
            contractObject.setId(objectId);
            contractObject.setTypeId(typeId);
            contractObject.setTitle(title);
            contractObject.setDateFrom(dateFrom);
            contractObject.setDateTo(dateTo);
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.object", "ContractObjectService", "contractObjectUpdate");
            req.setParamContractId(contractId);
            req.setParam("contractObject", contractObject);
            return this.transferData.postDataReturn(req, this.user).asInt();
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd.MM.yyyy");
        Request request = new Request();
        request.setModule("contract.object");
        request.setAction("ObjectUpdate");
        request.setAttribute("id", objectId);
        request.setAttribute("title", Utils.maskNull(title));
        if (dateFrom != null) {
            request.setAttribute("date1", dateFormatter.format(dateFrom));
        }
        if (dateTo != null) {
            request.setAttribute("date2", dateFormatter.format(dateTo));
        }
        if (contractId > 0) {
            request.setAttribute("cid", contractId);
        }
        return Utils.parseInt(XMLUtils.getElement(this.transferData.postData(request, this.user), "data").getAttribute("id"));
    }

    public Map<Integer, String> getContractObjectsTypes() {
        if (this.dbInfo.versionCompare("8.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.object", this.dbInfo.versionCompare("9.2") >= 0 ? "ContractObjectService" : "ObjectTypeService", "objectTypeList");
            req.setParam("onlyVisible", false);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            List list = (List)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
            return list.stream().collect(Collectors.toMap(Id::getId, IdTitle::getTitle));
        }
        return Collections.emptyMap();
    }
}

