/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.model.process.wizard;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.exception.BGException;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bgcrm.dao.AddressDAO;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.param.address.AddressHouse;
import ru.bgcrm.model.process.wizard.FillParamsStep;
import ru.bgcrm.model.process.wizard.base.StepData;
import ru.bgcrm.model.process.wizard.base.WizardData;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.dao.BGBillingDAO;
import ru.bgcrm.plugin.bgbilling.model.process.wizard.BaseStep;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractDAO;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

@Bean
public class ShowContractsByAddrParamStep
extends BaseStep {
    private final int addressParamId;
    private final SortedMap<Integer, ConfigMap> billingConfig;

    public ShowContractsByAddrParamStep(ConfigMap config) {
        super(config);
        this.addressParamId = config.getInt("addressParamId", 0);
        this.billingConfig = config.subIndexed("billing.");
    }

    public int getAddressParamId() {
        return this.addressParamId;
    }

    public SortedMap<Integer, ConfigMap> getBillingConfig() {
        return this.billingConfig;
    }

    @Override
    public String getJsp() {
        return "/WEB-INF/jspf/user/plugin/bgbilling/process/wizard/step_show_contract_by_address.jsp";
    }

    @Override
    public StepData<?> data(WizardData data) {
        return new Data(this, data);
    }

    public static class Data
    extends StepData<ShowContractsByAddrParamStep> {
        private int houseId;
        private Map<String, Document> contracts;

        private Data(ShowContractsByAddrParamStep step, WizardData data) {
            super(step, data);
        }

        public int getHouseId() {
            return this.houseId;
        }

        public Map<String, Document> getContracts() {
            return this.contracts;
        }

        @Override
        public boolean isFilled(DynActionForm form, Connection con) throws Exception {
            if (this.contracts == null) {
                List<StepData<?>> stepDataList = this.data.getStepDataList();
                for (int i = stepDataList.indexOf(this); i >= 0; --i) {
                    StepData<?> stepData = stepDataList.get(i);
                    if (!(stepData instanceof FillParamsStep.Data)) continue;
                    FillParamsStep.Data fpStepData = (FillParamsStep.Data)stepData;
                    SortedMap<Integer, ParameterAddressValue> values = new ParamValueDAO(con).getParamAddress(fpStepData.getObjectId(), ((ShowContractsByAddrParamStep)this.step).getAddressParamId());
                    if (values.size() <= 0) break;
                    HashMap<String, Document> result = new HashMap<String, Document>();
                    for (Map.Entry<Integer, ConfigMap> entry : ((ShowContractsByAddrParamStep)this.step).getBillingConfig().entrySet()) {
                        ConfigMap conf = entry.getValue();
                        String billingId = conf.get("id");
                        ParameterAddressValue val = values.values().iterator().next();
                        AddressDAO addressDAO = new AddressDAO(con);
                        AddressHouse addressHouse = addressDAO.getAddressHouse(val.getHouseId(), true, false, true);
                        Request request = new Request();
                        request.setModule("contract");
                        request.setAction("FindContract");
                        request.setAttribute("filter", 0);
                        request.setAttribute("show_sub", 0);
                        request.setAttribute("show_closed", "1");
                        request.setAttribute("type", 2);
                        request.setAttribute("street", addressHouse.getStreetId());
                        request.setAttribute("house", addressHouse.getHouse());
                        request.setAttribute("frac", addressHouse.getFrac() == null ? "" : addressHouse.getFrac());
                        request.setAttribute("flat", val.getFlat());
                        request.setAttribute("room", val.getRoom());
                        BGBillingDAO billingDAO = new BGBillingDAO();
                        Document doc = billingDAO.doRequestToBilling(billingId, this.data.getUser(), request);
                        this.appendBalance(doc, conf);
                        result.put(billingId, doc);
                    }
                    this.contracts = result;
                    break;
                }
            }
            return true;
        }

        private void appendBalance(Document doc, ConfigMap conf) throws BGException {
            Element dataElement = (Element)doc.getElementsByTagName("data").item(0);
            if (dataElement.getAttribute("status").equals("ok")) {
                Element contractsElement = (Element)dataElement.getElementsByTagName("contracts").item(0);
                NodeList nodeList = contractsElement.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element itemElement = (Element)nodeList.item(i);
                    int contractId = Utils.parseInt(itemElement.getAttribute("id"), -1);
                    ContractDAO contractDAO = new ContractDAO(this.data.getUser(), conf.get("id"));
                    if (!this.checkAndAppendAttrs(contractDAO.getContractCardDoc(contractId), itemElement, conf)) continue;
                    contractsElement.removeChild(nodeList.item(i));
                }
            }
        }

        private boolean checkAndAppendAttrs(Document doc, Element e, ConfigMap conf) {
            Element element;
            int dontDisplayStatementsCount = 0;
            Element contractElement = XMLUtils.selectElement(doc, "/data/contract");
            if (contractElement == null) {
                return true;
            }
            if (Utils.notEmptyString(contractElement.getAttribute("date2"))) {
                ++dontDisplayStatementsCount;
            }
            if ("1".equals(contractElement.getAttribute("del"))) {
                ++dontDisplayStatementsCount;
            }
            if ((element = XMLUtils.selectElement(doc, "/data/contract")) != null) {
                e.setAttribute("contractTitle", element.getAttribute("title"));
                e.setAttribute("balance", element.getAttribute("balance_rest"));
                e.setAttribute("comment", element.getAttribute("comment"));
                int status = Utils.parseInt(element.getAttribute("status"));
                switch (status) {
                    case 0: {
                        e.setAttribute("status", "\u0410\u043a\u0442\u0438\u0432\u0435\u043d");
                        break;
                    }
                    case 3: {
                        e.setAttribute("status", "\u0417\u0430\u043a\u0440\u044b\u0442");
                        break;
                    }
                    case 4: {
                        e.setAttribute("status", "\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
                        break;
                    }
                    case 1: {
                        e.setAttribute("status", "\u0412 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438");
                        break;
                    }
                    case 2: {
                        e.setAttribute("status", "\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d");
                        break;
                    }
                    case 5: {
                        e.setAttribute("status", "\u0412 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438");
                    }
                }
            }
            if ((element = XMLUtils.selectElement(doc, "/data/contract/tariff")) != null) {
                e.setAttribute("tariff", element.getAttribute("tariff_plan"));
            }
            if ((element = XMLUtils.selectElement(doc, "/data/parameters/parameter[@pid=" + conf.getInt("conlusionDateParamId", -1) + "]")) != null) {
                e.setAttribute("conclusionDate", element.getAttribute("value"));
            }
            String[] allowedGroupShowIds = conf.get("allowedGroupShowIds").split(",");
            Iterable<Element> elements = XMLUtils.selectElements(doc, "/data/info/groups/item");
            Object groupTitles = "";
            for (Element group : elements) {
                if (conf.get("dissolvedGroupId").equals(group.getAttribute("id"))) {
                    ++dontDisplayStatementsCount;
                }
                for (String groupId : allowedGroupShowIds) {
                    if (!groupId.equals(group.getAttribute("id"))) continue;
                    groupTitles = (String)groupTitles + "[ " + group.getAttribute("title") + " ] ";
                }
            }
            e.setAttribute("groups", (String)groupTitles);
            return dontDisplayStatementsCount > 1;
        }
    }
}

