/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.action.proto;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.model.base.IdTitle;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractTariffDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.DirectoryDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.tariff.ContractPersonalTariff;
import ru.bgcrm.plugin.bgbilling.proto.model.tariff.ContractTariff;
import ru.bgcrm.plugin.bgbilling.proto.model.tariff.ContractTariffOption;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/bgbilling/proto/contractTariff", pathId=true)
public class ContractTariffAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/bgbilling/contract/tariff";

    public ActionForward tariff(DynActionForm form, ConnectionSet conSet) throws ParseException {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        try {
            StringBuilder tariffs = new StringBuilder();
            List<ContractTariff> tariffList = crmDAO.contractTariffList(contractId);
            for (ContractTariff contractTariff : tariffList) {
                if (contractTariff.getDateTo() != null) continue;
                Utils.addCommaSeparated(tariffs, contractTariff.getTitle());
            }
            List<ContractPersonalTariff> personalTariffList = crmDAO.contractPersonalTariffList(contractId);
            for (ContractPersonalTariff tariff : personalTariffList) {
                if (tariff.getDate2() != null) continue;
                Utils.addCommaSeparated(tariffs, tariff.getTitle());
            }
            form.setResponseData("tariffs", tariffs);
        }
        catch (Exception e) {
            form.setResponseData("tariffs", "\u041d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430");
        }
        try {
            StringBuilder options = new StringBuilder();
            List<ContractTariffOption> optionList = crmDAO.contractTariffOptionList(contractId);
            for (ContractTariffOption contractTariffOption : optionList) {
                Utils.addCommaSeparated(options, contractTariffOption.getOptionTitle());
            }
            form.setResponseData("options", options);
        }
        catch (Exception e) {
            form.setResponseData("options", "\u041d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430");
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/tariff/tariff.jsp");
    }

    public ActionForward contractTariffList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        form.setResponseData("tariffList", crmDAO.contractTariffList(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/tariff/contract_tariff_list.jsp");
    }

    public ActionForward getContractTariff(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int moduleId = form.getParamInt("moduleId");
        boolean useFilter = form.getParamBoolean("useFilter", false);
        boolean showUsed = form.getParamBoolean("showUsed", false);
        ArrayList<IdTitle> tariffList = new ArrayList<IdTitle>();
        form.setResponseData("tariffList", tariffList);
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        form.setResponseData("contractTariff", crmDAO.getContractTariffPlan(form.getId(), moduleId, contractId, useFilter, showUsed, false, tariffList));
        form.setResponseData("moduleList", new DirectoryDAO(form.getUser(), billingId).getBillingModuleList());
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/tariff/contract_tariff_editor.jsp");
    }

    public ActionForward addContractTariff(DynActionForm form, ConnectionSet conSet) throws Exception {
        int tariffId = form.getParamInt("tariffId", -1);
        ContractTariffDAO contractDAO = new ContractTariffDAO(form.getUser(), form.getParam("billingId"));
        contractDAO.addTariffPlan(form.getParamInt("contractId", -1), tariffId, form.getParamInt("position", 0));
        return this.json(conSet, form);
    }

    public ActionForward setContractTariff(DynActionForm form, ConnectionSet conSet) throws Exception {
        int tariffId = form.getParamInt("tariffId", -1);
        ContractTariffDAO contractDAO = new ContractTariffDAO(form.getUser(), form.getParam("billingId"));
        contractDAO.setTariffPlan(form.getParamInt("contractId", -1), tariffId);
        return this.json(conSet, form);
    }

    public ActionForward updateContractTariff(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        String dateFrom = form.getParam("dateFrom");
        String dateTo = form.getParam("dateTo");
        String comment = form.getParam("comment");
        Integer contractId = form.getParamInt("contractId");
        Integer tariffPlanId = form.getParamInt("tariffPlanId");
        Integer position = form.getParamInt("position");
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        crmDAO.updateContractTariffPlan(contractId, form.getId(), tariffPlanId, position, dateFrom, dateTo, comment);
        return this.json(conSet, form);
    }

    public ActionForward delete\u0421ontractTariff(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        crmDAO.deleteContractTariffPlan(contractId, form.getId());
        return this.json(conSet, form);
    }

    public ActionForward personalTariffList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        form.setResponseData("personalTariffList", crmDAO.contractPersonalTariffList(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/tariff/personal_tariff_list.jsp");
    }

    public ActionForward getPersonalTariff(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        if (form.getId() > 0) {
            form.setResponseData("personalTariff", new ContractTariffDAO(form.getUser(), billingId).getPersonalTariff(form.getId()));
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/tariff/personal_tariff_editor.jsp");
    }

    public ActionForward updatePersonalTariff(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Integer position = form.getParamInt("position");
        String title = form.getParam("title");
        String dateFrom = form.getParam("dateFrom");
        String dateTo = form.getParam("dateTo");
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        crmDAO.updateContractPersonalTariff(contractId, form.getId(), title, position, dateFrom, dateTo);
        return this.json(conSet, form);
    }

    public ActionForward deletePersonalTariff(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        crmDAO.deleteContractPersonalTariff(contractId, form.getId());
        return this.json(conSet, form);
    }

    public ActionForward tariffOptionList(DynActionForm form, ConnectionSet conSet) throws ParseException {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        form.setResponseData("list", crmDAO.contractTariffOptionList(contractId));
        form.setResponseData("history", crmDAO.contractTariffOptionHistory(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/tariff/tariff_option_list.jsp");
    }

    public ActionForward tariffOptionEditor(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int optionId = form.getParamInt("optionId");
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        List<IdTitle> optionList = crmDAO.contractAvailableOptionList(contractId);
        if (optionId <= 0 && optionList.size() > 0) {
            optionId = Utils.getFirst(optionList).getId();
            form.setParam("optionId", String.valueOf(optionId));
        }
        form.setResponseData("availableOptionList", optionList);
        if (optionId > 0) {
            form.setResponseData("activateModeList", crmDAO.activateModeList(contractId, optionId));
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/tariff/tariff_option_editor.jsp");
    }

    public ActionForward activateTariffOption(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Integer optionId = form.getParamInt("optionId");
        Integer modeId = form.getParamInt("modeId");
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        crmDAO.activateContractOption(contractId, optionId, modeId, false);
        return this.json(conSet, form);
    }

    public ActionForward deleteTariffOption(DynActionForm form, ConnectionSet conSet) throws ParseException {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Integer optionId = form.getParamInt("optionId");
        ContractTariffDAO crmDAO = new ContractTariffDAO(form.getUser(), billingId);
        crmDAO.deactivateContractOption(contractId, optionId);
        return this.json(conSet, form);
    }
}

