/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.sql.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.commons.dbcp2.DelegatingConnection;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.bgerp.util.sql.pool.PoolGuardConnectionWrapper;

final class GuardSupportedPool {
    final GenericObjectPool<PoolableConnection> pool;
    final PoolingDataSource<PoolableConnection> dataSource;

    public GuardSupportedPool(final GenericObjectPool<PoolableConnection> pool) {
        this.pool = pool;
        this.dataSource = new PoolingDataSource<PoolableConnection>(this, pool){

            public Connection getConnection() throws SQLException {
                try {
                    Connection conn = (Connection)pool.borrowObject();
                    if (conn != null) {
                        conn = new PoolGuardConnectionWrapper((DelegatingConnection<Connection>)((DelegatingConnection)conn));
                    }
                    return conn;
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (NoSuchElementException e) {
                    throw new SQLException("Cannot get a connection, pool error " + e.getMessage(), e);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SQLException("Cannot get a connection, general error", e);
                }
            }
        };
    }

    public boolean isOverload() {
        return this.pool.getMaxTotal() <= this.pool.getNumActive();
    }

    public float getLoadRatio() {
        return (float)this.pool.getNumActive() / (float)this.pool.getMaxTotal();
    }
}

