/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.email.message;

import jakarta.mail.Address;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.bgerp.action.ProcessAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.alarm.AlarmSender;
import org.bgerp.app.l10n.Localization;
import org.bgerp.app.l10n.Localizer;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.dao.FileDataDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.file.FileData;
import org.bgerp.model.file.tmp.FileInfo;
import org.bgerp.model.file.tmp.SessionTemporaryFiles;
import org.bgerp.model.msg.config.MessageTypeConfig;
import org.bgerp.plugin.msg.email.MessageParser;
import org.bgerp.plugin.msg.email.message.FolderCache;
import org.bgerp.plugin.msg.email.message.MessageContent;
import org.bgerp.util.Log;
import org.bgerp.util.mail.Addresses;
import org.bgerp.util.mail.MailConfig;
import org.bgerp.util.mail.MailMsg;
import ru.bgcrm.dao.Locker;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.user.UserDAO;
import ru.bgcrm.event.process.ProcessMessageAddedEvent;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.user.User;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

@Bean(oldClasses={"ru.bgcrm.dao.message.MessageTypeEmail"})
public class MessageTypeEmail
extends MessageType {
    private static final Log log = Log.getLog();
    @Deprecated
    public static final String RE_PREFIX = "Re: ";
    private static final String AUTOREPLY_SYSTEM_ID = "autoreply";
    private final String encoding;
    private final Pattern processIdPattern;
    private final boolean processedRead;
    private final Pattern quickAnswerPattern;
    private final int quickAnswerEmailParamId;
    private final int autoCreateProcessTypeId;
    private final boolean autoCreateProcessNotification;
    private final String autoCreateProcessNotificationTextMessage;
    private final String replayTo;
    private final MailConfig mailConfig;
    private final String folderIncoming;
    private final String folderSkipped;
    private final String folderProcessed;
    private final String folderSent;
    private final String folderTrash;
    private final MessageContent messageBuilder;
    private final FolderCache incomingCache = new FolderCache(this);

    public MessageTypeEmail(Setup setup, int id, ConfigMap config) throws BGMessageException {
        super(setup, id, config.get("title"), config);
        Localizer l = Localization.getLocalizer(Localization.getLang(), "email");
        this.encoding = MailMsg.getParamMailEncoding(setup);
        this.mailConfig = new MailConfig(config);
        this.replayTo = config.get("replayTo");
        this.folderIncoming = config.get("folderIn", "INBOX");
        this.folderProcessed = config.get("folderProcessed", "CRM_PROCESSED");
        this.folderSkipped = config.get("folderSkipped", "CRM_SKIPPED");
        this.folderSent = config.get("folderSent", "CRM_SENT");
        this.folderTrash = config.get("folderTrash", "Trash");
        this.processIdPattern = Pattern.compile(this.mailConfig.getEmail().replaceAll("\\.", "\\\\.") + "#(\\d+)");
        this.processedRead = config.getBoolean("processed.read", true);
        this.quickAnswerPattern = Pattern.compile("QA:(\\d+)");
        this.quickAnswerEmailParamId = config.getInt("quickAnswerEmailParamId", -1);
        this.autoCreateProcessTypeId = config.getInt("autoCreateProcess.typeId", -1);
        this.autoCreateProcessNotification = config.getBoolean("autoCreateProcess.notification", true);
        this.autoCreateProcessNotificationTextMessage = config.get("autoCreateProcess.notification.text.message", l.l("email.autoCreateProcess.notification.text.message.default", new Object[0]));
        this.messageBuilder = new MessageContent(setup, this.encoding, config);
        if (!this.mailConfig.check()) {
            throw new BGException("Incorrect message type, email: " + this.mailConfig.getEmail(), new Object[0]);
        }
    }

    public String getEmail() {
        return this.mailConfig.getEmail();
    }

    @Override
    public boolean isAnswerSupport() {
        return true;
    }

    @Override
    public org.bgerp.model.msg.Message getAnswerMessage(org.bgerp.model.msg.Message original) {
        org.bgerp.model.msg.Message result = new org.bgerp.model.msg.Message();
        result.setTypeId(original.getTypeId());
        result.setProcessId(original.getProcessId());
        result.setSubject(this.getAnswerSubject(original.getSubject()));
        result.setText(this.answerText(original.getText()));
        Addresses addresses = Addresses.parseSafe(original.getTo()).exclude(this.getEmail()).addTo(original.getFrom());
        result.setTo(addresses.serialize());
        return result;
    }

    protected String getAnswerSubject(String subject) {
        if (Setup.getSetup().getBoolean("email:answer.subject.prepend.with.re")) {
            return (subject = Utils.maskNull(subject)).toLowerCase().contains(RE_PREFIX.toLowerCase()) ? subject : RE_PREFIX + subject;
        }
        return subject;
    }

    @Override
    public boolean isEditable(org.bgerp.model.msg.Message message) {
        return message == null || message.getDirection() == 2 && message.getToTime() == null;
    }

    @Override
    public boolean isRemovable(org.bgerp.model.msg.Message message) {
        return true;
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    public boolean isProcessChangeSupport() {
        return true;
    }

    @Override
    public String getViewerJsp() {
        return "/WEB-INF/jspf/user/plugin/email/message_viewer.jsp";
    }

    @Override
    public String getHeaderJsp() {
        return "/WEB-INF/jspf/user/plugin/email/process_message_header.jsp";
    }

    @Override
    public String getMessageDescription(String lang, org.bgerp.model.msg.Message message) {
        Localizer l = Localization.getLocalizer(lang, "email");
        StringBuilder result = new StringBuilder(200);
        result.append("EMail: \"").append(message.getSubject()).append("\"; ").append(message.getFrom()).append(" => ").append(message.getTo()).append("; ");
        if (message.getDirection() == 1) {
            result.append(l.l("\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e: ", new Object[0])).append(TimeUtils.format(message.getFromTime(), "ymdhm"));
        } else {
            result.append(l.l("\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e: ", new Object[0])).append(TimeUtils.format(message.getToTime(), "ymdhm"));
        }
        return result.toString();
    }

    @Override
    public String getEditorJsp() {
        return "/WEB-INF/jspf/user/plugin/email/process_message_editor.jsp";
    }

    @Override
    public void process() {
        log.info("Starting EMail daemon, box: {}", this.mailConfig.getEmail());
        this.readBox();
        this.sendMessages();
    }

    @Override
    public synchronized List<org.bgerp.model.msg.Message> newMessageList(ConnectionSet conSet) throws Exception {
        List<Object> result = new ArrayList();
        long time = System.currentTimeMillis();
        try (Store store = this.mailConfig.getImapStore();
             Folder incomingFolder = store.getFolder(this.folderIncoming);){
            log.debug("{} get imap store time: {} ms.", this.getEmail(), System.currentTimeMillis() - time);
            time = System.currentTimeMillis();
            incomingFolder.open(1);
            result = this.incomingCache.list(incomingFolder);
            log.debug("{} new message list time: {} ms.", this.getEmail(), System.currentTimeMillis() - time);
        }
        this.unprocessedMessagesCount = result.size();
        return result;
    }

    @Override
    public org.bgerp.model.msg.Message newMessageGet(ConnectionSet conSet, String messageId) throws Exception {
        return this.newMessageGet(messageId, true);
    }

    private org.bgerp.model.msg.Message newMessageGet(String messageId, boolean tryRelist) throws Exception {
        org.bgerp.model.msg.Message result;
        block20: {
            result = null;
            Store store = this.mailConfig.getImapStore();
            Folder incomingFolder = store.getFolder(this.folderIncoming);
            incomingFolder.open(1);
            Message[] messages = incomingFolder.getMessages();
            int index = 0;
            try {
                index = this.incomingCache.idToIndex(messageId);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.incomingCache.relist(incomingFolder);
                if (tryRelist) {
                    org.bgerp.model.msg.Message message = this.newMessageGet(messageId, false);
                    if (incomingFolder != null) {
                        incomingFolder.close();
                    }
                    if (store != null) {
                        store.close();
                    }
                    return message;
                }
                throw new IllegalArgumentException("Not found message with ID: " + messageId);
            }
            MessageParser mp = new MessageParser(messages[index]);
            result = this.extractMessage(mp, true);
            for (FileData attach : mp.getAttachContent()) {
                result.addAttach(attach);
            }
            {
                break block20;
                finally {
                    if (incomingFolder != null) {
                        try {
                            incomingFolder.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            finally {
                if (store != null) {
                    try {
                        store.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3;
                        throwable3.addSuppressed(throwable);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public synchronized void messageDelete(ConnectionSet conSet, String ... messageIds) throws Exception {
        if (messageIds.length == 1 && Utils.parseInt(messageIds[0]) > 0) {
            new MessageDAO(conSet.getConnection()).deleteMessage(Utils.parseInt(messageIds[0]));
            return;
        }
        try (Store store = this.mailConfig.getImapStore();
             Folder incomingFolder = store.getFolder(this.folderIncoming);
             Folder trashFolder = store.getFolder(this.folderTrash);){
            incomingFolder.open(2);
            trashFolder.open(2);
            Message[] messages = incomingFolder.getMessages();
            ArrayList<Message> list = new ArrayList<Message>(messageIds.length);
            for (String messageId : messageIds) {
                int index = this.incomingCache.idToIndex(messageId);
                Message message = messages[index];
                message.setFlag(Flags.Flag.DELETED, true);
                list.add(message);
            }
            incomingFolder.copyMessages(list.toArray(new Message[0]), trashFolder);
            incomingFolder.close();
            incomingFolder.open(1);
            this.incomingCache.relist(incomingFolder);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public org.bgerp.model.msg.Message newMessageLoad(Connection con, String messageId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendMessages() {
        Session session = this.mailConfig.getSmtpSession(this.setup);
        try (Connection con = this.setup.getDBConnectionFromPool();
             Transport transport = session.getTransport();
             Store imapStore = this.mailConfig.getImapStore();
             Folder imapSentFolder = imapStore.getFolder(this.folderSent);){
            this.checkFolders(imapSentFolder);
            MessageDAO messageDAO = new MessageDAO(con);
            transport.connect();
            imapSentFolder.open(2);
            List<org.bgerp.model.msg.Message> toSendList = messageDAO.getUnsendMessageList(this.id, 100);
            for (org.bgerp.model.msg.Message msg : toSendList) {
                log.info("Sending message ID: {}, subject: {}, to: {}", msg.getId(), msg.getSubject(), msg.getTo());
                if (Locker.checkLock(msg.getLockEdit())) {
                    log.info("Skipping message on lock", new Object[0]);
                    continue;
                }
                try {
                    MimeMessage message = new MimeMessage(session);
                    message.setFrom((Address)new InternetAddress(this.mailConfig.getFrom()));
                    if (Utils.notBlankString(this.replayTo)) {
                        message.setReplyTo((Address[])InternetAddress.parse((String)this.replayTo));
                    }
                    for (Map.Entry<Message.RecipientType, InternetAddress[]> me : Addresses.parseSafe(msg.getTo()).recipients().entrySet()) {
                        message.addRecipients(me.getKey(), (Address[])me.getValue());
                    }
                    String subject = msg.getSubject();
                    int processId = this.getProcessId(subject);
                    if (processId <= 0 && msg.getProcessId() > 0) {
                        subject = this.getSubjectWithProcessIdSuffix(msg);
                    }
                    message.setSubject(subject, this.encoding);
                    message.setSentDate(new Date());
                    this.messageBuilder.create(message, Localization.getLang(), msg);
                    transport.sendMessage((Message)message, message.getAllRecipients());
                    if (imapSentFolder != null) {
                        message.setFlag(Flags.Flag.SEEN, true);
                        imapSentFolder.appendMessages(new Message[]{message});
                        log.info("Saved copy to folder: {}", this.folderSent);
                    }
                }
                catch (Exception e) {
                    log.error(e);
                }
                if (AUTOREPLY_SYSTEM_ID.equals(msg.getSystemId())) {
                    messageDAO.deleteMessage(msg.getId());
                } else {
                    msg.setToTime(new Date());
                    messageDAO.updateMessageProcess(msg);
                }
                con.commit();
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    private String getSubjectWithProcessIdSuffix(org.bgerp.model.msg.Message msg) {
        return msg.getSubject() + " [" + this.mailConfig.getEmail() + "#" + msg.getProcessId() + "]";
    }

    private void readBox() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             Store store = this.mailConfig.getImapStore();
             Folder incomingFolder = store.getFolder(this.folderIncoming);
             Folder processedFolder = store.getFolder(this.folderProcessed);
             Folder skippedFolder = store.getFolder(this.folderSkipped);){
            this.checkFolders(processedFolder, skippedFolder, store.getFolder(this.folderTrash));
            incomingFolder.open(2);
            processedFolder.open(2);
            skippedFolder.open(2);
            Message[] messages = null;
            List<org.bgerp.model.msg.Message> list = this.incomingCache.list(incomingFolder);
            for (int i = 0; i < list.size(); ++i) {
                org.bgerp.model.msg.Message message = list.get(i);
                String subject = message.getSubject();
                if (this.getProcessId(subject) > 0 || this.getQuickAnswerMessageId(subject) > 0 || this.autoCreateProcessTypeId > 0) {
                    if (messages == null) {
                        messages = incomingFolder.getMessages();
                    }
                    this.processMessage(con, incomingFolder, processedFolder, skippedFolder, messages[i]);
                    continue;
                }
                log.debug("Skipping message with subject: {}", subject);
            }
            this.unprocessedMessagesCount = list.size();
        }
        catch (Exception e) {
            log.error("Reading box " + this.mailConfig.getEmail() + ": " + e.getMessage(), e);
        }
    }

    private org.bgerp.model.msg.Message processMessage(Connection con, Folder incomingFolder, Folder processedFolder, Folder skippedFolder, Message message) throws MessagingException {
        String key = "email.process.error";
        org.bgerp.model.msg.Message result = null;
        String subject = "???";
        try {
            MessageParser mp = new MessageParser(message);
            subject = mp.getMessageSubject();
            if (Utils.maskNull(subject).contains("test.email.process.error")) {
                throw new Exception("Test alarm exception");
            }
            org.bgerp.model.msg.Message msg = this.extractMessage(mp, true);
            FileDataDAO fileDao = new FileDataDAO(con);
            for (FileData file : mp.getAttachContent()) {
                FileOutputStream out = fileDao.add(file);
                IOUtils.write((byte[])file.getData(), (OutputStream)out);
                msg.addAttach(file);
            }
            result = this.processMessage(con, msg);
            incomingFolder.copyMessages(new Message[]{message}, processedFolder);
            con.commit();
        }
        catch (Exception e) {
            log.error(e);
            incomingFolder.copyMessages(new Message[]{message}, skippedFolder);
            String s = subject;
            AlarmSender.send("email.process.error", 0L, "Email processing error", () -> "Subject: " + s, e, () -> {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
                    message.writeTo((OutputStream)bos);
                    return List.of(new FileData("message.eml", bos.toByteArray()));
                }
                catch (Exception ex) {
                    log.error(ex);
                    return null;
                }
            });
        }
        if (!message.isExpunged()) {
            message.setFlag(Flags.Flag.DELETED, true);
        }
        return result;
    }

    private org.bgerp.model.msg.Message processMessage(Connection con, org.bgerp.model.msg.Message msg) throws Exception {
        MessageDAO messageDAO = new MessageDAO(con);
        ProcessDAO processDAO = new ProcessDAO(con);
        String subject = msg.getSubject();
        int processId = this.getProcessId(subject);
        int quickAnsweredMessageId = this.getQuickAnswerMessageId(subject);
        log.info("Mailbox: {} found message From: {} Subject: {} Content: {} Process ID: {} Quick answer message ID: {} ", this.mailConfig.getEmail(), msg.getFrom(), subject, msg.getText(), processId, quickAnsweredMessageId);
        Process process = null;
        if (processId > 0) {
            process = processDAO.getProcess(processId);
            if (process == null) {
                log.error("Not found process with code: {}", processId);
            } else {
                this.setMessageProcessed(msg, processId);
            }
        } else if (quickAnsweredMessageId > 0) {
            org.bgerp.model.msg.Message quickAnsweredMessage = messageDAO.getMessageById(quickAnsweredMessageId);
            if (quickAnsweredMessage == null) {
                log.error("Message not found: {}", quickAnsweredMessageId);
            } else {
                MessageTypeEmail quickAnsweredMessageType = (MessageTypeEmail)this.setup.getConfig(MessageTypeConfig.class).getTypeMap().get(quickAnsweredMessage.getTypeId());
                msg.setTypeId(quickAnsweredMessage.getTypeId());
                msg.setDirection(2);
                msg.setProcessId(quickAnsweredMessage.getProcessId());
                msg.setTo(quickAnsweredMessage.getFrom());
                msg.setFromTime(new Date());
                msg.setToTime(null);
                msg.setSubject(this.getAnswerSubject(quickAnsweredMessage.getSubject()));
                Pageable<ParameterSearchedObject<User>> searchResult = new Pageable<ParameterSearchedObject<User>>();
                new UserDAO(con).searchUserListByEmail(searchResult, Collections.singletonList(this.quickAnswerEmailParamId), msg.getFrom());
                ParameterSearchedObject<User> user = Utils.getFirst(searchResult.getList());
                if (user != null) {
                    log.info("Creating quick answer on message: {}", quickAnsweredMessageId);
                    quickAnsweredMessageType.updateMessageInt(con, new DynActionForm(user.getObject()), msg);
                    return msg;
                }
            }
        } else if (this.autoCreateProcessTypeId > 0) {
            process = new Process();
            process.setTypeId(this.autoCreateProcessTypeId);
            process.setDescription(msg.getSubject());
            ProcessAction.processCreate(DynActionForm.SYSTEM_FORM, con, process);
            log.info("Created process: {}", process.getId());
            this.setMessageProcessed(msg, process.getId());
            if (this.autoCreateProcessNotification) {
                messageDAO.updateMessage(this.messageLinkedToProcess(msg));
            }
        }
        messageDAO.updateMessage(msg);
        if (process != null) {
            ProcessType type = ProcessTypeCache.getProcessType(process.getTypeId());
            if (type == null) {
                log.error("Not found process type with id: {}", process.getTypeId());
            } else {
                EventProcessor.processEvent(new ProcessMessageAddedEvent(DynActionForm.SYSTEM_FORM, msg, process), new SingleConnectionSet(con));
            }
        }
        return msg;
    }

    private void setMessageProcessed(org.bgerp.model.msg.Message msg, int processId) {
        log.debug("setMessageProcessed processId: {}, processedRead: {}", processId, this.processedRead);
        msg.setProcessId(processId);
        if (this.processedRead) {
            msg.setToTime(new Date());
            msg.setUserId(0);
        }
    }

    private org.bgerp.model.msg.Message extractMessage(MessageParser mp, boolean extractText) throws Exception {
        org.bgerp.model.msg.Message msg = new org.bgerp.model.msg.Message();
        msg.setTypeId(this.id);
        msg.setDirection(1);
        msg.setFrom(mp.getFrom());
        msg.setTo(mp.getTo());
        msg.setSystemId(mp.getMessageId());
        msg.setFromTime(mp.getFromTime());
        msg.setSubject(mp.getMessageSubject());
        if (extractText) {
            msg.setText(mp.getTextContent());
        }
        return msg;
    }

    private int getProcessId(String subject) {
        Matcher m = this.processIdPattern.matcher(subject);
        if (m.find()) {
            return Utils.parseInt(m.group(1));
        }
        return -1;
    }

    private int getQuickAnswerMessageId(String subject) {
        Matcher m = this.quickAnswerPattern.matcher(subject);
        if (m.find()) {
            return Utils.parseInt(m.group(1));
        }
        return -1;
    }

    @Override
    public void updateMessage(Connection con, DynActionForm form, org.bgerp.model.msg.Message message) throws Exception {
        String to = form.getParam("to", "");
        if (Utils.isBlankString(to)) {
            throw new BGMessageException(Localization.getLocalizer(Localization.getLang(), "email"), "Undefined recipient address.", new Object[0]);
        }
        Addresses addresses = Addresses.parse(form.l.getLang(), to);
        addresses.put(Message.RecipientType.CC, (List)Addresses.parse(form.l.getLang(), form.getParam("toCc", "")).get(Message.RecipientType.TO));
        message.setTo(addresses.serialize());
        this.updateMessageInt(con, form, message);
    }

    private void updateMessageInt(Connection con, DynActionForm form, org.bgerp.model.msg.Message message) throws Exception {
        message.setSystemId("");
        message.setFrom(this.mailConfig.getEmail());
        Map<Integer, FileInfo> tmpFiles = this.processMessageAttaches(con, form, message);
        new MessageDAO(con).updateMessage(message);
        SessionTemporaryFiles.deleteFiles(form, tmpFiles.keySet());
    }

    @Override
    public org.bgerp.model.msg.Message messageLinkedToProcess(org.bgerp.model.msg.Message message) {
        org.bgerp.model.msg.Message result = new org.bgerp.model.msg.Message();
        Object text = message.getText().replace("\r", "");
        text = ">" + ((String)text).replace("\n", "\n>");
        text = this.autoCreateProcessNotificationTextMessage + (String)text;
        result.setSystemId(AUTOREPLY_SYSTEM_ID);
        result.setDirection(2);
        result.setTypeId(this.id);
        result.setProcessId(message.getProcessId());
        result.setFrom(this.mailConfig.getEmail());
        result.setTo(Addresses.parseSafe(message.getTo()).addTo(message.getFrom()).exclude(this.mailConfig.getEmail()).serialize());
        result.setFromTime(new Date());
        result.setText((String)text);
        result.setSubject(this.getAnswerSubject(message.getSubject()));
        return result;
    }

    private void checkFolders(Folder ... folders) throws MessagingException {
        for (Folder folder : folders) {
            if (folder.exists()) continue;
            folder.create(1);
        }
    }
}

