/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.subscription.action;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.time.temporal.ChronoUnit;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.struts.action.ActionForward;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.l10n.Localization;
import org.bgerp.plugin.bil.subscription.Config;
import org.bgerp.plugin.bil.subscription.action.ReportPaymentAction;
import org.bgerp.plugin.bil.subscription.model.Subscription;
import org.bgerp.plugin.report.model.Column;
import org.bgerp.plugin.report.model.Columns;
import org.bgerp.plugin.report.model.Data;
import org.bgerp.plugin.report.model.Record;
import org.bgerp.util.TimeConvert;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/report/plugin/subscription/debt")
public class ReportDebtAction
extends ReportPaymentAction {
    private static final Columns COLUMNS = new Columns(new Column.ColumnInteger("subscription_id", null, null), new Column.ColumnInteger("process_id", null, "Subscription Process"), new Column.ColumnInteger("customer_id", null, null), new Column.ColumnString("customer_title", null, "Customer"), new Column.ColumnDecimal("payment_amount", null, "Amount"), new Column.ColumnInteger("payment_user_id", null, null), new Column.ColumnString("payment_user_title", null, "Payment User"), new Column.ColumnDecimal("payment_user_tax", null, "Incoming Tax"), new Column.ColumnInteger("months", null, "Months"), new Column.ColumnDecimal("service_cost", null, "Service Cost"), new Column.ColumnDecimal("discount", null, "Discount"), new Column.ColumnDecimal("owners_amount", null, "Owners Amount"), new Column.ColumnInteger("product_id", null, null), new Column.ColumnString("product_description", null, "Product Process"), new Column.ColumnDecimal("product_cost", null, "Product Cost"), new Column.ColumnDecimal("product_cost_part", null, "Product Cost Part"));
    private static final Selector SELECTOR = new Selector();

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        return super.unspecified(form, conSet);
    }

    @Override
    public String getTitle() {
        return Localization.getLocalizer(Localization.getLang(), "subscription").l("Subscription Debts", new Object[0]);
    }

    @Override
    protected String getHref() {
        return "report/subscription/debt";
    }

    @Override
    protected String getJsp() {
        return "/WEB-INF/jspf/user/plugin/subscription/report/debt.jsp";
    }

    @Override
    public Columns getColumns() {
        return COLUMNS;
    }

    @Override
    protected Selector getSelector() {
        return SELECTOR;
    }

    private static final class Selector
    extends ReportPaymentAction.Selector {
        private Selector() {
        }

        @Override
        protected void select(ConnectionSet conSet, Data data) throws Exception {
            Connection con = conSet.getSlaveConnection();
            DynActionForm form = data.getForm();
            Config config = Setup.getSetup().getConfig(Config.class);
            form.setRequestAttribute("config", config);
            java.util.Date date = form.getParamDate("dateFrom");
            if (date == null) {
                form.setParam("dateFrom", TimeUtils.format(TimeUtils.getPrevMonth(), "ymd"));
                return;
            }
            int userId = form.getUserId();
            TreeMap subscriptionUserAmounts = new TreeMap();
            form.setResponseData("subscriptionUserAmounts", subscriptionUserAmounts);
            for (Subscription subscription : config.getSubscriptions()) {
                TreeMap<Integer, BigDecimal> userAmounts = new TreeMap<Integer, BigDecimal>();
                TreeSet<Integer> serviceCostAddedProcessIds = new TreeSet<Integer>();
                try (PreparedQuery pq = this.query(con, config, subscription, date, -1);){
                    ResultSet rs = pq.executeQuery();
                    while (rs.next()) {
                        int subscriptionProcessId = rs.getInt("invoice.process_id");
                        int serviceConsultantId = rs.getInt("service_consultant.user_id");
                        int productOwnerId = rs.getInt("product_owner.user_id");
                        if ((userId != serviceConsultantId || !serviceCostAddedProcessIds.add(subscriptionProcessId)) && userId != productOwnerId) continue;
                        BigDecimal amount = rs.getBigDecimal("invoice.amount");
                        Date dateFrom = rs.getDate("invoice.date_from");
                        java.util.Date dateTo = Utils.maskNull(rs.getDate("invoice.date_to"), dateFrom);
                        BigDecimal months = BigDecimal.valueOf(ChronoUnit.MONTHS.between(TimeConvert.toYearMonth(dateFrom), TimeConvert.toYearMonth(dateTo)) + 1L);
                        BigDecimal incomingTaxPercent = rs.getBigDecimal("invoice_tax.value");
                        BigDecimal serviceCost = Utils.maskNullDecimal(rs.getBigDecimal("service_cost.value")).multiply(months);
                        int paymentUserId = rs.getInt("invoice.payment_user_id");
                        Record record = data.addRecord();
                        record.add(subscription.getId());
                        record.add(subscriptionProcessId);
                        record.add(rs.getInt("invoice_customer.object_id"));
                        record.add(rs.getString("invoice_customer.object_title"));
                        record.add(amount);
                        record.add(paymentUserId);
                        record.add(null);
                        record.add(incomingTaxPercent);
                        record.add(months.intValue());
                        if (userId == serviceConsultantId) {
                            BigDecimal userAmount = userAmounts.computeIfAbsent(paymentUserId, unused -> BigDecimal.ZERO).add(this.incomingTax(incomingTaxPercent, serviceCost));
                            userAmounts.put(paymentUserId, userAmount);
                            record.add(serviceCost);
                        } else {
                            record.add(null);
                        }
                        if (userId == productOwnerId) {
                            BigDecimal discount = Utils.maskNullDecimal(rs.getBigDecimal("discount.value")).multiply(months);
                            BigDecimal productCost = Utils.maskNullDecimal(rs.getBigDecimal("product_cost.count")).multiply(months);
                            BigDecimal ownersAmount = amount.subtract(serviceCost);
                            BigDecimal fullCost = ownersAmount.add(discount);
                            BigDecimal ownersAmountAfterTax = this.incomingTax(incomingTaxPercent, ownersAmount);
                            BigDecimal ownerPart = productCost.multiply(ownersAmountAfterTax).divide(fullCost, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                            BigDecimal userAmount = userAmounts.computeIfAbsent(paymentUserId, unused -> BigDecimal.ZERO).add(ownerPart);
                            userAmounts.put(paymentUserId, userAmount);
                            record.add(discount);
                            record.add(ownersAmount);
                            record.add(rs.getInt("product.id"));
                            record.add(rs.getString("product.description"));
                            record.add(productCost);
                            record.add(ownerPart);
                            continue;
                        }
                        record.add(null).add(null).add(null).add(null).add(null).add(null);
                    }
                }
                if (userAmounts.isEmpty()) continue;
                subscriptionUserAmounts.put(subscription.getId(), userAmounts);
            }
        }
    }
}

