/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.action.ProcessAction;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.model.base.tree.TreeItem;
import org.bgerp.model.process.config.ProcessCreateInConfig;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.struts.form.DynActionForm;

public class ProcessCreateType
extends TreeItem<Integer, ProcessCreateType> {
    private static final Log log = Log.getLog();
    private final ProcessType type;
    private final String area;
    private final ProcessCreateInConfig config;

    public static ProcessCreateType treeRoot(DynActionForm form, String area, Set<Integer> ids) {
        List<ProcessCreateType> types = ProcessAction.processCreateTypes(form, area, ids);
        Set<Integer> typeIds = types.stream().map(TreeItem::getId).collect(Collectors.toSet());
        log.debug("treeRoot area: {}, ids: {}, typeIds: {}", area, ids, typeIds);
        return new ProcessCreateType(ProcessTypeCache.getTypeTreeRoot(), area).children(typeIds);
    }

    public ProcessCreateType(ProcessType type, String area) {
        this.setId((Integer)type.getId());
        this.setTitle(type.getTitle());
        this.type = type;
        this.area = area;
        this.config = type.getProperties() == null ? null : type.getProperties().getConfigMap().getConfig(ProcessCreateInConfig.class);
    }

    public ProcessType getType() {
        return this.type;
    }

    @Dynamic
    public String getSelectedClass() {
        String className = "treeItemSelected";
        if (this.config != null && this.config.selected(this.area)) {
            return "treeItemSelected";
        }
        for (ProcessCreateType child : this.children) {
            if (!"treeItemSelected".equals(child.getSelectedClass())) continue;
            return "treeItemSelected";
        }
        return "";
    }

    public boolean check() {
        return this.config.check(this.area);
    }

    public String getCopyParams() {
        return this.config.getCopyParams();
    }

    public boolean openCreated() {
        return this.config.openCreated(this.area);
    }

    public String toString() {
        return String.valueOf(this.type.getId());
    }

    @Override
    protected boolean isRootNode() {
        throw new UnsupportedOperationException("Unimplemented method 'isRootNode'");
    }

    private ProcessCreateType children(Set<Integer> ids) {
        ArrayList<ProcessCreateType> children = new ArrayList<ProcessCreateType>(this.type.getChildren().size());
        for (ProcessType childType : this.type.getChildren()) {
            ProcessCreateType child = new ProcessCreateType(childType, this.area);
            if (!childType.isInPathTo(ids)) continue;
            children.add(child.children(ids));
        }
        this.setChildren(children);
        return this;
    }
}

