/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.action.proto;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.model.msg.Message;
import org.bgerp.model.msg.config.MessageTypeConfig;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.message.MessageType;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.Pair;
import ru.bgcrm.plugin.bgbilling.message.MessageTypeHelpDesk;
import ru.bgcrm.plugin.bgbilling.proto.dao.HelpDeskDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.helpdesk.HdMessage;
import ru.bgcrm.plugin.bgbilling.proto.model.helpdesk.HdTopic;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/bgbilling/proto/helpdesk", pathId=true)
public class HelpDeskAction
extends BaseAction {
    public ActionForward getAttach(DynActionForm form, ConnectionSet conSet) throws Exception {
        int processId = form.getParamInt("processId");
        String billingId = form.getParam("billingId");
        int attachId = form.getParamInt("id");
        String title = form.getParam("title");
        MessageTypeHelpDesk mt = this.setup.getConfig(MessageTypeConfig.class).getTypeMap().values().stream().filter(type -> type instanceof MessageTypeHelpDesk && ((MessageTypeHelpDesk)type).getBillingId().equals(billingId)).findFirst().orElse(null);
        if (mt != null) {
            HdTopic topic;
            HelpDeskDAO hdDao = new HelpDeskDAO(mt.getUser(), mt.getDbInfo());
            List<CommonObjectLink> links = new ProcessLinkDAO(conSet.getConnection()).getObjectLinksWithType(processId, null);
            CommonObjectLink topicLink = links.stream().filter(link -> link.getLinkObjectType().equals(mt.getObjectType())).findFirst().orElse(null);
            if (topicLink == null) {
                throw new BGException("\u041a \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0443 \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u0442\u043e\u043f\u0438\u043a HelpDesk.", new Object[0]);
            }
            CommonObjectLink contractLink = links.stream().filter(link -> ("contract:" + billingId).equals(link.getLinkObjectType())).findFirst().orElse(null);
            if (contractLink == null) {
                throw new BGException("\u041a \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0443 \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440 BGBilling.", new Object[0]);
            }
            Pair<HdTopic, List<HdMessage>> pair = hdDao.getTopicWithMessages(topicLink.getLinkObjectId());
            HdTopic hdTopic = topic = pair != null ? pair.getFirst() : null;
            if (topic == null) {
                throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0435\u043c\u0430 HelpDesk \u0441 \u043a\u043e\u0434\u043e\u043c: " + topicLink.getLinkObjectId(), new Object[0]);
            }
            byte[] attach = hdDao.getAttach(contractLink.getLinkObjectId(), attachId);
            HttpServletResponse response = form.getHttpResponse();
            Utils.setFileNameHeaders(response, title);
            ServletOutputStream out = response.getOutputStream();
            IOUtils.copy((InputStream)new ByteArrayInputStream(attach), (OutputStream)out);
            out.flush();
        }
        return null;
    }

    public ActionForward markMessageRead(DynActionForm form, ConnectionSet conSet) throws Exception {
        int messageId = form.getParamInt("messageId");
        if (messageId <= 0) {
            throw new BGIllegalArgumentException();
        }
        MessageDAO messageDao = new MessageDAO(conSet.getConnection());
        Message message = messageDao.getMessageById(messageId);
        if (message == null) {
            throw new BGException("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e", new Object[0]);
        }
        MessageTypeConfig config = this.setup.getConfig(MessageTypeConfig.class);
        MessageType mt = (MessageType)config.getTypeMap().get(message.getTypeId());
        if (mt == null || !(mt instanceof MessageTypeHelpDesk)) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043b\u0438\u0431\u043e \u044d\u0442\u043e \u043d\u0435 HelpDesk \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", new Object[0]);
        }
        MessageTypeHelpDesk mtHd = (MessageTypeHelpDesk)mt;
        HelpDeskDAO hdDao = new HelpDeskDAO(form.getUser(), mtHd.getDbInfo());
        hdDao.markMessageRead(Utils.parseInt(message.getSystemId()));
        message.setToTime(new Date());
        message.setUserId(form.getUserId());
        messageDao.updateMessageProcess(message);
        return this.json(conSet, form);
    }
}

