/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.blow.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ProcessQueueCache;
import org.bgerp.model.base.Id;
import org.bgerp.plugin.pln.blow.model.BoardConfig;
import ru.bgcrm.model.user.User;

public class BoardsConfig
extends Config {
    private SortedMap<Integer, BoardConfig> boardMap = new TreeMap<Integer, BoardConfig>();

    protected BoardsConfig(ConfigMap config, boolean validate) throws BGMessageException {
        super(null, validate);
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("blow:board.").entrySet()) {
            BoardConfig b = new BoardConfig((int)me.getKey(), me.getValue());
            this.boardMap.put(b.getId(), b);
        }
    }

    public Collection<BoardConfig> getBoards(User user) {
        Set queueIds = ProcessQueueCache.getUserQueueList(user).stream().map(Id::getId).collect(Collectors.toSet());
        return this.boardMap.values().stream().filter(board -> queueIds.contains(board.getQueue().getId())).collect(Collectors.toList());
    }

    public BoardConfig getBoard(int id) {
        return (BoardConfig)this.boardMap.get(id);
    }

    public List<BoardConfig> getOpenBoards() {
        return this.boardMap.values().stream().filter(b -> StringUtils.isNotBlank((CharSequence)b.getOpenUrl())).collect(Collectors.toList());
    }
}

