/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bgb.getolt.dao;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.bgerp.plugin.bgb.getolt.Config;
import org.bgerp.plugin.bgb.getolt.model.OnuApiResponse;
import org.bgerp.plugin.bgb.getolt.model.OnuData;
import org.bgerp.plugin.bgb.getolt.model.OnuSearchResult;
import org.bgerp.plugin.bgb.getolt.model.RefreshResult;
import org.bgerp.util.Log;

public class GetOltApiClient {
    private static final Log log = Log.getLog();
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final CloseableHttpClient HTTP_CLIENT;
    private final Config config;
    private final RequestConfig defaultRequestConfig;
    private final RequestConfig longRequestConfig;

    public GetOltApiClient(Config config) {
        this.config = config;
        this.defaultRequestConfig = RequestConfig.custom().setConnectTimeout(config.getApiTimeout()).setSocketTimeout(config.getApiTimeout()).setConnectionRequestTimeout(config.getApiTimeout()).build();
        this.longRequestConfig = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(30000).setConnectionRequestTimeout(30000).build();
    }

    public OnuSearchResult searchOnu(String operator, String contractNumber, Integer cid) {
        if (!this.config.isConfigured()) {
            log.warn("GetOLT plugin is not configured", new Object[0]);
            return OnuSearchResult.error("GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            StringBuilder urlBuilder = new StringBuilder(this.config.getApiUrl());
            if (!urlBuilder.toString().endsWith("/")) {
                urlBuilder.append("/");
            }
            urlBuilder.append("onus/erp-search?");
            urlBuilder.append("operator=").append(URLEncoder.encode(operator, StandardCharsets.UTF_8));
            if (contractNumber != null && !contractNumber.isEmpty()) {
                urlBuilder.append("&contractNumber=").append(URLEncoder.encode(contractNumber, StandardCharsets.UTF_8));
            }
            if (cid != null) {
                urlBuilder.append("&cid=").append(cid);
            }
            String url = urlBuilder.toString();
            log.debug("GetOLT API request: {}", url);
            HttpGet request = new HttpGet(url);
            request.setConfig(this.defaultRequestConfig);
            request.setHeader("X-API-Key", this.config.getApiKey());
            request.setHeader("Accept", "application/json");
            CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            log.debug("GetOLT API response: status={}, bodyLen={}", statusCode, responseBody.length());
            if (statusCode == 404) {
                OnuSearchResult result = OnuSearchResult.error("ONU \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + (contractNumber != null ? contractNumber : String.valueOf(cid)));
                result.setContractNumber(contractNumber);
                result.setCid(cid);
                result.setOperator(operator);
                return result;
            }
            if (statusCode >= 400) {
                log.error("GetOLT API error: status={}, body={}", statusCode, responseBody);
                return OnuSearchResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 GetOLT");
            }
            return this.parseResponse(responseBody, operator, contractNumber, cid);
        }
        catch (SocketTimeoutException e) {
            log.error("GetOLT API timeout: {}", e.getMessage());
            return OnuSearchResult.error("\u0421\u0435\u0440\u0432\u0438\u0441 GetOLT \u043d\u0435 \u043e\u0442\u0432\u0435\u0447\u0430\u0435\u0442");
        }
        catch (Exception e) {
            log.error("GetOLT API error", e);
            return OnuSearchResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043e\u0442\u0432\u0435\u0442\u0430");
        }
    }

    private OnuSearchResult parseResponse(String responseBody, String operator, String contractNumber, Integer cid) {
        try {
            OnuSearchResult result;
            log.debug("Parsing GetOLT response: {}", responseBody.length() > 500 ? responseBody.substring(0, 500) + "..." : responseBody);
            JsonNode root = MAPPER.readTree(responseBody);
            List<OnuData> onus = new ArrayList();
            if (root.isArray()) {
                onus = (List)MAPPER.readValue(responseBody, (TypeReference)new TypeReference<List<OnuData>>(this){});
            } else if (root.isObject()) {
                OnuData onu;
                JsonNode dataNode = root.get("data");
                if (dataNode != null && dataNode.isObject()) {
                    OnuApiResponse.OnuApiData data;
                    OnuApiResponse apiResponse = (OnuApiResponse)MAPPER.readValue(responseBody, OnuApiResponse.class);
                    if (apiResponse.getData() != null && (data = apiResponse.getData()).getTarget() != null) {
                        OnuData target = data.getTarget();
                        if (data.getPortNeighbors() != null && !data.getPortNeighbors().isEmpty()) {
                            target.setNeighbors(data.getPortNeighbors());
                        }
                        onus.add(target);
                        log.debug("Parsed target ONU: mac={}, oltIp={}, port={}", target.getMac(), target.getOltIp(), target.getPort());
                    }
                } else if (dataNode != null && dataNode.isArray()) {
                    onus = (List)MAPPER.readValue(dataNode.traverse(), (TypeReference)new TypeReference<List<OnuData>>(this){});
                } else if (dataNode == null && (onu = (OnuData)MAPPER.readValue(responseBody, OnuData.class)) != null && onu.getMac() != null) {
                    onus.add(onu);
                }
            }
            log.debug("Parsed {} ONUs from response", onus.size());
            onus.sort((a, b) -> {
                if (a.getLastUpdate() == null && b.getLastUpdate() == null) {
                    return 0;
                }
                if (a.getLastUpdate() == null) {
                    return 1;
                }
                if (b.getLastUpdate() == null) {
                    return -1;
                }
                return b.getLastUpdate().compareTo(a.getLastUpdate());
            });
            if (onus.isEmpty()) {
                result = OnuSearchResult.error("ONU \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + (contractNumber != null ? contractNumber : String.valueOf(cid)));
                result.setContractNumber(contractNumber);
                result.setCid(cid);
                result.setOperator(operator);
                return result;
            }
            result = OnuSearchResult.success(onus);
            result.setContractNumber(contractNumber);
            result.setCid(cid);
            result.setOperator(operator);
            return result;
        }
        catch (Exception e) {
            log.error("Error parsing GetOLT response: {}", e.getMessage(), e);
            return OnuSearchResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043e\u0442\u0432\u0435\u0442\u0430");
        }
    }

    public RefreshResult refreshPort(String oltIp, int portNumber) {
        if (!this.config.isConfigured()) {
            log.warn("GetOLT plugin is not configured", new Object[0]);
            return RefreshResult.error("GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            JsonNode data;
            StringBuilder urlBuilder = new StringBuilder(this.config.getApiUrl());
            if (!urlBuilder.toString().endsWith("/")) {
                urlBuilder.append("/");
            }
            urlBuilder.append("actions/refresh/olt/").append(URLEncoder.encode(oltIp, StandardCharsets.UTF_8)).append("/port/").append(portNumber);
            String url = urlBuilder.toString();
            log.info("GetOLT refresh: POST {} port {}", oltIp, portNumber);
            HttpPost request = new HttpPost(url);
            request.setConfig(this.longRequestConfig);
            request.setHeader("X-API-Key", this.config.getApiKey());
            request.setHeader("Accept", "application/json");
            CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            log.debug("GetOLT refresh response: status={}, body={}", statusCode, responseBody);
            if (statusCode >= 400) {
                log.error("GetOLT refresh error: status={}, body={}", statusCode, responseBody);
                return RefreshResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f: " + statusCode);
            }
            JsonNode root = MAPPER.readTree(responseBody);
            boolean success = root.path("success").asBoolean(false);
            if (success && (data = root.get("data")) != null) {
                String operationId = data.path("operationId").asText(null);
                String status = data.path("status").asText(null);
                String message = data.path("message").asText(null);
                return RefreshResult.success(operationId, status, message);
            }
            String errorMsg = root.path("message").asText("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
            return RefreshResult.error(errorMsg);
        }
        catch (SocketTimeoutException e) {
            log.error("GetOLT refresh timeout: {}", e.getMessage());
            return RefreshResult.error("\u0421\u0435\u0440\u0432\u0438\u0441 GetOLT \u043d\u0435 \u043e\u0442\u0432\u0435\u0447\u0430\u0435\u0442");
        }
        catch (Exception e) {
            log.error("GetOLT refresh error", e);
            return RefreshResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
    }

    public RefreshResult rebootOnu(int oltId, int port, int onuId) {
        if (!this.config.isConfigured()) {
            log.warn("GetOLT plugin is not configured", new Object[0]);
            return RefreshResult.error("GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            String apiUrl;
            String baseUrl = apiUrl = this.config.getApiUrl();
            int externalIdx = apiUrl.indexOf("/v1/external");
            if (externalIdx > 0) {
                baseUrl = apiUrl.substring(0, externalIdx);
            }
            String url = baseUrl + "/olt/" + oltId + "/onu/" + port + "/" + onuId + "/reboot";
            log.info("GetOLT reboot: oltId={}, port={}, onuId={}", oltId, port, onuId);
            HttpPost request = new HttpPost(url);
            request.setConfig(this.longRequestConfig);
            request.setHeader("X-API-Key", this.config.getApiKey());
            request.setHeader("Accept", "application/json");
            CloseableHttpResponse response = HTTP_CLIENT.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            log.debug("GetOLT reboot response: status={}, body={}", statusCode, responseBody);
            if (statusCode == 429) {
                JsonNode root = MAPPER.readTree(responseBody);
                Object errorMsg = root.path("error").asText("ONU \u043d\u0435\u0434\u0430\u0432\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u043b\u0430\u0441\u044c");
                int remainingSeconds = root.path("remainingSeconds").asInt(0);
                if (remainingSeconds > 0) {
                    int mins = remainingSeconds / 60;
                    int secs = remainingSeconds % 60;
                    errorMsg = "ONU \u043d\u0435\u0434\u0430\u0432\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u043b\u0430\u0441\u044c. \u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435 " + mins + " \u043c\u0438\u043d. " + secs + " \u0441\u0435\u043a.";
                }
                return RefreshResult.error((String)errorMsg);
            }
            if (statusCode >= 400) {
                log.error("GetOLT reboot error: status={}, body={}", statusCode, responseBody);
                JsonNode root = MAPPER.readTree(responseBody);
                String errorMsg = root.path("error").asText("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 ONU");
                return RefreshResult.error(errorMsg);
            }
            JsonNode root = MAPPER.readTree(responseBody);
            boolean success = root.path("success").asBoolean(false);
            if (success) {
                String message = root.path("message").asText("ONU \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430");
                return RefreshResult.success(null, "completed", message);
            }
            String errorMsg = root.path("error").asText(root.path("message").asText("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430"));
            return RefreshResult.error(errorMsg);
        }
        catch (SocketTimeoutException e) {
            log.error("GetOLT reboot timeout: {}", e.getMessage());
            return RefreshResult.error("\u0421\u0435\u0440\u0432\u0438\u0441 GetOLT \u043d\u0435 \u043e\u0442\u0432\u0435\u0447\u0430\u0435\u0442");
        }
        catch (Exception e) {
            log.error("GetOLT reboot error", e);
            return RefreshResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 ONU");
        }
    }

    static {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(20);
        connManager.setDefaultMaxPerRoute(10);
        HTTP_CLIENT = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }
}

