/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bgb.getolt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.plugin.bgb.getolt.model.BillingConfig;
import org.bgerp.util.Log;

public class Config
extends org.bgerp.app.cfg.Config {
    private static final Log log = Log.getLog();
    private static final String CONFIG_API_URL = "api.url";
    private static final String CONFIG_API_KEY = "api.key";
    private static final String CONFIG_API_TIMEOUT = "api.timeout";
    private static final String CONFIG_OPERATOR_PARAM_ID = "operator.paramId";
    private static final String CONFIG_OPERATOR_DEFAULT = "operator.default";
    private static final String CONFIG_OPERATOR_MAPPING_PREFIX = "operator.mapping.";
    private static final String CONFIG_OPERATOR_BILLING_PREFIX = "operator.billing.";
    private static final String CONFIG_INETMAC_PREFIX = "inetmac.";
    private final String apiUrl;
    private final String apiKey;
    private final int apiTimeout;
    private final int operatorParamId;
    private final String defaultOperator;
    private final Map<Integer, String> paramOperatorMapping;
    private final Map<String, String> billingOperatorMapping;
    private final Map<String, BillingConfig> inetMacConfigs;

    protected Config(ConfigMap config) throws Config.InitStopException {
        super(null);
        if (config == null) {
            this.apiUrl = "";
            this.apiKey = "";
            this.apiTimeout = 5000;
            this.operatorParamId = 68;
            this.defaultOperator = "\u0420\u0422\u0426";
            this.paramOperatorMapping = new HashMap<Integer, String>();
            this.billingOperatorMapping = new HashMap<String, String>();
            this.inetMacConfigs = new HashMap<String, BillingConfig>();
            return;
        }
        config = config.sub("getolt:");
        this.apiUrl = config.get(CONFIG_API_URL, "");
        this.apiKey = config.get(CONFIG_API_KEY, "");
        this.apiTimeout = config.getInt(CONFIG_API_TIMEOUT, 5000);
        this.operatorParamId = config.getInt(CONFIG_OPERATOR_PARAM_ID, 68);
        this.defaultOperator = config.get(CONFIG_OPERATOR_DEFAULT, "\u0420\u0422\u0426");
        this.paramOperatorMapping = new HashMap<Integer, String>();
        for (Map.Entry<String, String> entry : config.sub(CONFIG_OPERATOR_MAPPING_PREFIX).entrySet()) {
            try {
                int valueId = Integer.parseInt(entry.getKey());
                this.paramOperatorMapping.put(valueId, entry.getValue());
            }
            catch (NumberFormatException e) {
                log.warn("Invalid operator mapping key: {}", entry.getKey());
            }
        }
        this.billingOperatorMapping = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : config.sub(CONFIG_OPERATOR_BILLING_PREFIX).entrySet()) {
            this.billingOperatorMapping.put(entry.getKey(), entry.getValue());
        }
        this.inetMacConfigs = new HashMap<String, BillingConfig>();
        ConfigMap inetmacConfig = config.sub(CONFIG_INETMAC_PREFIX);
        Set<String> operators = this.extractOperatorNames(inetmacConfig);
        for (String operator : operators) {
            ConfigMap opConfig = inetmacConfig.sub(operator + ".");
            String url = opConfig.get("url", "");
            String user = opConfig.get("user", "");
            String password = opConfig.get("password", "");
            int timeout = opConfig.getInt("timeout", 10000);
            if (url.isEmpty()) continue;
            BillingConfig billingCfg = new BillingConfig(url, user, password, timeout);
            this.inetMacConfigs.put(operator, billingCfg);
            log.debug("InetMac config for '{}': url={}, user={}, timeout={}", operator, url, user, timeout);
        }
        log.debug("GetOLT API URL: {}", this.apiUrl);
        log.debug("GetOLT API key configured: {}", !this.apiKey.isEmpty());
        log.debug("GetOLT API timeout: {}ms", this.apiTimeout);
        log.debug("Operator param ID: {}", this.operatorParamId);
        log.debug("Default operator: {}", this.defaultOperator);
        log.debug("Param operator mapping: {}", this.paramOperatorMapping);
        log.debug("Billing operator mapping: {}", this.billingOperatorMapping);
        log.debug("InetMac configs for operators: {}", this.inetMacConfigs.keySet());
        this.initWhen(!this.apiUrl.isEmpty() && !this.apiKey.isEmpty());
    }

    private Set<String> extractOperatorNames(ConfigMap config) {
        HashSet<String> operators = new HashSet<String>();
        for (String key : config.keySet()) {
            int dotIndex = key.indexOf(46);
            if (dotIndex <= 0) continue;
            operators.add(key.substring(0, dotIndex));
        }
        return operators;
    }

    public boolean isConfigured() {
        return !this.apiUrl.isEmpty() && !this.apiKey.isEmpty();
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getApiTimeout() {
        return this.apiTimeout;
    }

    public int getOperatorParamId() {
        return this.operatorParamId;
    }

    public String getDefaultOperator() {
        return this.defaultOperator;
    }

    public String getParamOperatorMapping(int valueId) {
        return this.paramOperatorMapping.get(valueId);
    }

    public String getBillingOperatorMapping(String billingId) {
        return this.billingOperatorMapping.get(billingId);
    }

    public BillingConfig getInetMacConfig(String operator) {
        return this.inetMacConfigs.get(operator);
    }

    public boolean hasInetMacConfig(String operator) {
        BillingConfig cfg = this.inetMacConfigs.get(operator);
        return cfg != null && cfg.isConfigured();
    }
}

