/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.cache.ParameterCache;
import org.bgerp.model.base.IdStringTitle;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.base.IdTitleComment;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class Parameter
extends IdTitleComment {
    private static final Log log = Log.getLog();
    public static final String PARAM_MULTIPLE_KEY = "multiple";
    public static final String LIST_PARAM_USE_DIRECTORY_KEY = "directory";
    public static final String LIST_PARAM_AVAILABLE_VALUES_KEY = "availableValues";
    public static final String LIST_PARAM_AVAILABLE_VALUES_INNER_JOIN_FILTER_KEY = "availableValuesInnerJoinFilter";
    public static final String TYPE_ADDRESS = "address";
    public static final String TYPE_BLOB = "blob";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_DATETIME = "datetime";
    public static final String TYPE_EMAIL = "email";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_LIST = "list";
    public static final String TYPE_LISTCOUNT = "listcount";
    public static final String TYPE_MONEY = "money";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_PHONE = "phone";
    public static final String TYPE_TREE = "tree";
    public static final String TYPE_TREECOUNT = "treecount";
    @Dynamic
    public static final List<IdStringTitle> TYPES = EnumSet.allOf(Type.class).stream().map(type -> type.name).sorted().map(name -> new IdStringTitle((String)name, (String)name)).collect(Collectors.toList());
    private static Map<String, Type> NAME_MAP = EnumSet.allOf(Type.class).stream().collect(Collectors.toMap(type -> type.name, type -> type));
    private String type;
    private String objectType;
    private String config = "";
    private ConfigMap configMap;
    private String valuesConfig;
    private int order;

    public Parameter withTitle(String value) {
        this.setTitle(value);
        return this;
    }

    public Parameter withComment(String value) {
        this.setComment(value);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Type getTypeType() {
        return Type.of(this.type);
    }

    public void setType(String type) {
        this.type = type;
    }

    public Parameter withType(String value) {
        this.type = value;
        return this;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String value) {
        this.objectType = value;
    }

    public Parameter withObjectType(String value) {
        this.objectType = value;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Parameter withOrder(int value) {
        this.order = value;
        return this;
    }

    public String getConfig() {
        return this.config;
    }

    public ConfigMap getConfigMap() {
        return this.configMap;
    }

    public void setConfig(String config) {
        this.config = config;
        this.configMap = new Preferences(config);
    }

    public Parameter withConfig(String value) {
        this.setConfig(value);
        return this;
    }

    public void setValuesConfig(String config) {
        this.valuesConfig = config;
    }

    public String getValuesConfig() {
        return this.valuesConfig;
    }

    public Parameter withValuesConfig(String value) {
        this.valuesConfig = value;
        return this;
    }

    public List<IdTitle> getListParamValues() {
        return ParameterCache.getListParamValues(this);
    }

    public String getDateParamFormat() {
        String format = "";
        format = TYPE_DATETIME.equals(this.type) ? TimeUtils.getTypeFormat(this.getConfigMap().get("type", "ymd")) : TimeUtils.getTypeFormat("ymd");
        return format;
    }

    public Map<Integer, BigDecimal> getListCountDefaultValues() {
        return Utils.toIntegerSet(this.configMap.get("defaultValues")).stream().collect(Collectors.toMap(Function.identity(), unused -> BigDecimal.ZERO));
    }

    public boolean isReadonly() {
        return this.configMap.getBoolean("readonly", false);
    }

    public String getShowAsLink() {
        return this.configMap.getSok("show.as.link", "showAsLink");
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ id = ");
        builder.append(this.id);
        builder.append("; object = ");
        builder.append(this.objectType);
        builder.append("; type = ");
        builder.append(this.type);
        builder.append("; title = ");
        builder.append(this.title);
        builder.append("; config = ");
        builder.append((String)(this.config == null ? "null" : this.config.split("\n").length + " lines"));
        builder.append(" ]");
        return builder.toString();
    }

    @Deprecated
    @JsonIgnore
    public String getObject() {
        log.warndMethod("getObject", "getObjectType");
        return this.objectType;
    }

    @Deprecated
    public void setObject(String object) {
        log.warndMethod("setObject", "setObjectType");
        this.objectType = object;
    }

    public static enum Type {
        ADDRESS("address"),
        BLOB("blob"),
        DATE("date"),
        DATETIME("datetime"),
        EMAIL("email"),
        FILE("file"),
        LIST("list"),
        LISTCOUNT("listcount"),
        MONEY("money"),
        TEXT("text"),
        PHONE("phone"),
        TREE("tree"),
        TREECOUNT("treecount");

        private final String name;

        public static Type of(String name) {
            return NAME_MAP.get(name);
        }

        public static String emailToString(Collection<ParameterEmailValue> values) {
            return Utils.toString(values, "", ", ");
        }

        public static String listToString(int paramId, Map<Integer, String> values) {
            StringBuilder result = new StringBuilder(100);
            for (IdTitle value : ParameterCache.getListParamValues(paramId)) {
                String comment = values.get(value.getId());
                if (comment == null) continue;
                Utils.addCommaSeparated(result, (String)(comment.isEmpty() ? value.getTitle() : value.getTitle() + " [" + comment + "]"));
            }
            return result.toString();
        }

        public static String listCountToString(int paramId, Map<Integer, BigDecimal> values) {
            StringBuilder result = new StringBuilder(100);
            for (IdTitle value : ParameterCache.getListParamValues(paramId)) {
                BigDecimal count = values.get(value.getId());
                if (count == null) continue;
                Utils.addCommaSeparated(result, value.getTitle() + ": " + String.valueOf(count));
            }
            return result.toString();
        }

        public static String treeToString(int paramId, Set<String> values) {
            StringBuilder result = new StringBuilder(100);
            Map<String, String> valuesMap = ParameterCache.getTreeParamValues(paramId);
            for (Map.Entry<String, String> me : valuesMap.entrySet()) {
                if (!values.contains(me.getKey())) continue;
                Utils.addCommaSeparated(result, me.getValue());
            }
            return result.toString();
        }

        public static String treeCountToString(int paramId, Map<String, BigDecimal> values) {
            StringBuilder result = new StringBuilder(100);
            Map<String, String> valuesMap = ParameterCache.getTreeParamValues(paramId);
            for (Map.Entry<String, String> me : valuesMap.entrySet()) {
                BigDecimal count = values.get(me.getKey());
                if (count == null) continue;
                Utils.addCommaSeparated(result, me.getValue() + ": " + String.valueOf(count));
            }
            return result.toString();
        }

        private Type(String name) {
            this.name = name;
        }
    }
}

