/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.msg;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bgerp.cache.UserCache;
import org.bgerp.model.base.Id;
import org.bgerp.model.file.FileData;
import ru.bgcrm.model.process.Process;

public class Message
extends Id {
    public static final String OBJECT_TYPE = "message";
    public static final int DIRECTION_INCOMING = 1;
    public static final int DIRECTION_OUTGOING = 2;
    private String systemId = "";
    private int processId;
    private Process process;
    private int typeId = -1;
    private int direction = 1;
    private int userId;
    private Date fromTime;
    private Date toTime;
    private String from = "";
    private String to = "";
    private String subject = "";
    private String text = "";
    private List<FileData> attaches = new ArrayList<FileData>();

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String value) {
        this.systemId = value;
    }

    public Message withSystemId(String value) {
        this.setSystemId(value);
        return this;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int value) {
        this.processId = value;
    }

    public Message withProcessId(int value) {
        this.setProcessId(value);
        return this;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process value) {
        this.process = value;
        this.processId = value.getId();
    }

    public Message withProcess(Process value) {
        this.setProcess(value);
        return this;
    }

    public Date getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(Date value) {
        this.fromTime = value;
    }

    public Message withFromTime(Date value) {
        this.setFromTime(value);
        return this;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
    }

    public Message withText(String value) {
        this.setText(value);
        return this;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int value) {
        this.typeId = value;
    }

    public Message withTypeId(int value) {
        this.setTypeId(value);
        return this;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int value) {
        this.userId = value;
    }

    public Message withUserId(int value) {
        this.setUserId(value);
        return this;
    }

    public String getUserTitle() {
        return UserCache.getUser(this.userId).getTitle();
    }

    public Date getToTime() {
        return this.toTime;
    }

    public void setToTime(Date value) {
        this.toTime = value;
    }

    public Message withToTime(Date value) {
        this.setToTime(value);
        return this;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int value) {
        this.direction = value;
    }

    public Message withDirection(int value) {
        this.setDirection(value);
        return this;
    }

    public boolean isIncoming() {
        return this.direction == 1;
    }

    public boolean isRead() {
        return this.toTime != null && this.direction == 1;
    }

    public boolean isUnread() {
        return this.toTime == null && this.direction == 1;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Message withFrom(String from) {
        this.setFrom(from);
        return this;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String value) {
        this.to = value;
    }

    public Message withTo(String value) {
        this.setTo(value);
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String value) {
        this.subject = value;
    }

    public Message withSubject(String value) {
        this.setSubject(value);
        return this;
    }

    public List<FileData> getAttachList() {
        return this.attaches;
    }

    public void addAttach(FileData messageAttach) {
        this.attaches.add(messageAttach);
    }

    public String getLockEdit() {
        return "message_edit_" + this.id;
    }
}

