/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.dist.inst;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.bgerp.util.Log;

public class Module {
    private static final Log log = Log.getLog();
    private static final String SUPPORTED_MODULE_VERSION = "1.0";
    private boolean errors = false;
    private String moduleVersion;
    private String inf;
    private String name;
    private List<String[]> calls = new ArrayList<String[]>();

    public Module(String moduleInf) {
        this.inf = moduleInf;
        this.parseInf();
        if (this.errors) {
            log.error("Not all params were found in module.properties", new Object[0]);
        }
    }

    private void parseInf() {
        StringTokenizer st = new StringTokenizer(this.inf, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            StringTokenizer pair = new StringTokenizer(line, "=");
            if (pair.countTokens() != 2) continue;
            String key = pair.nextToken();
            String value = pair.nextToken();
            if (key.equals("name")) {
                this.name = value;
                continue;
            }
            if (key.equals("call")) {
                String[] class_param = value.split(";");
                if (class_param.length != 2) continue;
                this.calls.add(class_param);
                continue;
            }
            if (!key.equals("module.version")) continue;
            if (!value.equals(SUPPORTED_MODULE_VERSION)) {
                log.error("Modules version {} are not supported.", value);
                this.errors = true;
                continue;
            }
            this.moduleVersion = value;
        }
        this.errors = this.name == null || this.moduleVersion == null;
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public String getName() {
        return this.name;
    }

    public List<String[]> getCalls() {
        return this.calls;
    }
}

