/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process.queue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bgerp.util.Log;
import ru.bgcrm.model.process.queue.SortMode;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class SortSet {
    private static final Log log = Log.getLog();
    private int comboCount;
    private final List<SortMode> modeList = new ArrayList<SortMode>();
    private final Map<Integer, Integer> defaultSortValues = new HashMap<Integer, Integer>();
    private final SortedMap<Integer, Integer> sortValues = new TreeMap<Integer, Integer>();

    public int getComboCount() {
        return this.comboCount;
    }

    public void setComboCount(int comboCount) {
        this.comboCount = comboCount;
    }

    public List<SortMode> getModeList() {
        return this.modeList;
    }

    public void addMode(SortMode mode) {
        this.modeList.add(mode);
    }

    public SortedMap<Integer, Integer> getSortValues() {
        return this.sortValues;
    }

    public void setSortValue(int comboNum, int value) {
        this.sortValues.put(comboNum, value);
    }

    public Map<Integer, Integer> getDefaultSortValues() {
        return this.defaultSortValues;
    }

    public void setDefaultSortValue(int comboNum, int value) {
        this.defaultSortValues.put(comboNum, value);
    }

    public String getOrders(DynActionForm form) {
        String orders = this.getOrders(this.sortValues);
        if (Utils.isBlankString(orders) && form != null) {
            orders = Utils.toString(form.getParamValuesListStr("sort", "0"));
        }
        if (Utils.isBlankString(orders)) {
            orders = this.getOrders(this.defaultSortValues);
        }
        return orders;
    }

    private String getOrders(Map<Integer, Integer> sortValues) {
        StringBuilder result = new StringBuilder("");
        for (Integer value : sortValues.values()) {
            int pos = value - 1;
            if (pos < 0 || pos >= this.modeList.size()) {
                log.error("Incorrect sort value in queue: " + value, new Object[0]);
                continue;
            }
            Utils.addCommaSeparated(result, this.modeList.get(pos).getOrderExpression());
        }
        return result.toString();
    }
}

