/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.model.process.ProcessGroups;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import ru.bgcrm.model.LastModify;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.model.process.TransactionProperties;
import ru.bgcrm.model.process.Wizard;
import ru.bgcrm.util.Utils;

public class TypeProperties {
    private static final Log log = Log.getLog();
    private int createStatusId;
    private Set<Integer> closeStatusIds;
    private List<Integer> statusIds = new ArrayList<Integer>();
    private List<Integer> parameterIds = new ArrayList<Integer>();
    private String config = "";
    private ConfigMap configMap;
    private ProcessGroups groups = new ProcessGroups();
    private ProcessGroups allowedGroups = new ProcessGroups();
    private LastModify lastModify = new LastModify();
    private Map<TransactionProperties.TransactionKey, TransactionProperties> transactionPropertiesMap = new HashMap<TransactionProperties.TransactionKey, TransactionProperties>();
    private Wizard wizard;

    public TypeProperties() {
    }

    public TypeProperties(String data, String config, LastModify lastModify) {
        this.transactionPropertiesMap.clear();
        this.lastModify = lastModify;
        Preferences configMap = new Preferences(data);
        for (String key : configMap.subKeyed("transaction.").keySet()) {
            TransactionProperties properties = new TransactionProperties(configMap, "transaction." + key + ".");
            this.transactionPropertiesMap.put(new TransactionProperties.TransactionKey(key), properties);
        }
        this.createStatusId = configMap.getInt("create.status", 0);
        this.closeStatusIds = Utils.toIntegerSet(configMap.get("close.status", ""));
        this.statusIds = Utils.toIntegerList(configMap.get("status.ids", ""));
        this.parameterIds = Utils.toIntegerList(configMap.get("param.ids", ""));
        this.allowedGroups = ProcessGroups.of(Utils.parseIdTitleList(configMap.get("allowed.groups"), "0"));
        this.groups = ProcessGroups.of(Utils.parseIdTitleList(configMap.get("create.groups"), "0"));
        this.config = config;
        try {
            Wizard wizard = new Wizard(this);
            if (wizard.getCreateStepList().size() > 0 || wizard.getStepList().size() > 0) {
                this.wizard = wizard;
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    public String serializeToData() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<TransactionProperties.TransactionKey, TransactionProperties> me : this.transactionPropertiesMap.entrySet()) {
            TransactionProperties.TransactionKey key = me.getKey();
            TransactionProperties properties = me.getValue();
            String pref = "transaction." + key.fromStatus + "-" + key.toStatus + ".";
            properties.serializeToData(result, pref);
        }
        Utils.addSetupPair(result, "", "create.status", String.valueOf(this.createStatusId));
        Utils.addSetupPair(result, "", "close.status", Utils.toString(this.closeStatusIds));
        Utils.addSetupPair(result, "", "status.ids", Utils.toString(this.statusIds));
        Utils.addSetupPair(result, "", "param.ids", Utils.toString(this.parameterIds));
        Utils.addSetupPair(result, "", "create.groups", ProcessGroup.serialize(this.groups));
        Utils.addSetupPair(result, "", "allowed.groups", ProcessGroup.serialize(this.allowedGroups));
        return result.toString();
    }

    public TransactionProperties getTransactionProperties(int fromStatus, int toStatus) {
        TransactionProperties.TransactionKey key = new TransactionProperties.TransactionKey(fromStatus, toStatus);
        TransactionProperties result = this.transactionPropertiesMap.get(key);
        if (result == null) {
            return TransactionProperties.ENABLED;
        }
        return result;
    }

    public void setTransactionProperties(int fromStatus, int toStatus, boolean enabled) {
        TransactionProperties.TransactionKey key = new TransactionProperties.TransactionKey(fromStatus, toStatus);
        TransactionProperties props = this.transactionPropertiesMap.get(key);
        if (props == null) {
            props = new TransactionProperties(enabled);
        }
        props.setEnable(enabled);
        this.transactionPropertiesMap.put(key, props);
    }

    public void clearTransactionProperties() {
        this.transactionPropertiesMap.clear();
    }

    public Set<Integer> getAllowedStatusSet(int fromStatus) {
        boolean emptyMatrix;
        HashSet<Integer> result = new HashSet<Integer>();
        for (Map.Entry<TransactionProperties.TransactionKey, TransactionProperties> me : this.transactionPropertiesMap.entrySet()) {
            TransactionProperties.TransactionKey key = me.getKey();
            TransactionProperties props = me.getValue();
            if (key.fromStatus != fromStatus || !props.isEnable() || !this.statusIds.contains(key.toStatus)) continue;
            result.add(key.toStatus);
        }
        if (result.isEmpty() && (emptyMatrix = this.transactionPropertiesMap.entrySet().stream().noneMatch(t -> this.statusIds.contains(((TransactionProperties.TransactionKey)t.getKey()).toStatus) && this.statusIds.contains(((TransactionProperties.TransactionKey)t.getKey()).fromStatus) && ((TransactionProperties)t.getValue()).isEnable()))) {
            result.addAll(this.statusIds);
            result.remove(fromStatus);
        }
        return result;
    }

    public List<Integer> getStatusIds() {
        return this.statusIds;
    }

    public void setStatusIds(List<Integer> statusIds) {
        this.statusIds = statusIds;
    }

    public List<Integer> getParameterIds() {
        return this.parameterIds;
    }

    public void setParameterIds(List<Integer> parameterIds) {
        this.parameterIds = parameterIds;
    }

    public int getCreateStatusId() {
        return this.createStatusId;
    }

    public void setCreateStatusId(int createStatus) {
        this.createStatusId = createStatus;
    }

    public Set<Integer> getCloseStatusIds() {
        return this.closeStatusIds;
    }

    public void setCloseStatusIds(Set<Integer> closeStatusIds) {
        this.closeStatusIds = closeStatusIds;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public ConfigMap getConfigMap() {
        if (this.configMap == null) {
            this.configMap = new Preferences(this.config);
        }
        return this.configMap;
    }

    public void setConfigMap(ConfigMap configMap) {
        this.configMap = configMap;
    }

    public ProcessGroups getGroups() {
        return this.groups;
    }

    public ProcessGroups getGroups(int roleId) {
        Set<ProcessGroup> processGroups = this.groups.stream().filter(pg -> pg.roleId == roleId).collect(Collectors.toSet());
        return new ProcessGroups(processGroups);
    }

    public void setGroups(ProcessGroups groups) {
        this.groups = groups;
    }

    @Dynamic
    public ProcessGroups getAllowedGroups() {
        return this.allowedGroups;
    }

    @Dynamic
    public ProcessGroups getAllowedGroups(int roleId) {
        Set<ProcessGroup> processGroups = this.allowedGroups.stream().filter(pg -> pg.roleId == roleId).collect(Collectors.toSet());
        return new ProcessGroups(processGroups);
    }

    public void setAllowedGroups(ProcessGroups allowedGroups) {
        this.allowedGroups = allowedGroups;
    }

    public LastModify getLastModify() {
        return this.lastModify;
    }

    public void setLastModify(LastModify lastModify) {
        this.lastModify = lastModify;
    }

    public Wizard getWizard() {
        return this.wizard;
    }
}

