/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.dao.process;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bgerp.model.Pageable;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.process.Status;
import ru.bgcrm.util.Utils;

public class StatusDAO
extends CommonDAO {
    public StatusDAO(Connection con) {
        super(con);
    }

    public void searchStatus(Pageable<Status> searchResult) throws SQLException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<Status> list = searchResult.getList();
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT SQL_CALC_FOUND_ROWS ");
            query.append("*");
            query.append(" FROM ");
            query.append(" process_status_title ");
            query.append(" ORDER BY ");
            query.append("pos, title");
            query.append(page.getLimitSql());
            ps = this.con.prepareStatement(query.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(StatusDAO.getStatusFromRs(rs));
            }
            page.setRecordCount(ps);
            ps.close();
        }
    }

    public Status getStatus(int id) throws SQLException {
        Status result = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        ps = this.con.prepareStatement("SELECT * FROM  process_status_title  WHERE id=?");
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            result = StatusDAO.getStatusFromRs(rs);
        }
        ps.close();
        return result;
    }

    public void deleteStatus(int id) throws SQLException {
        PreparedStatement ps = null;
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM ");
        query.append(" process_status_title ");
        query.append(" WHERE ");
        query.append("id=?");
        ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    public void updateStatus(Status status) throws SQLException {
        int index = 1;
        PreparedStatement ps = null;
        if (status.getId() < 0) {
            ps = this.con.prepareStatement("INSERT INTO  process_status_title  SET title=?, pos=?", 1);
            ps.setString(index++, status.getTitle());
            ps.setInt(index++, status.getPos());
            ps.executeUpdate();
            status.setId(this.lastInsertId(ps));
        } else {
            ps = this.con.prepareStatement("UPDATE  process_status_title  SET title=?, pos=? WHERE id=?");
            ps.setString(index++, status.getTitle());
            ps.setInt(index++, status.getPos());
            ps.setInt(index++, status.getId());
            ps.executeUpdate();
        }
        ps.close();
    }

    public List<Status> getStatusList() throws SQLException {
        ArrayList<Status> result = new ArrayList<Status>();
        ResultSet rs = null;
        PreparedStatement ps = null;
        ps = this.con.prepareStatement("SELECT * FROM  process_status_title  ORDER BY pos ");
        rs = ps.executeQuery();
        while (rs.next()) {
            result.add(StatusDAO.getStatusFromRs(rs));
        }
        ps.close();
        return result;
    }

    public List<Status> getStatusList(Set<Integer> ids) throws SQLException {
        ArrayList<Status> result = new ArrayList<Status>();
        ResultSet rs = null;
        PreparedStatement ps = null;
        StringBuilder query = new StringBuilder("SELECT * FROM  process_status_title ");
        if (ids.size() > 0) {
            query.append(" WHERE id IN(");
            query.append(Utils.toString(ids));
            query.append(") ");
        }
        query.append(" ORDER BY pos");
        ps = this.con.prepareStatement(query.toString());
        rs = ps.executeQuery();
        while (rs.next()) {
            result.add(StatusDAO.getStatusFromRs(rs));
        }
        ps.close();
        return result;
    }

    public static Status getStatusFromRs(ResultSet rs) throws SQLException {
        Status result = new Status();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setPos(rs.getInt("pos"));
        return result;
    }
}

