/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.blow.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bgerp.cache.UserCache;
import org.bgerp.model.base.IdTitle;
import org.bgerp.plugin.pln.blow.model.BoardConfig;
import org.bgerp.plugin.pln.blow.model.Item;
import org.bgerp.util.Log;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.user.User;

public class Board {
    private static final Log log = Log.getLog();
    private boolean userMode = true;
    private final Item root = new Item(this, null);
    private final BoardConfig config;
    private final Map<Integer, List<Item>> queues = new HashMap<Integer, List<Item>>();
    private final Iterable<Item> items;
    private final int lastIndex;

    public boolean isUserMode() {
        return this.userMode;
    }

    public Board(BoardConfig config, List<Pair<Process, Map<String, Object>>> processes, Collection<CommonObjectLink> links) {
        log.debug("## Build board, processes: {}; links: {}", processes.size(), links.size());
        this.config = config;
        this.items = this.buildTree(processes, links);
        this.lastIndex = this.addItem(this.root, -1, -1);
    }

    private Iterable<Item> buildTree(List<Pair<Process, Map<String, Object>>> processes, Collection<CommonObjectLink> links) {
        List<Item> itemList = processes.stream().map(p -> new Item(this, (Pair<Process, Map<String, Object>>)p)).collect(Collectors.toList());
        Map itemMap = itemList.stream().collect(Collectors.toMap(item -> item.getProcess().getId(), Function.identity()));
        for (Item item2 : itemList) {
            Item parent = this.root;
            for (CommonObjectLink link : links) {
                if (item2.getProcess().getId().intValue() != link.getLinkObjectId() || !link.getLinkObjectType().equals("processMade")) continue;
                parent = (Item)itemMap.get(link.getObjectId());
                break;
            }
            parent.addChild(item2);
        }
        return itemList;
    }

    public BoardConfig getConfig() {
        return this.config;
    }

    public Item getRoot() {
        return this.root;
    }

    public Iterable<Item> getItems() {
        return this.items;
    }

    private int addItem(Item item, int lastIndex, int maxLastIndex) {
        if (item.getProcess() != null) {
            List queueCommon = this.queues.computeIfAbsent(0, id -> new ArrayList());
            List queue = this.queues.computeIfAbsent(item.getExecutorId(), id -> new ArrayList());
            log.debug("Adding: {}; lastIndex: {}; maxLastIndex: {}; executorId: {}; queueSize: {}; queueCommonSize: {}", item.getProcess().getId(), lastIndex, maxLastIndex, item.getExecutorId(), queue.size(), queueCommon.size());
            if (item.getExecutorId() == 0) {
                lastIndex = maxLastIndex + 1;
                while (queue.size() < lastIndex) {
                    queue.add(null);
                }
                queue.add(item);
            } else {
                while (queue.size() <= lastIndex || queue.size() < queueCommon.size()) {
                    queue.add(null);
                }
                queue.add(item);
                lastIndex = queue.size() - 1;
            }
            log.debug("Added: {}; lastIndex: {}", item.getProcess().getId(), lastIndex);
        }
        if (maxLastIndex < lastIndex) {
            maxLastIndex = lastIndex;
            log.debug("maxLastIndex: {}", maxLastIndex);
        }
        for (Item child : item.getChildren()) {
            maxLastIndex = this.addItem(child, lastIndex, maxLastIndex);
        }
        return maxLastIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public Map<Integer, List<Item>> getQueues() {
        return this.queues;
    }

    public int getExecutorItemCount(int executorId) {
        int cnt = 0;
        for (Item item : this.items) {
            if (!item.hasExecutor(executorId)) continue;
            ++cnt;
        }
        return cnt;
    }

    public List<IdTitle> getExecutors() {
        ArrayList<IdTitle> executorColumns = new ArrayList<IdTitle>(this.queues.size());
        if (this.isUserMode()) {
            for (User user : UserCache.getUserList()) {
                if (!this.queues.containsKey(user.getId())) continue;
                executorColumns.add(user);
            }
        }
        return executorColumns;
    }
}

