/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.message.process;

import java.util.List;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.dao.message.process.MessagePossibleProcessSearch;
import org.bgerp.model.process.link.ProcessLink;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.model.user.User;
import ru.bgcrm.util.Utils;

@Bean
public class MessagePossibleProcessSearchFoundLinksCustomerAddressCity
extends MessagePossibleProcessSearch {
    private final int processCityParamId;

    public MessagePossibleProcessSearchFoundLinksCustomerAddressCity(int id, ConfigMap configMap) {
        super(id, configMap);
        this.processCityParamId = configMap.getInt("processCityParamId");
    }

    @Override
    public boolean addQuery(User user, PreparedQuery pq, boolean first, String from, List<ProcessLink> links, Boolean open) {
        String customerIds = links.stream().filter(link -> link.getLinkObjectType().startsWith("customer")).map(link -> String.valueOf(link.getLinkObjectId())).collect(Collectors.joining(","));
        if (Utils.isBlankString(customerIds)) {
            return false;
        }
        if (!first) {
            pq.addQuery(" UNION ALL ");
        }
        pq.addQuery("SELECT p.*, ? AS type FROM  process AS p");
        pq.addInt(this.getId());
        pq.addQuery(" INNER JOIN  param_list AS pcity ON p.id=pcity.id AND pcity.param_id=?");
        pq.addInt(this.processCityParamId);
        pq.addQuery(" INNER JOIN  param_address AS caddr ON caddr.id IN (" + customerIds + ")");
        pq.addQuery(" INNER JOIN  address_house AS chouse ON caddr.house_id=chouse.id");
        pq.addQuery(" INNER JOIN  address_street AS cstreet ON chouse.street_id=cstreet.id AND cstreet.city_id=pcity.value");
        this.addOpenFilter(pq, open);
        return true;
    }
}

