/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.cfg;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.SimpleConfigMap;
import org.bgerp.app.cfg.bean.Bean;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

public abstract class ConfigMap
extends AbstractMap<String, String> {
    private static final Log log = Log.getLog();
    public static ConfigMap EMPTY = new SimpleConfigMap(Collections.emptyMap());
    private static final Pattern PATTERN_DOT = Pattern.compile("\\.");
    private static final Class<?>[] CONFIG_CONSTR_ARGS_WITH_VALIDATION = new Class[]{ConfigMap.class, Boolean.TYPE};
    private static final Class<?>[] CONFIG_CONSTR_ARGS = new Class[]{ConfigMap.class};
    private volatile ConcurrentHashMap<Class<?>, Config> configMap;

    public abstract String get(String var1, String var2);

    @Override
    public abstract Set<Map.Entry<String, String>> entrySet();

    @Override
    public String get(Object key) {
        return this.get((String)key, null);
    }

    public String getSok(String def, boolean validate, String ... keys) throws BGMessageException {
        String value = this.get(keys[0]);
        if (!Utils.isEmptyString(value)) {
            return value;
        }
        for (int i = 1; i < keys.length; ++i) {
            value = this.get(keys[i]);
            if (Utils.isEmptyString(value)) continue;
            String message = Log.format("Used deprecated config key '{}', the actual one is '{}'", keys[i], keys[0]);
            if (validate) {
                throw new BGMessageException(message, new Object[0]);
            }
            log.warnd(message, new Object[0]);
            return value;
        }
        return def;
    }

    public String getSok(String ... keys) {
        try {
            return this.getSok(null, false, keys);
        }
        catch (BGMessageException e) {
            throw new IllegalStateException("BGMessageException must not appear here");
        }
    }

    public int getInt(String key, int def) {
        try {
            String value = this.get(key, null);
            if (Utils.isEmptyString(value)) {
                return def;
            }
            return Integer.parseInt(value.trim());
        }
        catch (Exception ex) {
            return def;
        }
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public long getLong(String key, long def) {
        try {
            String value = this.get(key, null);
            if (Utils.isEmptyString(value)) {
                return def;
            }
            return Long.parseLong(value.trim());
        }
        catch (Exception ex) {
            return def;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getSokLong(long def, boolean validate, String ... keys) throws BGMessageException {
        return Utils.parseLong(this.getSok(String.valueOf(def), validate, keys), def);
    }

    public long getSokLong(long def, String ... keys) {
        try {
            return this.getSokLong(def, false, keys);
        }
        catch (BGMessageException e) {
            throw new IllegalStateException("BGMessageException must not appear here");
        }
    }

    public final boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public final boolean getBoolean(String key, boolean defaultValue) {
        return Utils.parseBoolean(this.get(key, "").trim(), defaultValue);
    }

    public boolean getSokBoolean(boolean def, boolean validate, String ... keys) throws BGMessageException {
        return Utils.parseBoolean(this.getSok(String.valueOf(def), validate, keys), def);
    }

    public boolean getSokBoolean(boolean def, String ... keys) {
        try {
            return this.getSokBoolean(def, false, keys);
        }
        catch (BGMessageException e) {
            throw new IllegalStateException("BGMessageException must not appear here");
        }
    }

    public BigDecimal getBigDecimal(String key, BigDecimal def) {
        try {
            String value = this.get(key, null);
            if (Utils.isEmptyString(value)) {
                return def;
            }
            return new BigDecimal(value.trim());
        }
        catch (Exception ex) {
            return def;
        }
    }

    public ConfigMap sub(String prefix) {
        return this.subSok(prefix);
    }

    public ConfigMap subSok(String ... prefixes) {
        HashMap<String, String> result = new HashMap<String, String>();
        String deprecatedPrefix = null;
        block0: for (Map.Entry<String, String> e : this.entrySet()) {
            String key = e.getKey();
            for (int i = 0; i < prefixes.length; ++i) {
                String prefix = prefixes[i];
                if (!key.startsWith(prefix)) continue;
                result.put(key.substring(prefix.length(), key.length()), e.getValue());
                if (i <= 0) continue block0;
                deprecatedPrefix = prefix;
                continue block0;
            }
        }
        if (deprecatedPrefix != null) {
            log.warnd("Used deprecated config prefix key '{}', the actual one is '{}'", deprecatedPrefix, prefixes[0]);
        }
        return new SimpleConfigMap(result);
    }

    public SortedMap<Integer, ConfigMap> subIndexed(String prefix) {
        return this.subSokIndexed(prefix);
    }

    public SortedMap<Integer, ConfigMap> subSokIndexed(String ... prefixes) {
        TreeMap<Integer, ConfigMap> result = new TreeMap<Integer, ConfigMap>();
        String deprecatedPrefix = null;
        block2: for (Map.Entry<String, String> e : this.entrySet()) {
            String key = e.getKey();
            for (int i = 0; i < prefixes.length; ++i) {
                String prefix = prefixes[i];
                if (!key.startsWith(prefix)) continue;
                String suffix = key.substring(prefix.length(), key.length());
                String[] pref = PATTERN_DOT.split(suffix, 2);
                int id = 0;
                try {
                    id = Integer.parseInt(pref[0]);
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                ConfigMap map = result.computeIfAbsent(id, unused -> new SimpleConfigMap(new HashMap<String, String>()));
                if (pref.length == 2) {
                    map.put(pref[1], e.getValue());
                } else {
                    map.put("", e.getValue());
                }
                if (i <= 0) continue block2;
                deprecatedPrefix = prefix;
                continue block2;
            }
        }
        if (deprecatedPrefix != null) {
            log.warnd("Used deprecated config prefix key '{}', the actual one is '{}'", deprecatedPrefix, prefixes[0]);
        }
        return result;
    }

    public Map<String, ConfigMap> subKeyed(String prefix) {
        HashMap<String, ConfigMap> result = new HashMap<String, ConfigMap>();
        HashMap<String, HashMap<String, String>> resultMap = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry<String, String> e : this.entrySet()) {
            String key = e.getKey();
            if (!key.startsWith(prefix)) continue;
            String suffix = key.substring(prefix.length(), key.length());
            String[] pref = PATTERN_DOT.split(suffix, 2);
            HashMap<String, String> map = (HashMap<String, String>)resultMap.get(pref[0]);
            if (map == null) {
                map = new HashMap<String, String>();
                resultMap.put(pref[0], map);
                result.put(pref[0], new SimpleConfigMap(map));
            }
            if (pref.length == 2) {
                map.put(pref[1], e.getValue());
                continue;
            }
            map.put("", e.getValue());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <K extends Config> K getConfig(Class<K> clazz) {
        ConfigMap configMap = this;
        synchronized (configMap) {
            if (this.configMap == null) {
                this.configMap = new ConcurrentHashMap();
            }
        }
        Config result = this.configMap.get(clazz);
        if (result == null) {
            try {
                result = this.createConfig(clazz, false);
                if (result == null) {
                    result = Config.EMPTY;
                }
                this.configMap.put(clazz, result);
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        log.trace("getConfig {} => {}", clazz, result);
        return (K)(result == Config.EMPTY ? null : result);
    }

    @Dynamic
    public final Object getConfig(String className) {
        try {
            return this.getConfig(Bean.getClass(className));
        }
        catch (Exception e) {
            log.error(e);
            return null;
        }
    }

    public <K extends Config> void removeConfig(Class<K> clazz) {
        this.configMap.remove(clazz);
    }

    protected void clearConfigs() {
        this.configMap = null;
    }

    public final <K extends Config> void validateConfig(Class<K> clazz) throws BGMessageException {
        try {
            this.createConfig(clazz, true);
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e);
            throw new BGMessageException(e.getMessage(), new Object[0]);
        }
    }

    private <K extends Config> K createConfig(Class<K> clazz, boolean validate) throws Exception {
        try {
            Constructor<K> constr2;
            try {
                constr2 = clazz.getDeclaredConstructor(CONFIG_CONSTR_ARGS_WITH_VALIDATION);
                if (constr2 != null) {
                    constr2.setAccessible(true);
                    return (K)((Config)constr2.newInstance(this, validate));
                }
            }
            catch (NoSuchMethodException constr2) {
                // empty catch block
            }
            constr2 = clazz.getDeclaredConstructor(CONFIG_CONSTR_ARGS);
            if (constr2 != null) {
                constr2.setAccessible(true);
                return (K)((Config)constr2.newInstance(this));
            }
        }
        catch (InvocationTargetException e) {
            Exception target = (Exception)e.getTargetException();
            if (target instanceof Config.InitStopException) {
                return null;
            }
            if (!validate && target instanceof BGMessageException) {
                return null;
            }
            throw target;
        }
        return null;
    }

    public String getDataString() {
        return this.getDataString("");
    }

    private String getDataString(String prefix) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> e : this.entrySet()) {
            result.append(prefix);
            result.append(e.getKey());
            result.append("=");
            result.append(e.getValue());
            result.append("\n");
        }
        return result.toString();
    }
}

