/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.subscription.action.open;

import java.math.BigDecimal;
import java.util.Set;
import javassist.NotFoundException;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.ProcessQueueCache;
import org.bgerp.plugin.bil.subscription.Config;
import org.bgerp.plugin.bil.subscription.dao.SubscriptionDAO;
import org.bgerp.plugin.bil.subscription.model.Subscription;
import ru.bgcrm.model.process.queue.Processor;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/open/plugin/subscription/subscription")
public class SubscriptionAction
extends BaseAction {
    private static final String JSP_PATH = "/WEB-INF/jspf/open/plugin/subscription";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        int queueId = form.getParamInt("queueId");
        Queue queue = ProcessQueueCache.getQueue(queueId);
        if (queue == null) {
            throw new NotFoundException("Not found process queue with ID=" + queueId);
        }
        String uri = form.getRequestURI();
        Processor processor = queue.getProcessorByPageUrl(uri);
        if (processor == null) {
            throw new NotFoundException("Not found processor for page URL: " + uri);
        }
        Config config = this.setup.getConfig(Config.class);
        int subscriptionId = processor.getConfigMap().getInt("subscription.value");
        if (subscriptionId > 0) {
            form.setRequestAttribute("subscriptionId", subscriptionId);
        } else {
            form.setRequestAttribute("subscriptions", config.getSubscriptions());
        }
        if (config.getParamLimitId() > 0) {
            form.setRequestAttribute("limits", ParameterCache.getListParamValues(config.getParamLimitId()));
        }
        return this.html(conSet, form, "/WEB-INF/jspf/open/plugin/subscription/subscription.jsp");
    }

    public ActionForward calc(DynActionForm form, ConnectionSet conSet) throws Exception {
        Subscription subscription = this.setup.getConfig(Config.class).getSubscriptionOrThrow(form.getParamInt("subscriptionId"));
        int limitId = form.getParamInt("limitId");
        Set<Integer> processIds = Utils.toIntegerSet(form.getParam("processIds"));
        BigDecimal cost = new SubscriptionDAO(conSet.getSlaveConnection()).getCost(subscription, limitId, processIds);
        form.setResponseData("cost", cost);
        return this.html(conSet, form, "/WEB-INF/jspf/open/plugin/subscription/subscription_calc.jsp");
    }
}

