/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bgb.getolt.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.bgerp.plugin.bgb.getolt.dao.LocalDateTimeDeserializer;
import org.bgerp.plugin.bgb.getolt.dao.StringOrListDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OnuData {
    private static final DateTimeFormatter DISPLAY_FORMAT = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
    @JsonProperty(value="mac")
    private String mac;
    @JsonProperty(value="oltIp")
    @JsonAlias(value={"olt_ip", "olt"})
    private String oltIp;
    @JsonProperty(value="oltId")
    @JsonAlias(value={"olt_id"})
    private Integer oltId;
    @JsonProperty(value="portNumber")
    @JsonAlias(value={"port", "port_number"})
    private int port;
    @JsonProperty(value="onuId")
    @JsonAlias(value={"onu_id", "id"})
    private int onuId;
    @JsonProperty(value="status")
    private String status;
    @JsonIgnore
    private boolean online;
    private Double rxSignal;
    @JsonIgnore
    private String rxQuality;
    private Double txSignal;
    @JsonIgnore
    private String txQuality;
    @JsonProperty(value="distance")
    private Integer distance;
    @JsonProperty(value="temperature")
    @JsonAlias(value={"temp"})
    private Double temperature;
    @JsonProperty(value="voltage")
    private Double voltage;
    @JsonProperty(value="macsBehind")
    @JsonAlias(value={"macs_behind", "macBehind"})
    @JsonDeserialize(using=StringOrListDeserializer.class)
    private List<String> macsBehind;
    @JsonProperty(value="neighbors")
    private List<PortNeighbor> neighbors;
    @JsonProperty(value="contractNumber")
    @JsonAlias(value={"contract_number", "contract"})
    private String contractNumber;
    @JsonProperty(value="cid")
    private Integer cid;
    @JsonProperty(value="operator")
    private String operator;
    @JsonProperty(value="lastUpdate")
    @JsonAlias(value={"last_update"})
    @JsonDeserialize(using=LocalDateTimeDeserializer.class)
    private LocalDateTime lastUpdate;

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getOltIp() {
        return this.oltIp;
    }

    public void setOltIp(String oltIp) {
        this.oltIp = oltIp;
    }

    public Integer getOltId() {
        return this.oltId;
    }

    public void setOltId(Integer oltId) {
        this.oltId = oltId;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getOnuId() {
        return this.onuId;
    }

    public void setOnuId(int onuId) {
        this.onuId = onuId;
    }

    public String getStatus() {
        return this.status;
    }

    @JsonSetter(value="status")
    public void setStatus(String status) {
        this.status = status;
        this.online = "online".equalsIgnoreCase(status) || "up".equalsIgnoreCase(status);
    }

    public boolean isOnline() {
        return this.online;
    }

    public Double getRxSignal() {
        return this.rxSignal;
    }

    @JsonSetter(value="rxOptical")
    @JsonAlias(value={"rxSignal", "rx_signal", "rx"})
    public void setRxSignal(Double rxSignal) {
        this.rxSignal = rxSignal;
        this.rxQuality = this.calculateSignalQuality(rxSignal, true);
    }

    public Double getTxSignal() {
        return this.txSignal;
    }

    @JsonSetter(value="txOptical")
    @JsonAlias(value={"txSignal", "tx_signal", "tx"})
    public void setTxSignal(Double txSignal) {
        this.txSignal = txSignal;
        this.txQuality = this.calculateSignalQuality(txSignal, false);
    }

    public String getRxQuality() {
        return this.rxQuality;
    }

    public String getTxQuality() {
        return this.txQuality;
    }

    public Integer getDistance() {
        return this.distance;
    }

    public void setDistance(Integer distance) {
        this.distance = distance;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getVoltage() {
        return this.voltage;
    }

    public void setVoltage(Double voltage) {
        this.voltage = voltage;
    }

    public List<String> getMacsBehind() {
        return this.macsBehind;
    }

    public void setMacsBehind(List<String> macsBehind) {
        this.macsBehind = macsBehind;
    }

    public List<PortNeighbor> getNeighbors() {
        return this.neighbors;
    }

    public void setNeighbors(List<PortNeighbor> neighbors) {
        this.neighbors = neighbors;
    }

    public String getContractNumber() {
        return this.contractNumber;
    }

    public void setContractNumber(String contractNumber) {
        this.contractNumber = contractNumber;
    }

    public Integer getCid() {
        return this.cid;
    }

    public void setCid(Integer cid) {
        this.cid = cid;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(LocalDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getLastUpdateFormatted() {
        if (this.lastUpdate == null) {
            return null;
        }
        return this.lastUpdate.format(DISPLAY_FORMAT);
    }

    public String getLastUpdateAgo() {
        if (this.lastUpdate == null) {
            return null;
        }
        Duration duration = Duration.between(this.lastUpdate, LocalDateTime.now());
        long seconds = duration.getSeconds();
        if (seconds < 60L) {
            return seconds + " \u0441\u0435\u043a. \u043d\u0430\u0437\u0430\u0434";
        }
        if (seconds < 3600L) {
            long minutes = seconds / 60L;
            return minutes + " \u043c\u0438\u043d. \u043d\u0430\u0437\u0430\u0434";
        }
        if (seconds < 86400L) {
            long hours = seconds / 3600L;
            return hours + " \u0447. \u043d\u0430\u0437\u0430\u0434";
        }
        long days = seconds / 86400L;
        return days + " \u0434\u043d. \u043d\u0430\u0437\u0430\u0434";
    }

    private String calculateSignalQuality(Double signal, boolean isRx) {
        if (signal == null) {
            return null;
        }
        if (isRx) {
            if (signal > -15.0) {
                return "overexposed";
            }
            if (signal >= -25.0) {
                return "good";
            }
            if (signal >= -27.0) {
                return "medium";
            }
            return "poor";
        }
        if (signal > 5.0) {
            return "overexposed";
        }
        if (signal >= 0.5) {
            return "good";
        }
        if (signal >= -1.0) {
            return "medium";
        }
        return "poor";
    }

    public static String getQualityClass(String quality) {
        if (quality == null) {
            return "";
        }
        switch (quality) {
            case "good": {
                return "signal-good";
            }
            case "medium": {
                return "signal-medium";
            }
            case "poor": {
                return "signal-poor";
            }
            case "overexposed": {
                return "signal-overexposed";
            }
        }
        return "";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PortNeighbor {
        @JsonProperty(value="mac")
        private String mac;
        @JsonProperty(value="onuId")
        @JsonAlias(value={"onu_id", "id"})
        private int onuId;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="contractNumber")
        @JsonAlias(value={"contract_number", "contract"})
        private String contractNumber;
        private Double rxOptical;
        @JsonIgnore
        private String signalQuality;
        @JsonProperty(value="lastUpdate")
        @JsonAlias(value={"last_update"})
        @JsonDeserialize(using=LocalDateTimeDeserializer.class)
        private LocalDateTime lastUpdate;

        public String getMac() {
            return this.mac;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }

        public int getOnuId() {
            return this.onuId;
        }

        public void setOnuId(int onuId) {
            this.onuId = onuId;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getContractNumber() {
            return this.contractNumber;
        }

        public void setContractNumber(String contractNumber) {
            this.contractNumber = contractNumber;
        }

        public Double getRxOptical() {
            return this.rxOptical;
        }

        @JsonSetter(value="rxOptical")
        @JsonAlias(value={"rxSignal", "rx"})
        public void setRxOptical(Double rxOptical) {
            this.rxOptical = rxOptical;
            if (rxOptical != null) {
                this.signalQuality = rxOptical > -15.0 ? "overexposed" : (rxOptical >= -25.0 ? "good" : (rxOptical >= -27.0 ? "medium" : "poor"));
            }
        }

        public String getSignalQuality() {
            return this.signalQuality;
        }

        public String getRowClass() {
            if (this.signalQuality == null) {
                return "";
            }
            switch (this.signalQuality) {
                case "poor": {
                    return "signal-row-poor";
                }
                case "medium": {
                    return "signal-row-medium";
                }
                case "overexposed": {
                    return "signal-row-overexposed";
                }
            }
            return "";
        }

        public LocalDateTime getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(LocalDateTime lastUpdate) {
            this.lastUpdate = lastUpdate;
        }

        public String getLastUpdateFormatted() {
            if (this.lastUpdate == null) {
                return null;
            }
            return this.lastUpdate.format(DISPLAY_FORMAT);
        }

        public String getLastUpdateAgo() {
            if (this.lastUpdate == null) {
                return null;
            }
            Duration duration = Duration.between(this.lastUpdate, LocalDateTime.now());
            long seconds = duration.getSeconds();
            if (seconds < 60L) {
                return seconds + " \u0441\u0435\u043a. \u043d\u0430\u0437\u0430\u0434";
            }
            if (seconds < 3600L) {
                long minutes = seconds / 60L;
                return minutes + " \u043c\u0438\u043d. \u043d\u0430\u0437\u0430\u0434";
            }
            if (seconds < 86400L) {
                long hours = seconds / 3600L;
                return hours + " \u0447. \u043d\u0430\u0437\u0430\u0434";
            }
            long days = seconds / 86400L;
            return days + " \u0434\u043d. \u043d\u0430\u0437\u0430\u0434";
        }
    }
}

