/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bgb.getolt.dao;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.bgerp.plugin.bgb.getolt.model.BillingConfig;
import org.bgerp.plugin.bgb.getolt.model.InetService;
import org.bgerp.plugin.bgb.getolt.model.MacUpdateResult;
import org.bgerp.plugin.bgb.getolt.model.SessionDropResult;
import org.bgerp.util.Log;

public class InetMacApiClient {
    private static final Log log = Log.getLog();
    private final BillingConfig config;
    private final ObjectMapper objectMapper;

    public InetMacApiClient(BillingConfig config) {
        this.config = config;
        this.objectMapper = new ObjectMapper();
    }

    public List<InetService> getServicesByContractId(int contractId) {
        ArrayList<InetService> services = new ArrayList<InetService>();
        if (!this.config.isConfigured()) {
            log.warn("InetMac API is not configured", new Object[0]);
            return services;
        }
        try {
            ObjectNode request = this.objectMapper.createObjectNode();
            request.put("method", "getServicesByContractId");
            ObjectNode params = request.putObject("params");
            params.put("contractId", contractId);
            String responseBody = this.executeRequest(request);
            if (responseBody == null) {
                return services;
            }
            log.info("InetMac getServices response: {}", responseBody);
            JsonNode root = this.objectMapper.readTree(responseBody);
            String status = root.path("status").asText("");
            if ("error".equals(status)) {
                String errorMsg = root.path("message").asText("Unknown error");
                log.error("InetMac API error: {}", errorMsg);
                return services;
            }
            JsonNode dataNode = root.path("data").path("return");
            if (dataNode.isArray()) {
                for (JsonNode serviceNode : dataNode) {
                    InetService service = this.parseServiceNode(serviceNode);
                    if (service == null) continue;
                    services.add(service);
                }
            }
            log.info("InetMac: Found {} services for contractId={}", services.size(), contractId);
        }
        catch (Exception e) {
            log.error("InetMac getServicesByContractId error", e);
        }
        return services;
    }

    public MacUpdateResult updateMacByContractId(int contractId, String newMac) {
        if (!this.config.isConfigured()) {
            return MacUpdateResult.error("InetMac API \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            List<InetService> services = this.getServicesByContractId(contractId);
            if (services.isEmpty()) {
                return MacUpdateResult.noServices();
            }
            if (services.size() > 1) {
                return MacUpdateResult.multipleServices(services);
            }
            InetService service = services.get(0);
            return this.updateMacAddress(service.getServiceId(), newMac, service.getMac());
        }
        catch (Exception e) {
            log.error("InetMac updateMacByContractId error", e);
            return MacUpdateResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f MAC: " + e.getMessage());
        }
    }

    public MacUpdateResult updateMacAddress(int serviceId, String newMac) {
        return this.updateMacAddress(serviceId, newMac, null);
    }

    public MacUpdateResult updateMacAddress(int serviceId, String newMac, String oldMac) {
        if (!this.config.isConfigured()) {
            return MacUpdateResult.error("InetMac API \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            ObjectNode request = this.objectMapper.createObjectNode();
            request.put("method", "updateMacAddress");
            ObjectNode params = request.putObject("params");
            params.put("serviceId", serviceId);
            params.put("newMac", newMac);
            String responseBody = this.executeRequest(request);
            if (responseBody == null) {
                return MacUpdateResult.error("\u041d\u0435\u0442 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            }
            log.info("InetMac updateMacAddress response: {}", responseBody);
            JsonNode root = this.objectMapper.readTree(responseBody);
            String status = root.path("status").asText("");
            if ("error".equals(status)) {
                String errorMsg = root.path("message").asText("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
                log.error("InetMac updateMacAddress error: {}", errorMsg);
                return MacUpdateResult.error(errorMsg);
            }
            JsonNode returnNode = root.path("data").path("return");
            String innerStatus = returnNode.path("status").asText("");
            if ("error".equals(innerStatus)) {
                String errorMsg = returnNode.path("message").asText("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c MAC");
                log.error("InetMac updateMacAddress operation error: {}", errorMsg);
                return MacUpdateResult.error(errorMsg);
            }
            if ("ok".equals(status)) {
                log.info("InetMac: MAC updated for serviceId={}, old={}, new={}", serviceId, oldMac, newMac);
                return MacUpdateResult.success(serviceId, oldMac, newMac);
            }
            String message = root.path("message").asText("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c MAC");
            return MacUpdateResult.error(message);
        }
        catch (Exception e) {
            log.error("InetMac updateMacAddress error", e);
            return MacUpdateResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f MAC: " + e.getMessage());
        }
    }

    public SessionDropResult dropSession(int serviceId) {
        if (!this.config.isConfigured()) {
            return SessionDropResult.error("InetMac API \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            ObjectNode request = this.objectMapper.createObjectNode();
            request.put("method", "dropSession");
            ObjectNode params = request.putObject("params");
            params.put("serviceId", serviceId);
            String responseBody = this.executeRequest(request);
            if (responseBody == null) {
                return SessionDropResult.error("\u041d\u0435\u0442 \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            }
            log.info("InetMac dropSession response: {}", responseBody);
            JsonNode root = this.objectMapper.readTree(responseBody);
            String status = root.path("status").asText("");
            if ("error".equals(status)) {
                String errorMsg = root.path("message").asText("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
                log.error("InetMac dropSession error: {}", errorMsg);
                return SessionDropResult.error(errorMsg);
            }
            JsonNode dataNode = root.path("data");
            int dropped = dataNode.path("droppedSessions").asInt(dataNode.path("return").asInt(0));
            log.info("InetMac: Session dropped for serviceId={}, count={}", serviceId, dropped);
            return SessionDropResult.success(dropped);
        }
        catch (Exception e) {
            log.error("InetMac dropSession error", e);
            return SessionDropResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0431\u0440\u043e\u0441\u0430 \u0441\u0435\u0441\u0441\u0438\u0438: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String executeRequest(ObjectNode requestBody) {
        try {
            String url = this.config.getUrl();
            ObjectNode userNode = requestBody.putObject("user");
            userNode.put("user", this.config.getUser());
            userNode.put("pswd", this.config.getPassword());
            log.info("InetMac API request: POST {} method={}", url, requestBody.get("method"));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.config.getTimeout()).setSocketTimeout(this.config.getTimeout()).setConnectionRequestTimeout(this.config.getTimeout()).build();
            try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();){
                HttpPost request = new HttpPost(url);
                request.setHeader("Content-Type", "application/json");
                request.setHeader("Accept", "application/json");
                request.setEntity((HttpEntity)new StringEntity(requestBody.toString(), StandardCharsets.UTF_8));
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                log.info("InetMac API response: status={}, bodyLen={}", statusCode, responseBody.length());
                log.debug("InetMac API response body: {}", responseBody);
                if (statusCode >= 400) {
                    log.error("InetMac API error: status={}, body={}", statusCode, responseBody);
                    String string2 = null;
                    return string2;
                }
                String string = responseBody;
                return string;
            }
        }
        catch (SocketTimeoutException e) {
            log.error("InetMac API timeout: {}", e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.error("InetMac API error", e);
            return null;
        }
    }

    private InetService parseServiceNode(JsonNode node) {
        if (node == null || node.isNull()) {
            return null;
        }
        InetService service = new InetService();
        service.setServiceId(node.path("serviceId").asInt(node.path("id").asInt(0)));
        service.setLogin(node.path("login").asText(null));
        service.setMac(node.path("mac").asText(null));
        service.setTypeTitle(node.path("typeTitle").asText(null));
        service.setStatus(node.path("status").asInt(0));
        service.setStatusTitle(node.path("statusTitle").asText(null));
        service.setConnectionType(node.path("connectionType").asText(null));
        service.setComment(node.path("comment").asText(null));
        return service;
    }

    private String getStringField(JsonNode node, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            JsonNode fieldNode = node.get(fieldName);
            if (fieldNode == null || fieldNode.isNull()) continue;
            return fieldNode.asText();
        }
        return null;
    }
}

