/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bgb.getolt.dao;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.bgerp.plugin.bgb.getolt.Config;
import org.bgerp.plugin.bgb.getolt.model.OnuApiResponse;
import org.bgerp.plugin.bgb.getolt.model.OnuData;
import org.bgerp.plugin.bgb.getolt.model.OnuSearchResult;
import org.bgerp.plugin.bgb.getolt.model.RefreshResult;
import org.bgerp.plugin.bgb.getolt.model.RefreshStatus;
import org.bgerp.util.Log;

public class GetOltApiClient {
    private static final Log log = Log.getLog();
    private final Config config;
    private final ObjectMapper objectMapper;

    public GetOltApiClient(Config config) {
        this.config = config;
        this.objectMapper = GetOltApiClient.createObjectMapper();
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OnuSearchResult searchOnu(String operator, String contractNumber, Integer cid) {
        if (!this.config.isConfigured()) {
            log.warn("GetOLT plugin is not configured", new Object[0]);
            return OnuSearchResult.error("GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            StringBuilder urlBuilder = new StringBuilder(this.config.getApiUrl());
            if (!urlBuilder.toString().endsWith("/")) {
                urlBuilder.append("/");
            }
            urlBuilder.append("onus/erp-search?");
            urlBuilder.append("operator=").append(URLEncoder.encode(operator, StandardCharsets.UTF_8));
            if (contractNumber != null && !contractNumber.isEmpty()) {
                urlBuilder.append("&contractNumber=").append(URLEncoder.encode(contractNumber, StandardCharsets.UTF_8));
            }
            if (cid != null) {
                urlBuilder.append("&cid=").append(cid);
            }
            String url = urlBuilder.toString();
            log.info("GetOLT API request: {}", url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.config.getApiTimeout()).setSocketTimeout(this.config.getApiTimeout()).setConnectionRequestTimeout(this.config.getApiTimeout()).build();
            try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();){
                HttpGet request = new HttpGet(url);
                request.setHeader("X-API-Key", this.config.getApiKey());
                request.setHeader("Accept", "application/json");
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                log.info("GetOLT API response: status={}, bodyLen={}", statusCode, responseBody.length());
                if (statusCode == 404) {
                    OnuSearchResult result = OnuSearchResult.error("ONU \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + (contractNumber != null ? contractNumber : String.valueOf(cid)));
                    result.setContractNumber(contractNumber);
                    result.setCid(cid);
                    result.setOperator(operator);
                    OnuSearchResult onuSearchResult = result;
                    return onuSearchResult;
                }
                if (statusCode >= 400) {
                    log.error("GetOLT API error: status={}, body={}", statusCode, responseBody);
                    OnuSearchResult onuSearchResult = OnuSearchResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 GetOLT");
                    return onuSearchResult;
                }
                OnuSearchResult onuSearchResult = this.parseResponse(responseBody, operator, contractNumber, cid);
                return onuSearchResult;
            }
        }
        catch (SocketTimeoutException e) {
            log.error("GetOLT API timeout: {}", e.getMessage());
            return OnuSearchResult.error("\u0421\u0435\u0440\u0432\u0438\u0441 GetOLT \u043d\u0435 \u043e\u0442\u0432\u0435\u0447\u0430\u0435\u0442");
        }
        catch (Exception e) {
            log.error("GetOLT API error", e);
            return OnuSearchResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043e\u0442\u0432\u0435\u0442\u0430");
        }
    }

    private OnuSearchResult parseResponse(String responseBody, String operator, String contractNumber, Integer cid) {
        try {
            log.debug("Parsing GetOLT response: {}", responseBody.length() > 500 ? responseBody.substring(0, 500) + "..." : responseBody);
            JsonNode root = this.objectMapper.readTree(responseBody);
            List<OnuData> onus = new ArrayList();
            if (root.isArray()) {
                onus = (List)this.objectMapper.readValue(responseBody, (TypeReference)new TypeReference<List<OnuData>>(this){});
            } else if (root.isObject()) {
                OnuData onu;
                JsonNode dataNode = root.get("data");
                if (dataNode != null && dataNode.isObject()) {
                    OnuApiResponse.OnuApiData data;
                    OnuApiResponse apiResponse = (OnuApiResponse)this.objectMapper.readValue(responseBody, OnuApiResponse.class);
                    if (apiResponse.getData() != null && (data = apiResponse.getData()).getTarget() != null) {
                        OnuData target = data.getTarget();
                        if (data.getPortNeighbors() != null && !data.getPortNeighbors().isEmpty()) {
                            target.setNeighbors(data.getPortNeighbors());
                        }
                        onus.add(target);
                        log.info("Parsed target ONU: mac={}, oltIp={}, port={}", target.getMac(), target.getOltIp(), target.getPort());
                    }
                } else if (dataNode != null && dataNode.isArray()) {
                    onus = (List)this.objectMapper.readValue(dataNode.traverse(), (TypeReference)new TypeReference<List<OnuData>>(this){});
                } else if (dataNode == null && (onu = (OnuData)this.objectMapper.readValue(responseBody, OnuData.class)) != null && onu.getMac() != null) {
                    onus.add(onu);
                }
            }
            log.info("Parsed {} ONUs from response", onus.size());
            onus.sort((a, b) -> {
                if (a.getLastUpdate() == null && b.getLastUpdate() == null) {
                    return 0;
                }
                if (a.getLastUpdate() == null) {
                    return 1;
                }
                if (b.getLastUpdate() == null) {
                    return -1;
                }
                return b.getLastUpdate().compareTo(a.getLastUpdate());
            });
            for (int i = 0; i < onus.size(); ++i) {
                OnuData o = (OnuData)onus.get(i);
                log.info("ONU[{}]: mac={}, oltIp={}, port={}, onuId={}, status={}, lastUpdate={}", i, o.getMac(), o.getOltIp(), o.getPort(), o.getOnuId(), o.getStatus(), o.getLastUpdate());
            }
            if (onus.isEmpty()) {
                OnuSearchResult result = OnuSearchResult.error("ONU \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + (contractNumber != null ? contractNumber : String.valueOf(cid)));
                result.setContractNumber(contractNumber);
                result.setCid(cid);
                result.setOperator(operator);
                return result;
            }
            OnuSearchResult result = OnuSearchResult.success(onus);
            result.setContractNumber(contractNumber);
            result.setCid(cid);
            result.setOperator(operator);
            return result;
        }
        catch (Exception e) {
            log.error("Error parsing GetOLT response: {}", e.getMessage(), e);
            return OnuSearchResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043e\u0442\u0432\u0435\u0442\u0430");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefreshResult refreshPort(String oltIp, int portNumber) {
        if (!this.config.isConfigured()) {
            log.warn("GetOLT plugin is not configured", new Object[0]);
            return RefreshResult.error("GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            StringBuilder urlBuilder = new StringBuilder(this.config.getApiUrl());
            if (!urlBuilder.toString().endsWith("/")) {
                urlBuilder.append("/");
            }
            urlBuilder.append("actions/refresh/olt/").append(URLEncoder.encode(oltIp, StandardCharsets.UTF_8)).append("/port/").append(portNumber);
            String url = urlBuilder.toString();
            log.info("GetOLT refresh request: POST {}", url);
            int refreshTimeout = 30000;
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(refreshTimeout).setSocketTimeout(refreshTimeout).setConnectionRequestTimeout(refreshTimeout).build();
            try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();){
                JsonNode data;
                HttpPost request = new HttpPost(url);
                request.setHeader("X-API-Key", this.config.getApiKey());
                request.setHeader("Accept", "application/json");
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                log.info("GetOLT refresh response: status={}, body={}", statusCode, responseBody);
                if (statusCode >= 400) {
                    log.error("GetOLT refresh error: status={}, body={}", statusCode, responseBody);
                    RefreshResult refreshResult = RefreshResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f: " + statusCode);
                    return refreshResult;
                }
                JsonNode root = this.objectMapper.readTree(responseBody);
                boolean success = root.path("success").asBoolean(false);
                if (success && (data = root.get("data")) != null) {
                    String operationId = data.path("operationId").asText(null);
                    String status = data.path("status").asText(null);
                    String message = data.path("message").asText(null);
                    RefreshResult refreshResult = RefreshResult.success(operationId, status, message);
                    return refreshResult;
                }
                String errorMsg = root.path("message").asText("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
                RefreshResult refreshResult = RefreshResult.error(errorMsg);
                return refreshResult;
            }
        }
        catch (SocketTimeoutException e) {
            log.error("GetOLT refresh timeout: {}", e.getMessage());
            return RefreshResult.error("\u0421\u0435\u0440\u0432\u0438\u0441 GetOLT \u043d\u0435 \u043e\u0442\u0432\u0435\u0447\u0430\u0435\u0442");
        }
        catch (Exception e) {
            log.error("GetOLT refresh error", e);
            return RefreshResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefreshStatus getRefreshStatus(String oltIp) {
        if (!this.config.isConfigured()) {
            log.warn("GetOLT plugin is not configured", new Object[0]);
            return RefreshStatus.error("GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            StringBuilder urlBuilder = new StringBuilder(this.config.getApiUrl());
            if (!urlBuilder.toString().endsWith("/")) {
                urlBuilder.append("/");
            }
            urlBuilder.append("actions/status/olt/").append(URLEncoder.encode(oltIp, StandardCharsets.UTF_8));
            String url = urlBuilder.toString();
            log.debug("GetOLT status request: GET {}", url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.config.getApiTimeout()).setSocketTimeout(this.config.getApiTimeout()).setConnectionRequestTimeout(this.config.getApiTimeout()).build();
            try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();){
                JsonNode data;
                HttpGet request = new HttpGet(url);
                request.setHeader("X-API-Key", this.config.getApiKey());
                request.setHeader("Accept", "application/json");
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                log.debug("GetOLT status response: status={}, body={}", statusCode, responseBody);
                if (statusCode >= 400) {
                    log.error("GetOLT status error: status={}, body={}", statusCode, responseBody);
                    RefreshStatus refreshStatus = RefreshStatus.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430: " + statusCode);
                    return refreshStatus;
                }
                JsonNode root = this.objectMapper.readTree(responseBody);
                boolean success = root.path("success").asBoolean(false);
                if (success && (data = root.get("data")) != null) {
                    String status = data.path("status").asText("idle");
                    String message = data.path("message").asText(null);
                    RefreshStatus refreshStatus = RefreshStatus.success(status, message);
                    return refreshStatus;
                }
                RefreshStatus refreshStatus = RefreshStatus.success("idle", null);
                return refreshStatus;
            }
        }
        catch (SocketTimeoutException e) {
            log.error("GetOLT status timeout: {}", e.getMessage());
            return RefreshStatus.error("\u0421\u0435\u0440\u0432\u0438\u0441 GetOLT \u043d\u0435 \u043e\u0442\u0432\u0435\u0447\u0430\u0435\u0442");
        }
        catch (Exception e) {
            log.error("GetOLT status error", e);
            return RefreshStatus.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefreshResult rebootOnu(int oltId, int port, int onuId) {
        if (!this.config.isConfigured()) {
            log.warn("GetOLT plugin is not configured", new Object[0]);
            return RefreshResult.error("GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        try {
            String apiUrl;
            String baseUrl = apiUrl = this.config.getApiUrl();
            int externalIdx = apiUrl.indexOf("/v1/external");
            if (externalIdx > 0) {
                baseUrl = apiUrl.substring(0, externalIdx);
            }
            StringBuilder urlBuilder = new StringBuilder(baseUrl);
            urlBuilder.append("/olt/").append(oltId).append("/onu/").append(port).append("/").append(onuId).append("/reboot");
            String url = urlBuilder.toString();
            log.info("GetOLT reboot request: POST {}", url);
            int rebootTimeout = 30000;
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(rebootTimeout).setSocketTimeout(rebootTimeout).setConnectionRequestTimeout(rebootTimeout).build();
            try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();){
                HttpPost request = new HttpPost(url);
                request.setHeader("X-API-Key", this.config.getApiKey());
                request.setHeader("Accept", "application/json");
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                log.info("GetOLT reboot response: status={}, body={}", statusCode, responseBody);
                if (statusCode == 429) {
                    JsonNode root = this.objectMapper.readTree(responseBody);
                    Object errorMsg = root.path("error").asText("ONU \u043d\u0435\u0434\u0430\u0432\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u043b\u0430\u0441\u044c");
                    int remainingSeconds = root.path("remainingSeconds").asInt(0);
                    if (remainingSeconds > 0) {
                        int mins = remainingSeconds / 60;
                        int secs = remainingSeconds % 60;
                        errorMsg = "ONU \u043d\u0435\u0434\u0430\u0432\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u043b\u0430\u0441\u044c. \u041f\u043e\u0434\u043e\u0436\u0434\u0438\u0442\u0435 " + mins + " \u043c\u0438\u043d. " + secs + " \u0441\u0435\u043a.";
                    }
                    RefreshResult refreshResult = RefreshResult.error((String)errorMsg);
                    return refreshResult;
                }
                if (statusCode >= 400) {
                    log.error("GetOLT reboot error: status={}, body={}", statusCode, responseBody);
                    JsonNode root = this.objectMapper.readTree(responseBody);
                    String errorMsg = root.path("error").asText("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 ONU");
                    RefreshResult remainingSeconds = RefreshResult.error(errorMsg);
                    return remainingSeconds;
                }
                JsonNode root = this.objectMapper.readTree(responseBody);
                boolean success = root.path("success").asBoolean(false);
                if (success) {
                    String message = root.path("message").asText("ONU \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430");
                    RefreshResult refreshResult = RefreshResult.success(null, "completed", message);
                    return refreshResult;
                }
                String errorMsg = root.path("error").asText(root.path("message").asText("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430"));
                RefreshResult refreshResult = RefreshResult.error(errorMsg);
                return refreshResult;
            }
        }
        catch (SocketTimeoutException e) {
            log.error("GetOLT reboot timeout: {}", e.getMessage());
            return RefreshResult.error("\u0421\u0435\u0440\u0432\u0438\u0441 GetOLT \u043d\u0435 \u043e\u0442\u0432\u0435\u0447\u0430\u0435\u0442");
        }
        catch (Exception e) {
            log.error("GetOLT reboot error", e);
            return RefreshResult.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 ONU");
        }
    }
}

