/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bgb.getolt.action;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.Setup;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.msg.Message;
import org.bgerp.model.msg.config.MessageTypeConfig;
import org.bgerp.plugin.bgb.getolt.Config;
import org.bgerp.plugin.bgb.getolt.dao.GetOltApiClient;
import org.bgerp.plugin.bgb.getolt.dao.InetMacApiClient;
import org.bgerp.plugin.bgb.getolt.model.BillingConfig;
import org.bgerp.plugin.bgb.getolt.model.InetService;
import org.bgerp.plugin.bgb.getolt.model.MacUpdateResult;
import org.bgerp.plugin.bgb.getolt.model.OnuSearchResult;
import org.bgerp.plugin.bgb.getolt.model.RefreshResult;
import org.bgerp.plugin.bgb.getolt.model.RefreshStatus;
import org.bgerp.plugin.bgb.getolt.model.SessionDropResult;
import org.bgerp.util.Log;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.message.MessageTypeNote;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/getolt/getolt", pathId=true)
public class GetOltAction
extends BaseAction {
    private static final Log log = Log.getLog();
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/getolt";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        int processId = form.getParamInt("processId", 0);
        log.info("GetOltAction called for processId={}", processId);
        if (processId <= 0) {
            form.setResponseData("error", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d ID \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430");
            return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/getolt/onu_info.jsp");
        }
        Connection con = conSet.getConnection();
        Config config = Setup.getSetup().getConfig(Config.class);
        if (config == null || !config.isConfigured()) {
            log.warn("GetOLT plugin is not configured", new Object[0]);
            form.setResponseData("error", "GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
            return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/getolt/onu_info.jsp");
        }
        ProcessLinkDAO linkDao = new ProcessLinkDAO(con);
        List<CommonObjectLink> contractLinks = linkDao.getObjectLinksWithType(processId, "contract:%");
        if (contractLinks.isEmpty()) {
            form.setResponseData("error", "\u041d\u0435\u0442 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
            return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/getolt/onu_info.jsp");
        }
        CommonObjectLink contractLink = contractLinks.get(0);
        String billingId = this.extractBillingId(contractLink.getLinkObjectType());
        int cid = contractLink.getLinkObjectId();
        String contractNumber = contractLink.getLinkObjectTitle();
        log.info("Contract link found: billingId={}, cid={}, contractNumber={}", billingId, cid, contractNumber);
        String operator = this.resolveOperator(con, processId, billingId, config);
        log.info("Resolved operator: {} (billingMapping={})", operator, config.getBillingOperatorMapping(billingId));
        GetOltApiClient apiClient = new GetOltApiClient(config);
        OnuSearchResult result = apiClient.searchOnu(operator, contractNumber, cid);
        form.setResponseData("searchResult", result);
        form.setResponseData("contractNumber", contractNumber);
        form.setResponseData("cid", cid);
        form.setResponseData("operator", operator);
        form.setResponseData("billingId", billingId);
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/getolt/onu_info.jsp");
    }

    private String extractBillingId(String linkObjectType) {
        if (linkObjectType != null && linkObjectType.startsWith("contract:")) {
            return linkObjectType.substring("contract:".length());
        }
        return "default";
    }

    private String resolveOperator(Connection con, int processId, String billingId, Config config) {
        try {
            int valueId;
            String operator;
            ParamValueDAO paramDao = new ParamValueDAO(con);
            Set<Integer> operatorValues = paramDao.getParamList(processId, config.getOperatorParamId());
            if (!operatorValues.isEmpty() && (operator = config.getParamOperatorMapping(valueId = operatorValues.iterator().next().intValue())) != null && !operator.isEmpty()) {
                log.debug("Operator from process param: valueId={}, operator={}", valueId, operator);
                return operator;
            }
        }
        catch (Exception e) {
            log.debug("Error reading operator param: {}", e.getMessage());
        }
        String operator = config.getBillingOperatorMapping(billingId);
        if (operator != null && !operator.isEmpty()) {
            log.debug("Operator from billingId {}: {}", billingId, operator);
            return operator;
        }
        log.debug("Using default operator: {}", config.getDefaultOperator());
        return config.getDefaultOperator();
    }

    public ActionForward refreshPort(DynActionForm form, ConnectionSet conSet) throws Exception {
        String oltIp = form.getParam("oltIp");
        int portNumber = form.getParamInt("portNumber", 0);
        int processId = form.getParamInt("processId", 0);
        log.info("RefreshPort called: oltIp={}, portNumber={}, processId={}", oltIp, portNumber, processId);
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (oltIp == null || oltIp.isEmpty()) {
            response.put("success", false);
            response.put("message", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d IP OLT");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        if (portNumber <= 0) {
            response.put("success", false);
            response.put("message", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u0440\u0442\u0430");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        Config config = Setup.getSetup().getConfig(Config.class);
        if (config == null || !config.isConfigured()) {
            response.put("success", false);
            response.put("message", "GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        GetOltApiClient apiClient = new GetOltApiClient(config);
        RefreshResult result = apiClient.refreshPort(oltIp, portNumber);
        response.put("success", result.isSuccess());
        if (result.isSuccess()) {
            response.put("operationId", result.getOperationId());
            response.put("status", result.getStatus());
            response.put("message", result.getMessage());
            if (processId > 0) {
                this.createNote(conSet.getConnection(), form, processId, "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u0440\u0442\u0430 OLT\nOLT: " + oltIp + "\n\u041f\u043e\u0440\u0442: " + portNumber);
            }
        } else {
            response.put("message", result.getErrorMessage());
        }
        form.setResponseData("data", response);
        return this.json(conSet, form);
    }

    public ActionForward refreshStatus(DynActionForm form, ConnectionSet conSet) throws Exception {
        String oltIp = form.getParam("oltIp");
        log.debug("RefreshStatus called: oltIp={}", oltIp);
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (oltIp == null || oltIp.isEmpty()) {
            response.put("success", false);
            response.put("message", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d IP OLT");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        Config config = Setup.getSetup().getConfig(Config.class);
        if (config == null || !config.isConfigured()) {
            response.put("success", false);
            response.put("message", "GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        GetOltApiClient apiClient = new GetOltApiClient(config);
        RefreshStatus result = apiClient.getRefreshStatus(oltIp);
        response.put("success", result.isSuccess());
        if (result.isSuccess()) {
            response.put("status", result.getStatus());
            response.put("message", result.getMessage());
            response.put("completed", result.isCompleted());
        } else {
            response.put("message", result.getErrorMessage());
        }
        form.setResponseData("data", response);
        return this.json(conSet, form);
    }

    public ActionForward rebootOnu(DynActionForm form, ConnectionSet conSet) throws Exception {
        int oltId = form.getParamInt("oltId", 0);
        int port = form.getParamInt("port", 0);
        int onuId = form.getParamInt("onuId", 0);
        int processId = form.getParamInt("processId", 0);
        String mac = form.getParam("mac", "");
        log.info("RebootOnu called: oltId={}, port={}, onuId={}, processId={}", oltId, port, onuId, processId);
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (oltId <= 0) {
            response.put("success", false);
            response.put("message", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d ID OLT");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        if (port <= 0) {
            response.put("success", false);
            response.put("message", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u0440\u0442\u0430");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        if (onuId <= 0) {
            response.put("success", false);
            response.put("message", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d ID ONU");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        Config config = Setup.getSetup().getConfig(Config.class);
        if (config == null || !config.isConfigured()) {
            response.put("success", false);
            response.put("message", "GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        GetOltApiClient apiClient = new GetOltApiClient(config);
        RefreshResult result = apiClient.rebootOnu(oltId, port, onuId);
        response.put("success", result.isSuccess());
        if (result.isSuccess()) {
            response.put("message", result.getMessage());
            if (processId > 0) {
                StringBuilder noteText = new StringBuilder();
                noteText.append("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 ONU\n");
                noteText.append("\u041f\u043e\u0440\u0442/ONU ID: ").append(port).append("/").append(onuId);
                if (!mac.isEmpty()) {
                    noteText.append("\nMAC: ").append(mac);
                }
                this.createNote(conSet.getConnection(), form, processId, noteText.toString());
            }
        } else {
            response.put("message", result.getErrorMessage());
        }
        form.setResponseData("data", response);
        return this.json(conSet, form);
    }

    public ActionForward activateOnu(DynActionForm form, ConnectionSet conSet) throws Exception {
        int processId = form.getParamInt("processId", 0);
        String newMac = form.getParam("newMac", "");
        int serviceId = form.getParamInt("serviceId", 0);
        log.info("ActivateOnu called: processId={}, newMac={}, serviceId={}", processId, newMac, serviceId);
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (processId <= 0) {
            response.put("success", false);
            response.put("message", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d ID \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        if (newMac == null || newMac.isEmpty()) {
            response.put("success", false);
            response.put("message", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d MAC-\u0430\u0434\u0440\u0435\u0441");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        String normalizedMac = this.normalizeMac(newMac);
        if (!this.isValidMac(normalizedMac)) {
            response.put("success", false);
            response.put("message", "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 MAC-\u0430\u0434\u0440\u0435\u0441\u0430. \u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f: XX:XX:XX:XX:XX:XX");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        Connection con = conSet.getConnection();
        Config config = Setup.getSetup().getConfig(Config.class);
        if (config == null || !config.isConfigured()) {
            response.put("success", false);
            response.put("message", "GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        ProcessLinkDAO linkDao = new ProcessLinkDAO(con);
        List<CommonObjectLink> contractLinks = linkDao.getObjectLinksWithType(processId, "contract:%");
        if (contractLinks.isEmpty()) {
            response.put("success", false);
            response.put("message", "\u041d\u0435\u0442 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        CommonObjectLink contractLink = contractLinks.get(0);
        String billingId = this.extractBillingId(contractLink.getLinkObjectType());
        int cid = contractLink.getLinkObjectId();
        String contractNumber = contractLink.getLinkObjectTitle();
        log.info("Contract for activation: billingId={}, cid={}, contractNumber={}", billingId, cid, contractNumber);
        String operator = this.resolveOperator(con, processId, billingId, config);
        log.info("Operator for activation: {}", operator);
        BillingConfig billingConfig = config.getInetMacConfig(operator);
        if (billingConfig == null || !billingConfig.isConfigured()) {
            response.put("success", false);
            response.put("message", "InetMac API \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u0434\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: " + operator);
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        InetMacApiClient inetMacClient = new InetMacApiClient(billingConfig);
        MacUpdateResult updateResult = serviceId > 0 ? inetMacClient.updateMacAddress(serviceId, normalizedMac) : inetMacClient.updateMacByContractId(cid, normalizedMac);
        log.info("MAC update result: {}", updateResult);
        if (updateResult.isMultipleServices()) {
            response.put("success", false);
            response.put("status", "MULTIPLE_SERVICES");
            response.put("message", updateResult.getMessage());
            response.put("services", this.convertServicesToMap(updateResult.getServices()));
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        if (!updateResult.isSuccess()) {
            response.put("success", false);
            response.put("message", updateResult.getMessage());
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        SessionDropResult dropResult = null;
        if (updateResult.getServiceId() > 0) {
            dropResult = inetMacClient.dropSession(updateResult.getServiceId());
            log.info("Session drop result: {}", dropResult);
        }
        StringBuilder noteText = new StringBuilder();
        noteText.append("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f/\u0437\u0430\u043c\u0435\u043d\u0430 ONU\n");
        noteText.append("\u0414\u043e\u0433\u043e\u0432\u043e\u0440: ").append(contractNumber).append("\n");
        noteText.append("\u0421\u0442\u0430\u0440\u044b\u0439 MAC: ").append(updateResult.getOldMac() != null ? updateResult.getOldMac() : "-").append("\n");
        noteText.append("\u041d\u043e\u0432\u044b\u0439 MAC: ").append(normalizedMac);
        if (dropResult != null) {
            noteText.append("\n\u0421\u0435\u0441\u0441\u0438\u044f: ").append(dropResult.isSuccess() ? "\u0441\u0431\u0440\u043e\u0448\u0435\u043d\u0430" : "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c");
        }
        this.createNote(con, form, processId, noteText.toString());
        response.put("success", true);
        response.put("message", "MAC-\u0430\u0434\u0440\u0435\u0441 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0451\u043d");
        response.put("oldMac", updateResult.getOldMac());
        response.put("newMac", normalizedMac);
        response.put("serviceId", updateResult.getServiceId());
        if (dropResult != null) {
            response.put("sessionDropped", dropResult.isSuccess());
            response.put("sessionDropMessage", dropResult.getMessage());
        }
        form.setResponseData("data", response);
        return this.json(conSet, form);
    }

    public ActionForward getServices(DynActionForm form, ConnectionSet conSet) throws Exception {
        int processId = form.getParamInt("processId", 0);
        log.info("GetServices called: processId={}", processId);
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (processId <= 0) {
            response.put("success", false);
            response.put("message", "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d ID \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        Connection con = conSet.getConnection();
        Config config = Setup.getSetup().getConfig(Config.class);
        if (config == null || !config.isConfigured()) {
            response.put("success", false);
            response.put("message", "GetOLT \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        ProcessLinkDAO linkDao = new ProcessLinkDAO(con);
        List<CommonObjectLink> contractLinks = linkDao.getObjectLinksWithType(processId, "contract:%");
        if (contractLinks.isEmpty()) {
            response.put("success", false);
            response.put("message", "\u041d\u0435\u0442 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        CommonObjectLink contractLink = contractLinks.get(0);
        String billingId = this.extractBillingId(contractLink.getLinkObjectType());
        int cid = contractLink.getLinkObjectId();
        String operator = this.resolveOperator(con, processId, billingId, config);
        BillingConfig billingConfig = config.getInetMacConfig(operator);
        if (billingConfig == null || !billingConfig.isConfigured()) {
            response.put("success", false);
            response.put("message", "InetMac API \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u0434\u043b\u044f \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: " + operator);
            form.setResponseData("data", response);
            return this.json(conSet, form);
        }
        InetMacApiClient inetMacClient = new InetMacApiClient(billingConfig);
        List<InetService> services = inetMacClient.getServicesByContractId(cid);
        response.put("success", true);
        response.put("services", this.convertServicesToMap(services));
        form.setResponseData("data", response);
        return this.json(conSet, form);
    }

    private boolean isValidMac(String mac) {
        if (mac == null || mac.isEmpty()) {
            return false;
        }
        return mac.matches("^([0-9A-F]{2}:){5}[0-9A-F]{2}$");
    }

    private String normalizeMac(String mac) {
        if (mac == null || mac.isEmpty()) {
            return "";
        }
        String clean = mac.replaceAll("[:\\-\\s\\.]", "").toUpperCase();
        if (clean.length() != 12 || !clean.matches("^[0-9A-F]{12}$")) {
            return mac.toUpperCase();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 12; i += 2) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(clean.substring(i, i + 2));
        }
        return sb.toString();
    }

    private List<Map<String, Object>> convertServicesToMap(List<InetService> services) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (InetService svc : services) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("serviceId", svc.getServiceId());
            map.put("login", svc.getLogin());
            map.put("mac", svc.getMac());
            map.put("typeTitle", svc.getTypeTitle());
            map.put("statusTitle", svc.getStatusTitle());
            map.put("displayTitle", svc.getDisplayTitle());
            result.add(map);
        }
        return result;
    }

    private void createNote(Connection con, DynActionForm form, int processId, String text) {
        try {
            Setup setup = Setup.getSetup();
            MessageTypeConfig typeConfig = setup.getConfig(MessageTypeConfig.class);
            MessageTypeNote noteType = typeConfig.getMessageType(MessageTypeNote.class);
            if (noteType != null) {
                Message message = new Message();
                message.setTypeId(noteType.getId());
                message.setProcessId(processId);
                message.setSubject("GetOLT");
                message.setText(text);
                message.setFromTime(new Date());
                message.setUserId(form.getUserId());
                message.setToTime(new Date());
                message.setFrom("");
                message.setTo("");
                new MessageDAO(con).updateMessage(message);
                log.info("Created note in process {}: {}", processId, text.replace("\n", " "));
            } else {
                log.warn("MessageTypeNote not configured, cannot create note", new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("Failed to create note in process {}: {}", processId, e.getMessage());
        }
    }
}

