/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.event.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.event.iface.EventListener;
import org.bgerp.event.base.ClientEvent;
import ru.bgcrm.event.GetPoolTasksEvent;
import ru.bgcrm.util.sql.ConnectionSet;

public class LoginEventListener {
    private static final Map<Integer, List<ClientEvent>> onLoginEvents = new ConcurrentHashMap<Integer, List<ClientEvent>>();

    public LoginEventListener() {
        EventProcessor.subscribe(new EventListener<GetPoolTasksEvent>(){

            @Override
            public void notify(GetPoolTasksEvent e, ConnectionSet connectionSet) {
                LoginEventListener.this.processEvent(connectionSet, e);
            }
        }, GetPoolTasksEvent.class);
    }

    public static void addOnLoginEvent(int userId, ClientEvent event) {
        List<ClientEvent> eventList = onLoginEvents.get(userId);
        if (eventList == null) {
            eventList = new ArrayList<ClientEvent>();
            onLoginEvents.put(userId, eventList);
        }
        eventList.add(event);
    }

    private void processEvent(ConnectionSet connectionSet, GetPoolTasksEvent e) {
        List<ClientEvent> eventList = onLoginEvents.remove(e.getUser().getId());
        if (eventList != null) {
            for (ClientEvent event : eventList) {
                e.getForm().getResponse().addEvent(event);
            }
        }
    }
}

