/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.git.action.admin;

import java.util.List;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.custom.Custom;
import org.bgerp.util.RuntimeRunner;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/admin/plugin/git/custom", pathId=true)
public class CustomAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/git";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        if (Custom.DIR.exists() && Custom.DIR.isDirectory()) {
            RuntimeRunner runner = new RuntimeRunner("git", "status").directory(Custom.DIR);
            int code = runner.runSafe();
            List<String> stderr = runner.stdErr();
            List<String> stdout = runner.stdOut();
            this.log.debug("STDERR: {}\nSTDOUT: {}", String.join((CharSequence)"\n", stderr), String.join((CharSequence)"\n", stdout));
            String firstOutLine = Utils.getFirst(stdout);
            Object error = null;
            String branch = null;
            if (code != 0) {
                error = this.l.l("Process exit code: {}", code) + " " + Utils.getFirst(stderr);
            } else if (Utils.isBlankString(firstOutLine)) {
                error = "No GIT output";
            } else if (stdout.stream().filter(line -> line.contains("working tree clean")).findFirst().orElse(null) == null) {
                error = "Working tree is not clean";
            } else if (firstOutLine.startsWith("HEAD detached at ")) {
                branch = firstOutLine.substring(17);
            } else {
                error = "HEAD is not detached";
            }
            if (Utils.notBlankString((String)error)) {
                form.setResponseData("error", error);
            } else {
                form.setResponseData("branch", branch);
                runner = new RuntimeRunner("git", "show", "-s", "--format=%h%x20%ci%x20%s", "HEAD").directory(Custom.DIR).run();
                form.setResponseData("commit", Utils.getFirst(runner.stdOut()));
            }
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/git/custom/link.jsp");
    }

    public ActionForward update(DynActionForm form, ConnectionSet conSet) throws Exception {
        String branch = form.getParam("branch", Utils::notBlankString);
        new RuntimeRunner("git", "fetch").directory(Custom.DIR).run();
        new RuntimeRunner("git", "checkout", branch).directory(Custom.DIR).run();
        return this.json(conSet, form);
    }
}

