/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.svc.dba;

import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.plugin.svc.dba.model.db.Table;
import org.bgerp.plugin.svc.dba.model.db.UnusedColumn;

public class Config
extends org.bgerp.app.cfg.Config {
    private static final DateTimeFormatter PATTERN_YYYYMM = DateTimeFormatter.ofPattern("yyyyMM");
    private static final DateTimeFormatter PATTERN_YYYYMMDD = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final long cleanupOlderThanMonths;

    protected Config(ConfigMap config, boolean validate) {
        super(null);
        config = config.sub("dba:");
        this.cleanupOlderThanMonths = config.getSokLong(12L, "clean.older.than.months", "cleanup.month.tables.older.than.months");
    }

    public void dropCandidates(List<Table> tables, YearMonth month) {
        YearMonth borderYearMonth = month.minusMonths(this.cleanupOlderThanMonths);
        for (Table table : tables) {
            table.setDropCandidate(this.isDropCandidate(table.getName(), borderYearMonth));
            for (UnusedColumn column : table.getUnusedColumns()) {
                column.setDropCandidate(this.isDropCandidate(column.getName(), borderYearMonth));
            }
        }
    }

    private boolean isDropCandidate(String name, YearMonth borderYearMonth) {
        if (name.startsWith("_")) {
            try {
                YearMonth yearMonthDay = YearMonth.parse(StringUtils.substringAfterLast((String)name, (String)"_"), PATTERN_YYYYMMDD);
                return yearMonthDay.compareTo(borderYearMonth) < 0;
            }
            catch (DateTimeParseException yearMonthDay) {
                return true;
            }
        }
        try {
            YearMonth yearMonth = YearMonth.parse(StringUtils.substringAfterLast((String)name, (String)"_"), PATTERN_YYYYMM);
            return yearMonth.compareTo(borderYearMonth) < 0;
        }
        catch (DateTimeParseException dateTimeParseException) {
            return false;
        }
    }
}

