/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Date;
import java.util.List;
import org.bgerp.model.Pageable;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.Period;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.proto.dao.BillingModuleDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.rscm.RscmService;

public class RscmDAO
extends BillingModuleDAO {
    private static final String RSCM_MODULE_ID = "ru.bitel.bgbilling.modules.rscm";

    public RscmDAO(User user, String billingId, int moduleId) {
        super(user, billingId, moduleId);
    }

    public RscmDAO(User user, DBInfo dbInfo, int moduleId) {
        super(user, dbInfo.getId(), moduleId);
    }

    public void getServices(Pageable<RscmService> result, int contractId, Date dateFrom, Date dateTo) {
        RequestJsonRpc req = new RequestJsonRpc(RSCM_MODULE_ID, this.moduleId, "RSCMService", "searchRSCMContractService");
        req.setParamContractId(contractId);
        req.setParam("period", new Period(dateFrom, dateTo));
        req.setParam("page", result.getPage());
        JsonNode ret = this.transferData.postDataReturn(req, this.user);
        List serviceList = (List)this.readJsonValue(ret.findValue("list").traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, RscmService.class));
        result.getList().addAll(serviceList);
        result.getPage().setData((Page)this.jsonMapper.convertValue((Object)ret.findValue("page"), Page.class));
    }

    public RscmService getService(int contractId, int contractServiceId) {
        RequestJsonRpc req = new RequestJsonRpc(RSCM_MODULE_ID, this.moduleId, "RSCMService", "getRSCMContractService");
        req.setParamContractId(contractId);
        req.setParam("rscmContractServiceId", contractServiceId);
        JsonNode ret = this.transferData.postDataReturn(req, this.user);
        return (RscmService)this.jsonMapper.convertValue((Object)ret, RscmService.class);
    }

    public void updateService(RscmService service) {
        RequestJsonRpc req = new RequestJsonRpc(RSCM_MODULE_ID, this.moduleId, "RSCMService", "updateRSCMContractService");
        req.setParam("rscmContractService", service);
        this.transferData.postData(req, this.user);
    }

    public void deleteService(int contractId, int contractServiceId, Date month) {
        RequestJsonRpc req = new RequestJsonRpc(RSCM_MODULE_ID, this.moduleId, "RSCMService", "deleteRSCMContractService");
        req.setParamContractId(contractId);
        req.setParam("rscmContractServiceId", contractServiceId);
        req.setParam("month", month);
        this.transferData.postData(req, this.user);
    }
}

