/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.bgerp.app.exception.BGException;
import org.bgerp.model.base.IdTitle;
import org.bgerp.util.Log;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.tariff.ContractPersonalTariff;
import ru.bgcrm.plugin.bgbilling.proto.model.tariff.ContractTariff;
import ru.bgcrm.plugin.bgbilling.proto.model.tariff.ContractTariffGroup;
import ru.bgcrm.plugin.bgbilling.proto.model.tariff.ContractTariffOption;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class ContractTariffDAO
extends BillingDAO {
    private static final Log log = Log.getLog();
    private static final String TARIFF_SERVICE_MODULE_ID = "ru.bitel.bgbilling.kernel.tariff";
    private static final String TARIFF_OPTION_SERVICE_MODULE_ID = "ru.bitel.bgbilling.kernel.tariff.option";
    private static final String CONTRACT_MODULE_ID = "contract";
    private static final String TARIFF_OPTION_MODULE_ID = "tariff.option";
    private static final String CONTRACT_TARIFF_MODULE_ID = "contract.tariff";

    public ContractTariffDAO(User user, String billingId) {
        super(user, billingId);
    }

    public ContractTariffDAO(User user, DBInfo dbInfo) {
        super(user, dbInfo);
    }

    public void addTariffPlan(int contractId, int tariffId, int position) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            ContractTariff contractTariff = new ContractTariff();
            contractTariff.setContractId(contractId);
            contractTariff.setTariffPlanId(tariffId);
            contractTariff.setDateFrom(new Date());
            contractTariff.setPosition(position);
            this.contractTariffUpdate(contractTariff);
        } else {
            Request billingRequest = new Request();
            billingRequest.setModule(CONTRACT_MODULE_ID);
            billingRequest.setAction("UpdateContractTariffPlan");
            billingRequest.setAttribute("id", 0);
            billingRequest.setAttribute("pos", position);
            billingRequest.setAttribute("cid", contractId);
            billingRequest.setAttribute("tpid", tariffId);
            billingRequest.setAttribute("date1", new SimpleDateFormat("dd.MM.yyyy").format(new Date()));
            billingRequest.setAttribute("comment", "");
            this.transferData.postData(billingRequest, this.user);
        }
    }

    public void setTariffPlan(int contractId, int tariffId) {
        List<ContractTariff> list = this.contractTariffList(contractId);
        ContractTariff contractTariff = null;
        if (list.isEmpty()) {
            contractTariff = new ContractTariff();
            contractTariff.setContractId(contractId);
            contractTariff.setTariffPlanId(tariffId);
            contractTariff.setDateFrom(new Date());
        } else {
            contractTariff = list.get(0);
            contractTariff.setTariffPlanId(tariffId);
        }
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            this.contractTariffUpdate(contractTariff);
        } else {
            Request billingRequest = new Request();
            billingRequest.setModule(CONTRACT_MODULE_ID);
            billingRequest.setAction("UpdateContractTariffPlan");
            billingRequest.setAttribute("id", String.valueOf(contractTariff.getId()));
            billingRequest.setAttribute("cid", contractId);
            billingRequest.setAttribute("tpid", tariffId);
            billingRequest.setAttribute("date1", TimeUtils.format(contractTariff.getDateFrom(), "dd.MM.yyyy"));
            billingRequest.setAttribute("comment", "");
            this.transferData.postData(billingRequest, this.user);
        }
    }

    public List<ContractTariff> contractTariffList(int contractId) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractTariffService", "contractTariffList");
            req.setParamContractId(contractId);
            req.setParam(this.dbInfo.versionCompare("9.2410") >= 0 ? "entityModuleId" : "entityMid", 0);
            req.setParam("entityId", 0);
            List result = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, ContractTariff.class));
            this.setTariffPlanTitles(result);
            return result;
        }
        Request request = new Request();
        request.setModule(CONTRACT_MODULE_ID);
        request.setAction("ContractTariffPlans");
        request.setContractId(contractId);
        Document document = this.transferData.postData(request, this.user);
        ArrayList<ContractTariff> contractTariffList = new ArrayList<ContractTariff>();
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("row");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            ContractTariff tariff = new ContractTariff();
            tariff.setId(Utils.parseInt(rowElement.getAttribute("id")));
            tariff.setTariffPlanId(Utils.parseInt(rowElement.getAttribute("f1")));
            tariff.setTitle(rowElement.getAttribute("f2"));
            tariff.setDateFrom(TimeUtils.parse(rowElement.getAttribute("date1"), "ymd"));
            tariff.setDateTo(TimeUtils.parse(rowElement.getAttribute("date2"), "ymd"));
            tariff.setPosition(Utils.parseInt(rowElement.getAttribute("pos")));
            tariff.setComment(rowElement.getAttribute("comment"));
            contractTariffList.add(tariff);
        }
        return contractTariffList;
    }

    private void setTariffPlanTitles(Iterable<ContractTariff> list) {
        TreeMap<Integer, String> titles = new TreeMap<Integer, String>();
        for (ContractTariff contractTariff : list) {
            contractTariff.setTitle(titles.computeIfAbsent(contractTariff.getTariffPlanId(), tariffPlanId -> {
                try {
                    RequestJsonRpc req = new RequestJsonRpc(TARIFF_SERVICE_MODULE_ID, "TariffService", "tariffPlanGet");
                    req.setParam("id", tariffPlanId);
                    IdTitle plan = (IdTitle)this.jsonMapper.convertValue((Object)this.transferData.postDataReturn(req, this.user), IdTitle.class);
                    return plan != null && plan.getTitle() != null ? plan.getTitle() : "??? [" + tariffPlanId + "]";
                }
                catch (BGException e) {
                    log.error(e);
                    return e.getMessage() + ":" + tariffPlanId;
                }
            }));
        }
    }

    private void contractTariffUpdate(ContractTariff contractTariff) {
        RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractTariffService", "contractTariffUpdate");
        req.setParam("contractTariff", contractTariff);
        this.transferData.postData(req, this.user);
    }

    public ContractTariff getContractTariffPlan(int id, int moduleId, int contractId, boolean useFilter, boolean showUsed, boolean contractGroupFilter, List<IdTitle> tariffList) {
        ContractTariff result = null;
        Request request = new Request();
        request.setModule(CONTRACT_MODULE_ID);
        request.setAction("ContractTariffPlan");
        request.setContractId(contractId);
        if (id <= 0) {
            request.setAttribute("id", "new");
        } else {
            request.setAttribute("id", id);
        }
        if (moduleId > 0) {
            request.setAttribute("mid", moduleId);
        }
        request.setAttribute("useFilter", Utils.booleanToStringInt(useFilter));
        request.setAttribute("showUsed", Utils.booleanToStringInt(showUsed));
        request.setAttribute("tariffGroupFilter", Utils.booleanToStringInt(contractGroupFilter));
        Document doc = this.transferData.postData(request, this.user);
        Element tariffPlanEl = XMLUtils.selectElement(doc, "/data/tariffPlan");
        if (tariffPlanEl != null) {
            result = new ContractTariff();
            result.setId(id);
            result.setTariffPlanId(Utils.parseInt(tariffPlanEl.getAttribute("tpid")));
            result.setDateFrom(TimeUtils.parse(tariffPlanEl.getAttribute("date1"), "ymd"));
            result.setDateTo(TimeUtils.parse(tariffPlanEl.getAttribute("date2"), "ymd"));
            result.setComment(tariffPlanEl.getAttribute("comment"));
            result.setPosition(Utils.parseInt(tariffPlanEl.getAttribute("pos")));
        }
        if (tariffList != null) {
            for (Element rowElement : XMLUtils.selectElements(doc, "/data/tariffPlans/item")) {
                IdTitle tariffPlan = new IdTitle();
                tariffPlan.setId(Utils.parseInt(rowElement.getAttribute("id")));
                tariffPlan.setTitle(rowElement.getAttribute("title"));
                tariffList.add(tariffPlan);
            }
        }
        return result;
    }

    @Deprecated
    public ContractTariff getContractTariffPlan(int id, int moduleId, int contractId, boolean useFilter, boolean showUsed, List<IdTitle> tariffList) {
        return this.getContractTariffPlan(id, moduleId, contractId, useFilter, showUsed, false, tariffList);
    }

    public void updateContractTariffPlan(int contractId, int id, int tpid, int position, String dateFrom, String dateTo, String comment) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            ContractTariff contractTariff = new ContractTariff();
            contractTariff.setContractId(contractId);
            contractTariff.setId(id);
            contractTariff.setTariffPlanId(tpid);
            contractTariff.setPosition(position);
            contractTariff.setDateFrom(TimeUtils.parse(dateFrom, "dd.MM.yyyy"));
            contractTariff.setDateTo(TimeUtils.parse(dateTo, "dd.MM.yyyy"));
            contractTariff.setComment(comment);
            this.contractTariffUpdate(contractTariff);
        } else {
            Request request = new Request();
            request.setModule(CONTRACT_MODULE_ID);
            request.setAction("UpdateContractTariffPlan");
            if (id > 0) {
                request.setAttribute("id", id);
            } else {
                request.setAttribute("id", "new");
            }
            request.setContractId(contractId);
            request.setAttribute("tpid", tpid);
            request.setAttribute("pos", position);
            request.setAttribute("date1", dateFrom);
            request.setAttribute("date2", dateTo);
            request.setAttribute("comment", comment);
            this.transferData.postData(request, this.user);
        }
    }

    public void deleteContractTariffPlan(int contractId, int id) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractTariffService", "contractTariffDelete");
            req.setParamContractId(contractId);
            req.setParam("id", id);
            this.transferData.postData(req, this.user);
        } else {
            Request request = new Request();
            request.setModule(CONTRACT_MODULE_ID);
            request.setAction("DeleteContractTariffPlan");
            request.setContractId(contractId);
            request.setAttribute("id", id);
            this.transferData.postData(request, this.user);
        }
    }

    @Deprecated
    public List<ContractTariffGroup> contractTariffGroupList(int contractId) {
        return this.contractTariffGroupList(contractId, false);
    }

    @Deprecated
    private List<ContractTariffGroup> contractTariffGroupList(int contractId, boolean active) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            return Collections.emptyList();
        }
        Request request = new Request();
        request.setModule(CONTRACT_MODULE_ID);
        request.setAction("ContractTariffGroupTable");
        request.setContractId(contractId);
        Document document = this.transferData.postData(request, this.user);
        ArrayList<ContractTariffGroup> contractTariffGroupList = new ArrayList<ContractTariffGroup>();
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("row");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            ContractTariffGroup tariffGroup = new ContractTariffGroup();
            tariffGroup.setId(Utils.parseInt(rowElement.getAttribute("id")));
            tariffGroup.setTitle(rowElement.getAttribute("tariff_group"));
            TimeUtils.parsePeriod(rowElement.getAttribute("period"), tariffGroup);
            tariffGroup.setComment(rowElement.getAttribute("comment"));
            if (active) {
                if (tariffGroup.getDateTo() == null) continue;
                contractTariffGroupList.add(tariffGroup);
                continue;
            }
            contractTariffGroupList.add(tariffGroup);
        }
        return contractTariffGroupList;
    }

    @Deprecated
    public ContractTariffGroup getContractTariffGroup(int id) {
        Request request = new Request();
        request.setModule(CONTRACT_MODULE_ID);
        request.setAction("GetContractTariffGroup");
        request.setAttribute("id", id);
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("contract_tariff_group");
        ContractTariffGroup tariffGroup = new ContractTariffGroup();
        if (nodeList.getLength() > 0) {
            Element rowElement = (Element)nodeList.item(0);
            tariffGroup.setId(id);
            tariffGroup.setDateFrom(TimeUtils.parse(rowElement.getAttribute("date1"), "ymd"));
            tariffGroup.setDateTo(TimeUtils.parse(rowElement.getAttribute("date2"), "ymd"));
            tariffGroup.setComment(rowElement.getAttribute("comment"));
            tariffGroup.setGroupId(Utils.parseInt(rowElement.getAttribute("tariff_group")));
        }
        return tariffGroup;
    }

    @Deprecated
    public void updateContractTariffGroup(int id, int contractId, int tariffGroupId, Date dateFrom, Date dateTo, String comment) {
        Request request = new Request();
        request.setModule(CONTRACT_MODULE_ID);
        request.setAction("UpdateContractTariffGroup");
        request.setContractId(contractId);
        request.setAttribute("tariff_group", tariffGroupId);
        request.setAttribute("date1", TimeUtils.format(dateFrom, "dd.MM.yyyy"));
        request.setAttribute("date2", TimeUtils.format(dateTo, "dd.MM.yyyy"));
        request.setAttribute("comment", comment);
        if (id <= 0) {
            request.setAttribute("id", "new");
        } else {
            request.setAttribute("id", id);
        }
        this.transferData.postData(request, this.user);
    }

    @Deprecated
    public void updateContractTariffGroup(int contractId, int id, int tariffGroupId, String dateFrom, String dateTo, String comment) {
        this.updateContractTariffGroup(id, contractId, tariffGroupId, TimeUtils.parse(dateFrom, "yyyy-MM-dd"), TimeUtils.parse(dateTo, "yyyy-MM-dd"), comment);
    }

    public void deleteContractTariffGroup(int tariffId) {
        Request request = new Request();
        request.setModule(CONTRACT_MODULE_ID);
        request.setAction("DeleteContractTariffGroup");
        request.setAttribute("id", tariffId);
        this.transferData.postData(request, this.user);
    }

    public List<ContractTariffOption> contractTariffOptionList(int contractId) {
        ArrayList<ContractTariffOption> list = new ArrayList();
        if (this.dbInfo.versionCompare("6.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(TARIFF_OPTION_SERVICE_MODULE_ID, "TariffOptionService", "contractTariffOptionList");
            req.setParamContractId(contractId);
            req.setParam("date", new Date());
            list = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, ContractTariffOption.class));
        } else {
            Request request = new Request();
            request.setModule(TARIFF_OPTION_MODULE_ID);
            request.setAction("ContractTariffOption");
            request.setAttribute("operation", "list");
            request.setContractId(contractId);
            Document document = this.transferData.postData(request, this.user);
            Element dataElement = document.getDocumentElement();
            NodeList nodeList = dataElement.getElementsByTagName("item");
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element rowElement = (Element)nodeList.item(index);
                ContractTariffOption tariffOption = this.convertFromElement(rowElement);
                list.add(tariffOption);
            }
        }
        return list;
    }

    public List<ContractTariffOption> contractTariffOptionHistory(int contractId) {
        ArrayList<ContractTariffOption> list = new ArrayList();
        if (this.dbInfo.versionCompare("6.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(TARIFF_OPTION_SERVICE_MODULE_ID, "TariffOptionService", "contractTariffOptionHistory");
            req.setParamContractId(contractId);
            req.setParam("web", false);
            list = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, ContractTariffOption.class));
        } else {
            Request request = new Request();
            request.setModule(TARIFF_OPTION_MODULE_ID);
            request.setAction("ContractTariffOption");
            request.setAttribute("operation", "history");
            request.setContractId(contractId);
            Document document = this.transferData.postData(request, this.user);
            Element dataElement = document.getDocumentElement();
            NodeList nodeList = dataElement.getElementsByTagName("item");
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element rowElement = (Element)nodeList.item(index);
                ContractTariffOption tariffOption = this.convertFromElement(rowElement);
                list.add(tariffOption);
            }
        }
        return list;
    }

    private ContractTariffOption convertFromElement(Element rowElement) {
        ContractTariffOption tariffOption = new ContractTariffOption();
        tariffOption.setId(Utils.parseInt(rowElement.getAttribute("id")));
        tariffOption.setActivatedTime(TimeUtils.parse(rowElement.getAttribute("activatedTime"), "yyyy-MM-dd'T'HH:mm:ss"));
        tariffOption.setActivateMode(Utils.parseInt(rowElement.getAttribute("activatedMode")));
        tariffOption.setChargeId(Utils.parseInt(rowElement.getAttribute("chargeId")));
        tariffOption.setContractId(Utils.parseInt(rowElement.getAttribute("contractId")));
        tariffOption.setOptionId(Utils.parseInt(rowElement.getAttribute("optionId")));
        tariffOption.setOptionTitle(rowElement.getAttribute("optionTitle"));
        tariffOption.setSumma(Utils.parseBigDecimal(rowElement.getAttribute("summa")));
        tariffOption.setTimeFrom(TimeUtils.parse(rowElement.getAttribute("timeFrom"), "yyyy-MM-dd'T'HH:mm:ss"));
        tariffOption.setTimeTo(TimeUtils.parse(rowElement.getAttribute("timeTo"), "yyyy-MM-dd'T'HH:mm:ss"));
        tariffOption.setUserId(Utils.parseInt(rowElement.getAttribute("userId")));
        tariffOption.setUserTitle(rowElement.getAttribute("userTitle"));
        return tariffOption;
    }

    public List<IdTitle> contractAvailableOptionList(int contractId) {
        List<IdTitle> availableOptionList = new ArrayList<IdTitle>();
        if (this.dbInfo.versionCompare("6.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(TARIFF_OPTION_SERVICE_MODULE_ID, "TariffOptionService", "tariffOptionListAvailable");
            req.setParamContractId(contractId);
            req.setParam("onlyAvailable", false);
            req.setParam("web", false);
            availableOptionList = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
        } else {
            Request request = new Request();
            request.setModule(TARIFF_OPTION_MODULE_ID);
            request.setAction("ContractTariffOption");
            request.setAttribute("operation", "availableOptionList");
            request.setContractId(contractId);
            Document document = this.transferData.postData(request, this.user);
            for (Element rowElement : XMLUtils.selectElements(document, "/data/data/item")) {
                IdTitle type = new IdTitle();
                type.setId(Utils.parseInt(rowElement.getAttribute("id")));
                type.setTitle(rowElement.getAttribute("title"));
                availableOptionList.add(type);
            }
        }
        return availableOptionList;
    }

    public List<IdTitle> activateModeList(int contractId, int optionId) {
        ArrayList<IdTitle> activateModeList = new ArrayList();
        if (this.dbInfo.versionCompare("6.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(TARIFF_OPTION_SERVICE_MODULE_ID, "TariffOptionService", "tariffOptionActivateModeList");
            req.setParamContractId(contractId);
            req.setParam("optionId", optionId);
            activateModeList = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
        } else {
            Request request = new Request();
            request.setModule(TARIFF_OPTION_MODULE_ID);
            request.setAction("TariffOption");
            request.setAttribute("operation", "activateModeList");
            request.setAttribute("option_id", optionId);
            Document document = this.transferData.postData(request, this.user);
            for (Element rowElement : XMLUtils.selectElements(document, "/data/data/item")) {
                IdTitle type = new IdTitle();
                type.setId(Utils.parseInt(rowElement.getAttribute("id")));
                type.setTitle(rowElement.getAttribute("modeTitle"));
                activateModeList.add(type);
            }
        }
        return activateModeList;
    }

    public void activateContractOption(int contractId, int optionId, int modeId, boolean web) {
        if (this.dbInfo.versionCompare("6.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(TARIFF_OPTION_SERVICE_MODULE_ID, "TariffOptionService", "contractTariffOptionActivate");
            req.setParamContractId(contractId);
            req.setParam("optionId", optionId);
            req.setParam("modeId", modeId);
            req.setParam("web", false);
            this.transferData.postData(req, this.user);
        } else {
            Request request = new Request();
            request.setModule(TARIFF_OPTION_MODULE_ID);
            request.setAction("ContractTariffOption");
            request.setAttribute("operation", "activate");
            request.setAttribute("mode_id", modeId);
            request.setAttribute("option_id", optionId);
            request.setContractId(contractId);
            this.transferData.postData(request, this.user);
        }
    }

    public void reactivateContractOption(int contractId, int id) {
        Request request = new Request();
        request.setModule(TARIFF_OPTION_MODULE_ID);
        request.setAction("ContractTariffOption");
        request.setAttribute("operation", "reactivate");
        request.setAttribute("id", id);
        request.setContractId(contractId);
        this.transferData.postData(request, this.user);
    }

    public void deactivateContractOption(int contractId, int id) {
        if (this.dbInfo.versionCompare("6.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(TARIFF_OPTION_SERVICE_MODULE_ID, "TariffOptionService", "contractTariffOptionDeactivate");
            req.setParamContractId(contractId);
            req.setParam("contractOptionId", id);
            this.transferData.postData(req, this.user);
        } else {
            Request request = new Request();
            request.setModule(TARIFF_OPTION_MODULE_ID);
            request.setAction("ContractTariffOption");
            request.setAttribute("operation", "deactivate");
            request.setAttribute("id", id);
            request.setContractId(contractId);
            this.transferData.postData(request, this.user);
        }
    }

    public List<ContractPersonalTariff> contractPersonalTariffList(int contractId) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractTariffService", "personalTariffList");
            req.setParam("contractId", contractId);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            return (List)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, ContractPersonalTariff.class));
        }
        Request request = new Request();
        request.setModule(CONTRACT_TARIFF_MODULE_ID);
        request.setAction("PersonalTariffTable");
        request.setContractId(contractId);
        Document document = this.transferData.postData(request, this.user);
        ArrayList<ContractPersonalTariff> contractPersonalTariffList = new ArrayList<ContractPersonalTariff>();
        for (Element rowElement : XMLUtils.selectElements(document, "/data/table/data/row")) {
            ContractPersonalTariff personalTariff = new ContractPersonalTariff();
            personalTariff.setId(Utils.parseInt(rowElement.getAttribute("id")));
            TimeUtils.parsePeriod(rowElement.getAttribute("period"), personalTariff);
            personalTariff.setPos(Utils.parseInt(rowElement.getAttribute("pos")));
            personalTariff.setTitle(rowElement.getAttribute("title"));
            personalTariff.setTreeId(Utils.parseInt(rowElement.getAttribute("tree_id")));
            contractPersonalTariffList.add(personalTariff);
        }
        return contractPersonalTariffList;
    }

    public ContractPersonalTariff getPersonalTariff(int id) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractTariffService", "personalTariffGet");
            req.setParam("id", id);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            return (ContractPersonalTariff)this.jsonMapper.convertValue((Object)ret, ContractPersonalTariff.class);
        }
        Request request = new Request();
        request.setModule(CONTRACT_TARIFF_MODULE_ID);
        request.setAction("GetPersonalTariff");
        request.setAttribute("id", id);
        Document document = this.transferData.postData(request, this.user);
        ContractPersonalTariff personalTariff = new ContractPersonalTariff();
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("tariff");
        if (nodeList.getLength() > 0) {
            Element rowElement = (Element)nodeList.item(0);
            personalTariff.setId(id);
            personalTariff.setDate1(TimeUtils.parse(rowElement.getAttribute("date1"), "ymd"));
            personalTariff.setDate2(TimeUtils.parse(rowElement.getAttribute("date2"), "ymd"));
            personalTariff.setPos(Utils.parseInt(rowElement.getAttribute("pos")));
            personalTariff.setTitle(rowElement.getAttribute("title"));
            personalTariff.setTreeId(Utils.parseInt(rowElement.getAttribute("tree_id")));
        }
        return personalTariff;
    }

    public void deleteContractPersonalTariff(int contractId, int id) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractTariffService", "personalTariffDelete");
            req.setParam("contractId", contractId);
            req.setParam("personalTariffId", id);
            this.transferData.postDataReturn(req, this.user);
        } else {
            Request request = new Request();
            request.setModule(CONTRACT_TARIFF_MODULE_ID);
            request.setAction("DeletePersonalTariff");
            request.setAttribute("operation", "deactivate");
            request.setAttribute("id", id);
            request.setContractId(contractId);
            this.transferData.postData(request, this.user);
        }
    }

    public void updateContractPersonalTariff(int contractId, int tariffId, String title, int position, String dateFrom, String dateTo) {
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            ContractPersonalTariff personalTariff = this.getPersonalTariff(tariffId);
            personalTariff = personalTariff != null ? personalTariff : new ContractPersonalTariff();
            personalTariff.setContractId(contractId);
            personalTariff.setTitle(title);
            personalTariff.setPos(position);
            personalTariff.setDate1(TimeUtils.parse(dateFrom, "ymd"));
            personalTariff.setDate2(TimeUtils.parse(dateTo, "ymd"));
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.api", "ContractTariffService", "personalTariffUpdate");
            req.setParam("contractId", contractId);
            req.setParam("personalTariff", personalTariff);
            this.transferData.postDataReturn(req, this.user);
        } else {
            Request request = new Request();
            request.setModule(CONTRACT_TARIFF_MODULE_ID);
            request.setAction("UpdatePersonalTariff");
            request.setAttribute("id", tariffId);
            request.setContractId(contractId);
            request.setAttribute("title", title);
            request.setAttribute("pos", position);
            request.setAttribute("date1", dateFrom);
            request.setAttribute("date2", dateTo);
            this.transferData.postData(request, this.user);
        }
    }
}

